/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.database.AJCreateDBModule;
import de.netcomputing.database.DBCreateConnection;
import de.netcomputing.database.DBExplorer;
import de.netcomputing.database.DBQueryNode;
import de.netcomputing.database.DBRootNode;
import de.netcomputing.database.DBScript;
import de.netcomputing.database.DBStatementBuilder;
import de.netcomputing.database.TableCategoryNode;
import de.netcomputing.database.TableNode;
import de.netcomputing.database.metadata.DBGenerationContext;
import de.netcomputing.database.metadata.DBMetaData;
import de.netcomputing.modeller.ModelWithPropsPanel;
import de.netcomputing.templates.engine.TemplateExecutor;
import de.netcomputing.util.NCProperties;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Vector;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.INCExtendedPrintout;
import netcomputing.tools.INCPrintOut;
import netcomputing.tools.Platforms;

public class AJDBServices {
    static AJDBServices This = new AJDBServices();

    public static AJDBServices This() {
        return This;
    }

    public void RegisterServices() {
        JEBasicService ser = new JEBasicService("Database", "Select *", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof TableNode;
            }

            public void doProcess(Object selection, Object selector) {
                TableNode tn = (TableNode)selection;
                INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("SELECT * " + tn.getTableName());
                out.setWrapLines(false);
                out.clear();
                try {
                    Connection con = tn.getConnection();
                    Statement st = con.createStatement();
                    ResultSet rst = null;
                    String stat = "SELECT * FROM " + tn.getTableName();
                    if (tn.getSchema().length() == 0) {
                        stat = "SELECT * FROM " + tn.getTableName();
                    } else {
                        stat = "SELECT * FROM " + tn.getSchema() + "." + tn.getTableName();
                        stat = "SELECT * FROM " + tn.getTableName();
                    }
                    rst = st.executeQuery(stat);
                    AJDBServices.this.dumpResult(rst, stat, out);
                }
                catch (Exception e) {
                    out.printLine(e.getMessage());
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Database", "Connection Properties", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof DBRootNode;
            }

            public void doProcess(Object selection, Object selector) {
                JListPanel listPanel = (JListPanel)selector;
                DBRootNode tn = null;
                tn = selection instanceof DBRootNode ? (DBRootNode)selection : ((TableCategoryNode)selection).getRoot();
                DBCreateConnection dbc = DBCreateConnection.Open(EditApp.App.getMainWindow(), tn);
                if (dbc != null) {
                    try {
                        tn.getConnection().close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    DBRootNode dbRoot = new DBRootNode();
                    dbRoot.setDbDriver(dbc.driverNameTxt.getText());
                    dbRoot.setClassPath(dbc.driverJar.getText());
                    dbRoot.setDbName(dbc.dbUrlTxt.getText());
                    dbRoot.setPwd(dbc.pwdTxt.getText());
                    dbRoot.setUser(dbc.userTxt.getText());
                    int sel = listPanel.getSelectionIndex();
                    listPanel.collapseNodeAt(sel);
                    listPanel.removeAt(sel);
                    listPanel.insertItemRepaintingAt(sel, dbRoot);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Database", "Add SQL Statement", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof DBRootNode;
            }

            public void doProcess(Object selection, Object selector) {
                JListPanel listPanel = (JListPanel)selector;
                DBRootNode tn = (DBRootNode)selection;
                DBStatementBuilder.Open(tn);
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Database", "Remove SQL Statement", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof DBQueryNode;
            }

            public void doProcess(Object selection, Object selector) {
                JListPanel listPanel = (JListPanel)selector;
                DBQueryNode tn = (DBQueryNode)selection;
                tn.getRoot().remQuery(tn);
                DBExplorer.This.update();
            }
        };
        EditApp.ServReg.addService(ser);
        if (Platforms.IsBeta()) {
            ser = new JEBasicService("Database", "Open in DB Modeller", 1){

                public boolean canProcess(Object selection, Object selector) {
                    return selection instanceof File && ((File)selection).getName().endsWith("dbm");
                }

                public void doProcess(Object selection, Object selector) {
                    ModelWithPropsPanel.Open((File)selection);
                }
            };
            EditApp.ServReg.addService(ser);
        }
        ser = new JEBasicService("Database", "Execute SQL Statement", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof DBQueryNode;
            }

            public void doProcess(Object selection, Object selector) {
                JListPanel listPanel = (JListPanel)selector;
                DBQueryNode tn = (DBQueryNode)selection;
                INCExtendedPrintout out = JEBatchHostFrame.This().createOutput(tn.getName());
                out.clear();
                out.setWrapLines(false);
                AJDBServices.this.executeStatement(tn.getRoot().getConnection(), tn.getQuery(), out);
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Database", "Edit SQL Statement", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof DBQueryNode;
            }

            public void doProcess(Object selection, Object selector) {
                JListPanel listPanel = (JListPanel)selector;
                DBQueryNode tn = (DBQueryNode)selection;
                DBStatementBuilder.Open(tn);
            }
        };
        EditApp.ServReg.addService(ser);
        if (Platforms.IsBeta()) {
            ser = new JEBasicService("Database", "Execute SQL Script", 1){

                public boolean canProcess(Object selection, Object selector) {
                    return selection instanceof File && ((File)selection).getName().endsWith(".sql");
                }

                public void doProcess(Object selection, Object selector) {
                    JWidgetsUtil.AddLongRunningJob(new Runnable(this, selection){
                        private final /* synthetic */ Object val$selection;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$selection = val$selection;
                        }

                        public void run() {
                            INCExtendedPrintout out = JEBatchHostFrame.This().createOutput(((File)this.val$selection).getName());
                            out.clear();
                            new DBScript(out).execute((File)this.val$selection);
                        }
                    });
                }
            };
            EditApp.ServReg.addService(ser);
            ser = new JEBasicService("Database", "Create Database Module", 1){

                public boolean canProcess(Object selection, Object selector) {
                    return true;
                }

                public void doProcess(Object selection, Object selector) {
                    AJCreateDBModule.Open();
                }
            };
            EditApp.ServReg.addService(ser);
            ser = new JEBasicService("Database", "Run Generator Template", 1){

                public boolean canProcess(Object selection, Object selector) {
                    return selection instanceof TableNode || selection instanceof TableCategoryNode;
                }

                public void doProcess(Object selection, Object selector) {
                    JWidgetsUtil.AddLongRunningJob(new Runnable(this, selection){
                        private final /* synthetic */ Object val$selection;
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$selection = val$selection;
                        }

                        public void run() {
                            try {
                                IListItem[] tables = null;
                                tables = this.val$selection instanceof TableNode ? new IListItem[]{(TableNode)this.val$selection} : ((TableCategoryNode)this.val$selection).contents();
                                File f = AJDBServices.This().findDBContext();
                                if (f == null) {
                                    AJCreateDBModule.Open();
                                    f = AJDBServices.This().findDBContext();
                                }
                                INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("TExec");
                                out.clear();
                                out.printLine("Using DBContext in:" + f.getParent());
                                File genRoot = f.getParentFile();
                                File tpl = new File(genRoot, "templates");
                                DBRootNode root = ((TableNode)tables[0]).getRoot();
                                Connection con = ((TableNode)tables[0]).getConnection();
                                DBGenerationContext ctx = new DBGenerationContext(con, tpl, new DBMetaData(con));
                                ctx.setConnectInfo(root.getDbDriver(), root.getDbName(), root.getUser(), root.getPwd(), root.getClassPath());
                                HashSet<E> ignore = new HashSet<E>();
                                int i = 0;
                                while (i < tables.length) {
                                    TableNode tn = (TableNode)tables[i];
                                    try {
                                        11.access$000(this.this$1).runTableTemplate(genRoot, ctx, tpl, tn, ignore);
                                    }
                                    catch (Exception ex) {
                                        NCStringUtilities.DumpException(JEBatchHostFrame.This().createOutput("TExec"), ex);
                                        ex.printStackTrace(Tracer.This);
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception ex) {
                                NCStringUtilities.DumpException(JEBatchHostFrame.This().createOutput("TExec"), ex);
                                ex.printStackTrace(Tracer.This);
                            }
                        }
                    });
                }

                static /* synthetic */ AJDBServices access$000(11 x0) {
                    return x0.AJDBServices.this;
                }
            };
            EditApp.ServReg.addService(ser);
        }
    }

    void runTableTemplate(File genRoot, DBGenerationContext ctx, File tpl, TableNode tn, HashSet ignore) throws Exception {
        ctx.setCurrentTable(ctx.getDbMetaData().findTable(tn.getType(), tn.getSchema(), tn.getTableName()));
        INCExtendedPrintout pout = JEBatchHostFrame.This().createOutput("TExec");
        NCProperties defaultProps = new NCProperties();
        FileInputStream in = new FileInputStream(tpl + File.separator + ".." + File.separator + "default.properties");
        defaultProps.load(in);
        in.close();
        String templates = defaultProps.getProperty("invoke");
        if (templates == null) {
            pout.printLine("no template defined in default.properties. Pls add 'invoke=MyTemplate' property");
            return;
        }
        Vector v = NCStringUtilities.SplitSeparatedString(",", templates);
        int i = 0;
        while (i < v.size()) {
            String templateName = "" + v.get(i);
            String tplProps = tpl + File.separator + ".." + File.separator + "templates" + File.separator + templateName + ".properties";
            if (!new File(tplProps).exists()) {
                pout.printLine("Missing propertyfile for template:" + new File(tplProps).getAbsolutePath());
                return;
            }
            NCProperties pTpl = new NCProperties(defaultProps);
            in = new FileInputStream(tplProps);
            pTpl.load(in);
            in.close();
            File tabPropFile = new File(tpl + File.separator + ".." + File.separator + "properties" + File.separator + tn.getTableName() + ".properties");
            if (!tabPropFile.exists()) {
                FileOutputStream out = new FileOutputStream(tabPropFile);
                out.write("#put table specific properties here \n\n".getBytes());
                out.write("#e.g. query.PrimaryKey =PKCOLUMNA,PKCOLUMNAB,..\n".getBytes());
                out.write("#     query.Name=PKCOLUMNAB,..\n".getBytes());
                out.write("#     query.MyQuery=PKCOLUMNAB,..\n".getBytes());
            }
            NCProperties p = new NCProperties(pTpl);
            in = new FileInputStream(tabPropFile);
            p.load(in);
            in.close();
            ctx.setCurrentProps(p);
            if (!(p.getProperty("ignore", "").equals("true") || pTpl.getProperty("scope", "TABLE").equals("DB") && ignore.contains(templateName))) {
                ignore.add(templateName);
                String pack = p.getProperty("package", "").replace('.', File.separatorChar);
                File target = new File(genRoot, "genout" + File.separator + pack + File.separator + tn.getTableName() + templateName + ".java");
                target.getParentFile().mkdirs();
                ctx.setResultFileName(target.getName());
                TemplateExecutor exec = new TemplateExecutor(new File(genRoot, "tmp").getAbsolutePath());
                exec.setFiles(new File(genRoot, "templates" + File.separator + templateName + ".jpl"), target, ctx);
                if (exec.execute()) {
                    File realTarget = new File(target.getParentFile(), ctx.getResultFileName());
                    realTarget.delete();
                    if (!target.renameTo(realTarget)) {
                        System.gc();
                        Runtime.getRuntime().runFinalization();
                        realTarget.delete();
                        if (!target.renameTo(realTarget)) {
                            pout.printLine("FAILED TO RENAME (FILE LOCKED ?):" + target.getAbsolutePath() + " to " + realTarget.getAbsolutePath());
                        } else {
                            pout.printLine("created:" + realTarget.getAbsolutePath());
                        }
                    } else {
                        pout.printLine("created:" + realTarget.getAbsolutePath() + " from " + templateName);
                    }
                }
            }
            ++i;
        }
    }

    public File findDBContext() {
        Vector v = EditApp.App.getAllDirs();
        int i = 0;
        while (i < v.size()) {
            String dir = (String)v.get(i);
            File f = new File(dir, "dbmodule.prp");
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    void executeStatement(Connection conn, String statement, INCExtendedPrintout out) {
        try {
            Statement st = conn.createStatement();
            st.execute(statement);
            ResultSet rs = st.getResultSet();
            out.printLine("");
            out.printLine("");
            this.dumpResult(rs, "executing SQL statement...", out);
            DBExplorer.This.update();
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex) {
            out.printLine("EXCEPTION:" + ex.getClass().getName());
            out.printLine("          " + ex.getMessage());
            ex.printStackTrace(Tracer.This);
        }
    }

    void dumpResult(ResultSet rst, String stat, INCPrintOut out) throws Exception {
        if (stat != null) {
            out.printLine(stat);
        }
        if (rst == null) {
            out.printLine("RESULT == NULL");
            return;
        }
        StringBuffer res = new StringBuffer(1000);
        int sum = 0;
        int i = 1;
        while (i <= rst.getMetaData().getColumnCount()) {
            String tmp = rst.getMetaData().getColumnLabel(i);
            res.append(tmp);
            int w = Math.min(rst.getMetaData().getColumnDisplaySize(i), 100) + 1;
            if (tmp.length() >= w) {
                tmp = tmp.substring(0, w);
            }
            int ii = 0;
            while (ii < w - tmp.length() % w) {
                res.append(" ");
                ++ii;
            }
            res.setLength(sum + w - 1);
            res.append(" ");
            sum += w;
            ++i;
        }
        out.printLine(res.toString());
        int len = res.length();
        res.setLength(0);
        int i2 = 0;
        while (i2 < len) {
            res.append("-");
            ++i2;
        }
        out.printLine(res.toString());
        while (rst.next()) {
            try {
                res.setLength(0);
                int i3 = 1;
                while (i3 <= rst.getMetaData().getColumnCount()) {
                    String tmp = rst.getString(i3);
                    if (tmp == null) {
                        tmp = "NULL";
                    }
                    res.append(tmp);
                    int w = Math.min(rst.getMetaData().getColumnDisplaySize(i3), 100) + 1;
                    if (tmp.length() >= w && w > 6) {
                        tmp = tmp.substring(0, w - 5) + " [..]";
                    }
                    int ii = 0;
                    while (ii < w - tmp.length() % w) {
                        res.append(" ");
                        ++ii;
                    }
                    ++i3;
                }
                out.printLine(res.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }
}

