/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.database.BasicDBNode;
import de.netcomputing.database.DBCreateConnection;
import de.netcomputing.database.DBQueryNode;
import de.netcomputing.database.TableCategoryNode;
import de.netcomputing.database.TableNode;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCProperties;
import java.awt.Image;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import netcomputing.beans.NCClassloader;

public class DBRootNode
extends BasicDBNode {
    NCClassloader loader = new NCClassloader();
    String dbName = "";
    String dbDriver = "";
    String user = "";
    String pwd = "";
    String classPath;
    ArrayList queries = new ArrayList(3);
    IListItem[] cont;
    Image img;

    public DBRootNode(String aDBName, String aDriverName) {
        this.dbName = aDBName;
        this.dbDriver = aDriverName;
    }

    public DBRootNode() {
    }

    public void setQueries(ArrayList queries) {
        this.queries = queries;
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public Connection getConnection() {
        try {
            this.connect();
            return this.connection;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void connect() throws Exception {
        if (this.connection == null) {
            this.loader.setClassPath(NCFileUtilities.GetPathAsVector(this.getClassPath()));
            Driver dr = (Driver)DBCreateConnection.DriverToInstance.get(this.dbDriver);
            System.out.println("== CONNECTING TO DB:" + this.dbName);
            if (dr == null) {
                dr = (Driver)Class.forName(this.dbDriver, false, this.loader).newInstance();
                DBCreateConnection.DriverToInstance.put(this.dbDriver, dr);
            }
            NCProperties prps = new NCProperties();
            prps.put("user", this.user);
            prps.put("password", this.pwd);
            this.connection = dr.connect(this.dbName, prps);
        }
    }

    public IListItem[] contents() {
        try {
            if (this.connection == null) {
                this.connect();
            }
            DatabaseMetaData meta = this.connection.getMetaData();
            HashMap typeToTable = new HashMap();
            ResultSet tabs = meta.getTables(null, null, "%", null);
            while (tabs.next()) {
                String tabType = tabs.getString("TABLE_TYPE");
                String tabName = tabs.getString("TABLE_NAME");
                ArrayList<TableNode> tables = (ArrayList<TableNode>)typeToTable.get(tabType);
                if (tables == null) {
                    tables = new ArrayList<TableNode>();
                    typeToTable.put(tabType, tables);
                }
                TableNode node = new TableNode(this, this.connection);
                node.initFrom(tabs);
                tables.add(node);
            }
            tabs.close();
            this.connection.commit();
            this.cont = new IListItem[typeToTable.size() + this.queries.size()];
            ArrayList cats = new ArrayList();
            cats.addAll(typeToTable.keySet());
            Collections.sort(cats);
            int i = 0;
            while (i < cats.size()) {
                ArrayList catContArr = (ArrayList)typeToTable.get(cats.get(i));
                IListItem[] catCont = new IListItem[catContArr.size()];
                int ii = 0;
                while (ii < catContArr.size()) {
                    catCont[ii] = (IListItem)catContArr.get(ii);
                    ++ii;
                }
                TableCategoryNode catNode = new TableCategoryNode(this.connection, "" + cats.get(i), catCont, this);
                this.cont[i] = catNode;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.queries.size()) {
                this.cont[i2 + cats.size()] = (DBQueryNode)this.queries.get(i2);
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
        }
        return this.cont;
    }

    public String getDisplayString() {
        return this.dbName;
    }

    public Image getImage() {
        if (this.img == null) {
            this.img = NCApplication.GetImage("/de/netcomputing/database/images/connection.gif");
        }
        return this.img;
    }

    public void addQuery(DBQueryNode query) {
        this.queries.add(query);
    }

    public void remQuery(DBQueryNode query) {
        this.queries.remove(query);
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }
}

