/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import Jxe.completers.SqlCompleter;
import Jxe.highlighters.SqlHighlighter;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.beans.NCEditor;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.database.AJDBServices;
import de.netcomputing.database.DBExplorer;
import de.netcomputing.database.DBQueryNode;
import de.netcomputing.database.DBRootNode;
import de.netcomputing.database.DBStatementBuilderGUI;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.List;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.INCExtendedPrintout;

public class DBStatementBuilder
extends JPanel {
    NCButton addBtn;
    JLabel titleLabel;
    NCButton applyBtn;
    NCButton cancelBtn;
    NCTreeBean columnList;
    NCTreeBean tableList;
    NCEditor editPanel;
    DBRootNode conn;
    DBQueryNode qNode;

    public static void Open(DBRootNode dn) {
        DBStatementBuilder dbsb = new DBStatementBuilder();
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Execute SQL", false);
        dbsb.init(dn, null, null);
        dlg.getContentPane().add(dbsb);
        dlg.pack();
        ApplicationHelper.Singleton().centerWindow(dlg);
        dbsb.getRootPane().setDefaultButton(dbsb.applyBtn);
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }

    public static void Open(DBQueryNode dn) {
        DBStatementBuilder dbsb = new DBStatementBuilder();
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Execute SQL", false);
        dbsb.init(dn.getRoot(), dn, null);
        dlg.getContentPane().add(dbsb);
        dlg.pack();
        ApplicationHelper.Singleton().centerWindow(dlg);
        dbsb.getRootPane().setDefaultButton(dbsb.applyBtn);
        dbsb.addBtn.setLabel("Ok");
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }

    public DBStatementBuilder() {
        this.initGui();
    }

    public void initGui() {
        new DBStatementBuilderGUI().createGui(this);
        this.tableList.binderDoubleClick().addTarget(this, "actionTableDClick");
        this.tableList.binder().addTarget(this, "actionTableClick");
        this.columnList.binderDoubleClick().addTarget(this, "actionColDClick");
        this.editPanel.getDocument().setHighlighter(new SqlHighlighter());
        this.editPanel.getDocument().setCompletionProvider(new SqlCompleter());
    }

    public Object actionTableDClick(Object arg, Object sen) {
        this.editPanel.getDocument().insertAndMove(this.tableList.getSelectedObject().toString());
        return null;
    }

    public Object actionColDClick(Object arg, Object sen) {
        this.editPanel.getDocument().insertAndMove(this.columnList.getSelectedObject().toString());
        return null;
    }

    public Object actionTableClick(Object arg, Object sen) {
        try {
            if (this.tableList.getSelectedItem() == null) {
                return null;
            }
            this.columnList.clear();
            Statement st = this.conn.getConnection().createStatement();
            boolean b = false;
            st.execute("SELECT * FROM " + this.tableList.getSelectedString());
            ResultSet rs = st.getResultSet();
            ResultSetMetaData md = rs.getMetaData();
            int i = 1;
            while (i <= md.getColumnCount()) {
                String name = md.getColumnName(i);
                this.columnList.addLine(name);
                ++i;
            }
            rs.close();
            this.columnList.sortByString(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void init(DBRootNode connection, DBQueryNode qn, List connections) {
        this.conn = connection;
        this.qNode = qn;
        this.titleLabel.setText(this.conn.getDisplayString());
        if (qn != null) {
            this.editPanel.getDocument().readFromByteArrayNoReplace(qn.getQuery().getBytes());
        }
        try {
            ResultSet tabs = this.conn.getConnection().getMetaData().getTables(null, null, "%", null);
            while (tabs.next()) {
                if (!"TABLE".equals(tabs.getString("TABLE_TYPE"))) continue;
                String cat = tabs.getString("TABLE_SCHEM");
                cat = cat == null ? "" : cat + ".";
                this.tableList.addLine(cat + tabs.getString("TABLE_NAME"));
            }
            this.tableList.sortByString();
            this.editPanel.getDocument().highlightAll();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DBStatementBuilder.this.qNode == null) {
                    String name = Confirm.GetText((Window)DBStatementBuilder.this.getTopLevelAncestor(), null, "Query Name ?", new String[0]);
                    if (name != null) {
                        DBStatementBuilder.this.conn.addQuery(new DBQueryNode(DBStatementBuilder.this.conn, DBStatementBuilder.this.editPanel.getDocument().toString(), name));
                        ((Window)DBStatementBuilder.this.getTopLevelAncestor()).dispose();
                        DBExplorer.This.update();
                    }
                } else {
                    DBStatementBuilder.this.qNode.setQuery(DBStatementBuilder.this.editPanel.getDocument().toString());
                    ((Window)DBStatementBuilder.this.getTopLevelAncestor()).dispose();
                }
            }
        });
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("SQL Execution");
        out.setWrapLines(false);
        AJDBServices.This.executeStatement(this.conn.getConnection(), this.editPanel.getDocument().toString(), out);
    }
}

