/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.database.BasicDBNode;
import java.awt.Image;
import java.sql.Connection;
import java.sql.ResultSetMetaData;

public class TableColumnNode
extends BasicDBNode {
    String tableName;
    IListItem[] content;
    Image img;

    public TableColumnNode(Connection con, String tableName, ResultSetMetaData meta, int index) {
        super(con);
        this.tableName = tableName;
        this.content = new IListItem[8];
        try {
            this.content[0] = new ListItem("CatalogName - " + meta.getCatalogName(index));
        }
        catch (Throwable ex) {
            this.content[0] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        try {
            this.content[1] = new ListItem("ColumnClassName - " + meta.getColumnClassName(index));
        }
        catch (Throwable ex) {
            this.content[1] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        try {
            this.content[2] = new ListItem("ColumnLabel - " + meta.getColumnLabel(index));
        }
        catch (Throwable ex) {
            this.content[2] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        String res = "";
        try {
            if (meta.isNullable(index) == 1) {
                res = res + "NULLABLE ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isNullable ";
        }
        try {
            if (meta.isWritable(index)) {
                res = res + "WRITABLE ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isWritable ";
        }
        try {
            if (meta.isSearchable(index)) {
                res = res + "SEARCHABLE ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isSearchable ";
        }
        try {
            if (meta.isCaseSensitive(index)) {
                res = res + "CASESENSITIVE ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isCaseSensitive ";
        }
        try {
            if (meta.isAutoIncrement(index)) {
                res = res + "AUTOINC ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isAutoIncrement ";
        }
        try {
            if (meta.isSigned(index)) {
                res = res + "SIGNED ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isSigned ";
        }
        try {
            if (meta.isCurrency(index)) {
                res = res + "ISCURRENCY ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isCurrency ";
        }
        try {
            if (!meta.isDefinitelyWritable(index)) {
                res = res + "NOT_DEFINITELY_WRITABLE ";
            }
        }
        catch (Throwable ex) {
            res = res + "EXC:isNullable ";
        }
        this.content[3] = new ListItem(res);
        try {
            this.content[4] = new ListItem("TypeName - " + meta.getColumnTypeName(index));
        }
        catch (Throwable ex) {
            this.content[4] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        try {
            this.content[5] = new ListItem("Precision - " + meta.getPrecision(index));
        }
        catch (Throwable ex) {
            this.content[5] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        try {
            this.content[6] = new ListItem("Scale - " + meta.getScale(index));
        }
        catch (Throwable ex) {
            this.content[6] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
        try {
            this.content[7] = new ListItem("SchemaName - " + meta.getSchemaName(index));
        }
        catch (Throwable ex) {
            this.content[7] = new ListItem(ex.getClass().getName() + ":" + ex.getMessage());
        }
    }

    public String getDisplayString() {
        return this.tableName;
    }

    public IListItem[] contents() {
        return this.content;
    }

    public Image getImage() {
        if (this.img == null) {
            this.img = NCApplication.GetImage("/de/netcomputing/database/images/column.gif");
        }
        return this.img;
    }
}

