/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.devchat;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.IListPanelDragDelegate;
import de.netcomputing.anyj.jwidgets.IntValue;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.application.services.NCCustomPopupGetter;
import de.netcomputing.communication.INCCommunicationCallback;
import de.netcomputing.communication.INCCommunicationCalls;
import de.netcomputing.communication.NCBroadcaster;
import de.netcomputing.devchat.AJDevChatGUI;
import de.netcomputing.devchat.AJDevChatItem;
import de.netcomputing.devchat.AJUserItem;
import de.netcomputing.devchat.DevChatItemProps;
import de.netcomputing.devchat.NCUserData;
import de.netcomputing.devchat.NCUserRegistry;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import netcomputing.tools.PropWriter;

public class AJDevChat
extends NCPanel
implements INCCommunicationCallback,
IListPanelDragDelegate {
    static AJDevChat This;
    public static String[] mypop;
    JButton stopBtn;
    JButton runBtn;
    JButton refreshBtn;
    DevChatItemProps itemProps;
    JSplitPane split;
    NCTreeBean listPanel;
    NCUserRegistry ncuRegistry = new NCUserRegistry();
    INCCommunicationCalls network;
    static String User;
    static String Personal;
    static String Public;
    AJDevChatItem users;
    AJDevChatItem personal;
    AJDevChatItem pub;
    AJDevChatItem trash;
    HashMap deletedItems = new HashMap(500);
    ListItem lastSel;

    public static AJDevChat This() {
        if (This == null) {
            This = new AJDevChat();
            NCBroadcaster ncbCaster = new NCBroadcaster(This);
            This.setNetwork(ncbCaster);
        }
        return This;
    }

    public AJDevChat() {
        This = this;
        this.initGUI();
        this.users = new AJDevChatItem(1, User, "", "", "", 1, "SYSTEM_ID");
        this.personal = new AJDevChatItem(2, Personal, "", "", "", 1, "SYSTEM_ID");
        this.pub = new AJDevChatItem(3, Public, "", "", "", 1, "SYSTEM_ID");
        this.trash = new AJDevChatItem(3, "Trash", "", "", "", 1, "SYSTEM_ID");
        this.pub.setRead(true);
        this.personal.setRead(true);
        this.users.setRead(true);
        this.trash.setRead(true);
        this.pub.setIsDir(true);
        this.personal.setIsDir(true);
        this.users.setIsDir(true);
        this.trash.setIsDir(true);
        EditApp.AdjustSplitPane(this.split);
        this.split.setTopComponent(this.listPanel);
        this.split.setBottomComponent(this.itemProps);
        this.split.setDividerLocation(200);
        this.listPanel.addItem(this.getUsers());
        this.listPanel.addItem(this.getPersonal());
        this.listPanel.addItem(this.getPublic());
        this.listPanel.addItem(this.trash);
        this.listPanel.binder().addTarget(this, "actionListSel");
        this.listPanel.binderIconClick().addTarget(this, "actionIconClick");
        this.listPanel.setPopUpGetter(new NCCustomPopupGetter(EditApp.ServReg, mypop));
        KeyAdapter enterOkAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    AJDevChat.this.okBtn_actionPerformed(null);
                    AJDevChat.this.listPanel.requestFocus();
                    ke.consume();
                }
            }
        };
        this.itemProps.subject.addKeyListener(enterOkAdapter);
        this.itemProps.isDir.addKeyListener(enterOkAdapter);
        this.itemProps.finish.addKeyListener(enterOkAdapter);
        this.itemProps.duration.addKeyListener(enterOkAdapter);
        this.itemProps.done.addKeyListener(enterOkAdapter);
        this.itemProps.tabbedPane.addKeyListener(enterOkAdapter);
        this.itemProps.text.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10 && ke.isControlDown()) {
                    AJDevChat.this.okBtn_actionPerformed(null);
                    AJDevChat.this.listPanel.requestFocus();
                    ke.consume();
                }
            }
        });
        this.listPanel.setDragEnabled(true);
        this.listPanel.setDragDelegate(this);
        this.split.setResizeWeight(1.0);
        this.listPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10) {
                    ev.consume();
                    if (ev.isShiftDown()) {
                        AJDevChat.this.itemProps.isDir.setSelected(true);
                        AJDevChat.this.okBtn_actionPerformed(null);
                        AJDevChat.this.newBtn_actionPerformed(null);
                    } else if (ev.isControlDown()) {
                        AJDevChat.this.okBtn_actionPerformed(null);
                        AJDevChat.this.newBtn_actionPerformed(null);
                        AJDevChat.this.itemProps.finish.setSelected(true);
                    } else {
                        AJDevChat.this.newBtn_actionPerformed(null);
                    }
                } else if (ev.getKeyCode() == 127) {
                    AJDevChat.this.delBtn_actionPerformed(null);
                }
            }
        });
    }

    public synchronized ListItem getUsers() {
        return this.users;
    }

    public synchronized ListItem getPersonal() {
        return this.personal;
    }

    public synchronized ListItem getPublic() {
        return this.pub;
    }

    public synchronized void initGUI() {
        new AJDevChatGUI().createGui(this);
    }

    public synchronized String getUserKey() {
        try {
            return System.getProperty("user.name");
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            return "LocalUser";
        }
    }

    public synchronized boolean canDrag(IListItem it) {
        return !this.isBuiltInItem((ListItem)it) && it instanceof AJDevChatItem;
    }

    public synchronized boolean canDrop(IListItem target, IListItem dragged) {
        int tarIdx = this.listPanel.getList().indexOf(target);
        if (this.listPanel.findParentObject(tarIdx, dragged.getDepth() + 1) == dragged) {
            return false;
        }
        return target != this.users;
    }

    public synchronized void move(IListItem target, IListItem dragged) {
        IListItem ilItem = this.listPanel.getSelectedItem();
        if (target instanceof AJUserItem) {
            try {
                AJUserItem aju = (AJUserItem)target;
                this.network.sendSingle(aju.getUserData().getHost(), aju.getUserData().getPort(), "ASSIGN", ((AJDevChatItem)dragged).getSerializedString(this.findParentFor(((AJDevChatItem)dragged).getId()).getId()));
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        } else {
            this.move(target, dragged, true);
        }
        this.listPanel.setSelectedItem(ilItem);
    }

    public void sendToUserInstances(NCUserData user, String command, String data) {
        this.sendToUserInstances(user.getName(), null, command, data);
    }

    public void sendToUserInstances(String name, String host, String command, String data) {
        List list = this.ncuRegistry.findUsersForKeys(name, host);
        int i = 0;
        while (i < list.size()) {
            NCUserData ncud = (NCUserData)list.get(i);
            try {
                this.network.sendSingle(ncud.getHost(), ncud.getPort(), command, data);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            ++i;
        }
    }

    public void sendMessage(AJUserItem target, String msg) {
        if (target == null) {
            try {
                this.network.sendMulti("MESSAGE", " [to all] " + AJDevChatItem.qt(msg));
                EditFrame.Status().addMessage(" [to all] <i>" + AJDevChatItem.qt(msg) + "</i>", false);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        } else {
            try {
                this.sendToUserInstances(target.getUserData(), "MESSAGE", " " + AJDevChatItem.qt(msg));
                EditFrame.Status().addMessage(" <i>" + AJDevChatItem.qt(msg) + "</i>", false);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        }
    }

    public synchronized void move(IListItem target, IListItem dragged, boolean send) {
        if (target != dragged) {
            ((AJDevChatItem)dragged).incVersionRec(1);
            this.listPanel.collapseNode(dragged);
            int draggedID = ((AJDevChatItem)dragged).getId();
            int targetID = ((AJDevChatItem)target).getId();
            AJDevChatItem par = this.findParentFor(draggedID);
            AJDevChatItem draggedRoot = this.findRoot(par.getId());
            if (draggedRoot == null) {
                draggedRoot = (AJDevChatItem)this.listPanel.findParentObject(par, 1);
            }
            AJDevChatItem temp = (AJDevChatItem)dragged;
            if (draggedRoot == this.trash) {
                this.delItem(draggedID, temp.getVersion(), true, true);
            } else {
                this.delItem(draggedID, temp.getVersion(), false, true);
            }
            AJDevChatItem newPar = (AJDevChatItem)target;
            if (((AJDevChatItem)target).getIsDir()) {
                ((ListItem)target).insertItemBefore(0, temp);
            } else {
                newPar = this.findParentFor(targetID);
                int i = 0;
                while (i < newPar.contents().length) {
                    AJDevChatItem ajdcItem = (AJDevChatItem)newPar.contents()[i];
                    if (ajdcItem.getId() == targetID) {
                        newPar.insertItemBefore(i, temp);
                        break;
                    }
                    ++i;
                }
            }
            AJDevChatItem targetRoot = this.findRoot(newPar.getId());
            if (targetRoot == null) {
                targetRoot = (AJDevChatItem)this.listPanel.findParentObject(newPar, 1);
            }
            if (send) {
                if (targetRoot != this.trash && draggedRoot == this.trash) {
                    temp.setOwnerIDRecursive(this.getUserKey());
                    try {
                        this.network.sendMulti("UPDATEITEM", temp.getSerializedString(newPar.getId()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    this.sendSubTree(temp);
                    send = false;
                } else if (targetRoot == this.trash && draggedRoot != this.trash) {
                    ((AJDevChatItem)dragged).setOwnerIDRecursive("Trash");
                    this.sendDelItem(draggedID, ((AJDevChatItem)dragged).getVersion(), true);
                    send = false;
                } else if (draggedRoot == this.personal && targetRoot == this.pub) {
                    Tracer.This.println("PERS => PUB");
                    try {
                        this.network.sendMulti("UPDATEITEM", temp.getSerializedString(newPar.getId()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    this.sendSubTree(temp);
                    send = false;
                } else if (draggedRoot == this.pub && targetRoot == this.pub) {
                    Tracer.This.println("PUB => PUB");
                } else if (draggedRoot == this.pub && targetRoot == this.personal) {
                    Tracer.This.println("PUB => PERS");
                    temp.setOwnerIDRecursive(this.getUserKey());
                    temp.incVersion();
                    try {
                        this.network.sendMulti("UPDATEITEM", temp.getSerializedString(newPar.getId()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    this.sendSubTree(temp);
                    send = false;
                } else if (draggedRoot == this.personal && targetRoot == this.personal) {
                    Tracer.This.println("PERS => PERS");
                } else {
                    Tracer.This.println("FAILED ROOT DETECTION");
                }
            }
            if (send) {
                try {
                    this.sendMove(targetID, draggedID);
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            this.listPanel.collapseAndExpandAllByIndentity();
        }
    }

    public synchronized boolean isNetworkOnline() {
        return ((NCBroadcaster)this.network).isInitialized() && ((NCBroadcaster)this.network).isRunning();
    }

    public synchronized void setNetwork(INCCommunicationCalls inccCalls) {
        this.network = inccCalls;
    }

    public void initNetwork() throws Exception {
        ((NCBroadcaster)this.network).init();
        this.network.pingUsers();
    }

    public synchronized AJDevChatItem findParentFor(int id) {
        AJDevChatItem ajdcItem = this.findParentForInternal(this.personal, id);
        if (ajdcItem == null) {
            ajdcItem = this.findParentForInternal(this.pub, id);
        }
        if (ajdcItem == null) {
            ajdcItem = this.findParentForInternal(this.trash, id);
        }
        return ajdcItem;
    }

    public synchronized AJDevChatItem findParentForInternal(AJDevChatItem act, int id) {
        IListItem[] ili = act.contents();
        int i = 0;
        while (ili != null && i < ili.length) {
            if (ili[i] != null && ((AJDevChatItem)ili[i]).getId() == id) {
                return act;
            }
            AJDevChatItem res = this.findParentForInternal((AJDevChatItem)ili[i], id);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public synchronized AJDevChatItem findItemWithID(int id) {
        return this.findItemWithID(id, null);
    }

    public synchronized AJDevChatItem findRoot(int itemID) {
        AJDevChatItem[] res = new AJDevChatItem[]{null};
        this.findItemWithID(itemID, res);
        return res[0];
    }

    public synchronized AJDevChatItem findItemWithID(int id, AJDevChatItem[] rootNode) {
        AJDevChatItem ajdcItem = this.findItemWithIDInternal(this.personal, id);
        if (ajdcItem == null) {
            ajdcItem = this.findItemWithIDInternal(this.pub, id);
            if (ajdcItem != null) {
                if (rootNode != null) {
                    rootNode[0] = this.pub;
                }
            } else {
                ajdcItem = this.findItemWithIDInternal(this.trash, id);
                if (ajdcItem != null && rootNode != null) {
                    rootNode[0] = this.trash;
                }
            }
        } else if (rootNode != null) {
            rootNode[0] = this.personal;
        }
        return ajdcItem;
    }

    public synchronized AJDevChatItem findItemWithIDInternal(AJDevChatItem act, int id) {
        if (act.getId() == id) {
            return act;
        }
        IListItem[] ili = act.contents();
        int i = 0;
        while (ili != null && i < ili.length) {
            AJDevChatItem res;
            if (ili[i] != null && (res = this.findItemWithIDInternal((AJDevChatItem)ili[i], id)) != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public synchronized void sendSubTree(AJDevChatItem act) {
        IListItem[] ili = act.contents();
        int i = 0;
        while (ili != null && i < ili.length) {
            if (ili[i] != null) {
                try {
                    this.network.sendMulti("UPDATEITEM", ((AJDevChatItem)ili[i]).getSerializedString(act.getId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (ili != null && i2 < ili.length) {
            if (ili[i2] != null) {
                this.sendSubTree((AJDevChatItem)ili[i2]);
            }
            ++i2;
        }
    }

    public synchronized void sendCurrentTree(String sender, String senderHost, int senderPort) {
        this.sendCurrentTreeInternal(this.personal, sender, senderHost, senderPort);
        this.sendCurrentTreeInternal(this.pub, sender, senderHost, senderPort);
    }

    public synchronized void sendCurrentTreeInternal(AJDevChatItem act, String sender, String senderHost, int senderPort) {
        IListItem[] ili = act.contents();
        int i = 0;
        while (ili != null && i < ili.length) {
            if (ili[i] != null) {
                try {
                    this.network.sendSingle(senderHost, senderPort, "UPDATEITEM", ((AJDevChatItem)ili[i]).getSerializedString(act.getId()));
                    Thread.sleep((int)(Math.random() * 50.0));
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (ili != null && i2 < ili.length) {
            if (ili[i2] != null) {
                this.sendCurrentTreeInternal((AJDevChatItem)ili[i2], sender, senderHost, senderPort);
            }
            ++i2;
        }
    }

    public synchronized void storeGlobalProperty(PropWriter pWriter) throws IOException {
        DataOutputStream out = pWriter.createStream("DevChat");
        this.saveCurrentTree(out);
        out.writeBoolean(this.isNetworkOnline());
        ObjectOutputStream oos = new ObjectOutputStream(out);
        while (this.deletedItems.size() > 200) {
            Iterator it = this.deletedItems.keySet().iterator();
            int i = 0;
            while (i < 10) {
                this.deletedItems.remove(it.next());
                ++i;
            }
        }
        oos.writeObject(this.deletedItems);
    }

    public synchronized void loadGlobalProperty(PropWriter pw) throws IOException {
        DataInputStream in = pw.getStream("DevChat");
        try {
            this.loadCurrentTree(in);
            boolean online = in.readBoolean();
            ObjectInputStream ois = new ObjectInputStream(in);
            this.deletedItems = (HashMap)ois.readObject();
            this.split.setDividerLocation(this.getHeight() - this.itemProps.getPreferredSize().height);
            if (online) {
                JWidgetsUtil.AddLongRunningJob(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        AJDevChat.this.runBtn_actionPerformed(null);
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public synchronized void saveCurrentTree(DataOutputStream out) throws IOException {
        HashSet read = new HashSet();
        this.saveCurrentTreeInternal(this.personal, out, read);
        this.saveCurrentTreeInternal(this.pub, out, read);
        out.writeUTF("END");
        out.writeInt(read.size());
        Iterator it = read.iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            out.writeInt(key);
        }
    }

    public synchronized void saveCurrentTreeInternal(AJDevChatItem act, DataOutputStream out, HashSet idRead) {
        IListItem[] ili = act.contents();
        int i = 0;
        while (ili != null && i < ili.length) {
            if (ili[i] != null) {
                try {
                    if (((AJDevChatItem)ili[i]).getRead()) {
                        idRead.add(new Integer(((AJDevChatItem)ili[i]).getId()));
                    }
                    out.writeUTF(((AJDevChatItem)ili[i]).getSerializedString(act.getId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (ili != null && i2 < ili.length) {
            if (ili[i2] != null) {
                this.saveCurrentTreeInternal((AJDevChatItem)ili[i2], out, idRead);
            }
            ++i2;
        }
    }

    public synchronized void loadCurrentTree(DataInputStream in) throws Exception {
        try {
            String s = null;
            Vector<String> vector = new Vector<String>(97);
            while (!"END".equals(s = in.readUTF())) {
                vector.add(s);
            }
            int siz = in.readInt();
            HashSet<Integer> hSet = new HashSet<Integer>(siz);
            int i = 0;
            while (i < siz) {
                int id = in.readInt();
                hSet.add(new Integer(id));
                ++i;
            }
            int i2 = 0;
            while (i2 < vector.size()) {
                this.updateItem((String)vector.get(i2), hSet, false, null, -1);
                ++i2;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public synchronized void userReceived(final String command, final String sender, final String senderHost, final int senderPort) {
        new Thread("USER RECEIVED"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AJDevChat aJDevChat = AJDevChat.this;
                synchronized (aJDevChat) {
                    Tracer.This.println("USER RECEIVED:" + sender + ":" + senderHost + ":" + senderPort + " " + command);
                    NCUserData data = new NCUserData(sender, senderHost, senderPort);
                    data = AJDevChat.this.ncuRegistry.updateUser(data);
                    if (!data.getName().equals(AJDevChat.this.getUserKey())) {
                        AJUserItem ui = new AJUserItem(data);
                        AJDevChat.this.addToRoot(AJDevChat.this.users, "" + ui.getDisplayString(), ui);
                        AJDevChat.this.listPanel.collapseAndExpandAllByIndentity();
                    }
                }
                if (command.equals("GUCKU")) {
                    AJDevChat.this.sendCurrentTree(sender, senderHost, senderPort);
                    Iterator it = AJDevChat.this.deletedItems.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String ver = (String)AJDevChat.this.deletedItems.get(key);
                        try {
                            AJDevChat.this.network.sendSingle(senderHost, senderPort, "DELITEMS", key + "|" + ver);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(Tracer.This);
                        }
                    }
                }
            }
        }.start();
    }

    public synchronized void dataReceived(String command, String sender, String senderHost, int senderPort, String data) {
        IListItem item = this.listPanel.getSelectedItem();
        Tracer.This.println("DATA RECEIVED:" + sender + ":" + senderHost + ":" + senderPort);
        Tracer.This.println("      command:" + command);
        Tracer.This.println("             :" + data);
        if (command.equals("UPDATEITEM")) {
            this.updateItem(data, null, true, senderHost, senderPort);
        } else if (command.equals("DELITEMS")) {
            this.delItems(data, false);
        } else if (command.equals("FULLDELITEMS")) {
            this.delItems(data, true);
        } else if (command.equals("MOVE")) {
            Vector v = NCStringUtilities.SplitSeparatedString("|", data);
            int idtarget = Integer.parseInt((String)v.get(0));
            int iddragged = Integer.parseInt((String)v.get(1));
            AJDevChatItem target = this.findItemWithID(idtarget);
            AJDevChatItem dragged = this.findItemWithID(iddragged);
            if (target != null && dragged != null) {
                this.move(target, dragged, false);
            } else if (target == null && dragged != null) {
                this.delItem(iddragged, dragged.getVersion(), true, true);
            }
        } else if (command.equals("MESSAGE")) {
            EditFrame.Status().addMessage("<b>[" + sender + "]</b>" + AJDevChatItem.uq(data));
        } else if (command.equals("ASSIGN")) {
            AJDevChatItem temp = new AJDevChatItem("");
            temp.updateFromSerializedString(data);
            String folderTit = "sent by " + sender;
            AJDevChatItem newPar = this.personal.findItemWithSubject(folderTit);
            AJDevChatItem dragged = this.findItemWithID(temp.getId());
            if (newPar == null) {
                newPar = new AJDevChatItem(folderTit);
                newPar.setIsDir(true);
                newPar.setOwnerID(this.getUserKey());
                newPar.id = this.createID();
                this.personal.insertItemBefore(0, newPar);
                this.sendToUserInstances(this.getUserKey(), null, "UPDATEITEM", newPar.getSerializedString(this.personal.getId()));
                this.sendSubTree(newPar);
            }
            EditFrame.Status().addMessage("<b>[AnyJ]</b> an item was sent by " + sender);
            if (dragged != null) {
                this.move(newPar, dragged, true);
            } else {
                try {
                    this.network.sendSingle(senderHost, senderPort, "REASSIGN", temp.getId() + "|" + this.getUserKey() + "|" + newPar.getId());
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
        } else if (command.equals("REASSIGN")) {
            Vector v = NCStringUtilities.SplitSeparatedString("|", data);
            int id = Integer.parseInt(v.get(0).toString());
            String user = v.get(1).toString();
            int newParentID = Integer.parseInt(v.get(2).toString());
            AJDevChatItem ajdci = this.findItemWithID(id);
            this.delItem(id, ajdci.getVersion(), true, true);
            this.sendDelItem(id, ajdci.getVersion(), true);
            ajdci.incVersionRec(1);
            ajdci.setOwnerIDRecursive(user);
            try {
                this.sendToUserInstances(sender, null, "UPDATEITEM", ajdci.getSerializedString(newParentID));
                this.sendSubTree(ajdci);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        }
        this.listPanel.setSelectedItem(item);
    }

    public synchronized void sendMove(int target, int idsource) throws Exception {
        this.network.sendMulti("MOVE", "" + target + "|" + idsource);
    }

    synchronized void delItems(String data, boolean full) {
        Vector v = NCStringUtilities.SplitSeparatedString("|", data);
        int i = 0;
        while (i < v.size()) {
            this.delItem(Integer.parseInt((String)v.get(i)), Integer.parseInt((String)v.get(i + 1)), false, full);
            i += 2;
        }
        this.listPanel.collapseAndExpandAllByIndentity();
    }

    synchronized void delItem(int id, int version, boolean paint, boolean full) {
        AJDevChatItem parent;
        AJDevChatItem ajdci = this.findItemWithID(id);
        if (ajdci != null && ajdci.getVersion() <= version && (parent = this.findParentFor(id)) != null) {
            parent.remItem(ajdci);
            if (!full) {
                ajdci.setOwnerIDRecursive("Trash");
                this.trash.addItem(ajdci);
            }
            if (paint) {
                this.listPanel.collapseAndExpandAllByIndentity();
            }
        }
    }

    synchronized void updateItem(String data, HashSet read, boolean paint, String hostip, int hostport) {
        int ver;
        AJDevChatItem temp = new AJDevChatItem("");
        int parId = temp.updateFromSerializedString(data);
        Tracer.This.println("RECEIVE UPDATE:" + temp.getSubject());
        if (this.deletedItems.containsKey("" + temp.getId()) && (ver = Integer.parseInt((String)this.deletedItems.get("" + temp.getId()))) >= temp.getVersion()) {
            this.sendDelItem(temp.getId(), temp.getVersion(), false);
            return;
        }
        AJDevChatItem act = this.findItemWithID(temp.getId());
        if (act != null) {
            AJDevChatItem par;
            if (act.getVersion() < temp.getVersion()) {
                act.updateFromSerializedString(data);
                AJDevChatItem parItem = this.findParentFor(act.getId());
                if (parItem != null && parItem.getId() != parId) {
                    Tracer.This.println("DETECT MOVE DURING UPDATE");
                    AJDevChatItem[] remoteRoot = new AJDevChatItem[]{null};
                    AJDevChatItem remotePar = this.findItemWithID(parId, remoteRoot);
                    if (remotePar == null || remoteRoot[0] != this.pub) {
                        if (remoteRoot[0] == this.personal && act.getOwnerID().equals(this.getUserKey())) {
                            this.move(remotePar, act, false);
                        } else {
                            this.delItem(act.getId(), act.getVersion(), true, true);
                        }
                    } else {
                        this.move(remotePar, act, false);
                    }
                } else if (paint) {
                    this.listPanel.repaint();
                }
                if (this.listPanel.getSelectedItem() == act) {
                    this.itemProps.readItem(act);
                }
            } else if (act.getVersion() > temp.getVersion() && (par = this.findParentFor(act.getId())) != null && hostip != null) {
                try {
                    this.network.sendSingle(hostip, hostport, "UPDATEITEM", act.getSerializedString(par.getId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
        } else {
            AJDevChatItem[] rootNode = new AJDevChatItem[]{null};
            AJDevChatItem par = this.findItemWithID(parId, rootNode);
            if (par == null || rootNode[0] == this.personal && !temp.getOwnerID().equals(this.getUserKey())) {
                if (rootNode[0] == null) {
                    Tracer.This.println("NO PARENT FOUND:" + temp.getDisplayString());
                } else {
                    Tracer.This.println("PERSONAL UPDATE:" + temp.getDisplayString());
                }
            } else {
                par.addItem(temp);
                if (read != null && read.contains(new Integer(temp.getId()))) {
                    temp.setRead(true);
                }
                if (paint) {
                    this.listPanel.expandNode(par);
                    this.listPanel.collapseAndExpandAllByIndentity();
                }
            }
        }
    }

    public synchronized String reqAckReceived(String command, String sender, String senderHost, int senderPort, String data, String ackId) {
        Tracer.This.println("REQACK:" + command);
        return "OK";
    }

    synchronized void addToRoot(ListItem root, String path, ListItem toAdd) {
        ListItem act = root;
        Vector v = NCStringUtilities.SplitSeparatedString("/", path);
        String growPath = "";
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.get(i);
            growPath = growPath + File.separator + s;
            ListItem node = (ListItem)act.findItemNamed(s);
            if (node == null) {
                if (i != v.size() - 1) {
                    node = new ListItem(s);
                    act.addItem(node);
                } else if (toAdd != null) {
                    act.addItem(toAdd);
                }
            }
            act = node;
            ++i;
        }
    }

    public synchronized Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public synchronized void itemChanged(AJDevChatItem item) {
        item.incVersion();
        int i = this.listPanel.getList().indexOf(item);
        AJDevChatItem ajdcItem = this.findParentFor(item.getId());
        if (ajdcItem == null) {
            return;
        }
        try {
            this.network.sendMulti("UPDATEITEM", item.getSerializedString(ajdcItem.getId()));
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void stopBtn_actionPerformed(ActionEvent var0) {
        try {
            this.network.stopNetwork();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.runBtn.setVisible(!AJDevChat.This().isNetworkOnline());
        this.stopBtn.setVisible(AJDevChat.This().isNetworkOnline());
        this.refreshBtn.setEnabled(this.stopBtn.isVisible());
    }

    public void refreshBtn_actionPerformed(ActionEvent var0) {
        this.users.contents(new IListItem[0]);
        try {
            this.network.pingUsers();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public synchronized void runBtn_actionPerformed(ActionEvent var0) {
        try {
            AJDevChat.This().initNetwork();
            this.runBtn.setVisible(!AJDevChat.This().isNetworkOnline());
            this.stopBtn.setVisible(AJDevChat.This().isNetworkOnline());
            this.refreshBtn.setEnabled(this.stopBtn.isVisible());
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
        }
    }

    public synchronized Object actionIconClick(Object arg, Object sen) {
        AJDevChatItem it;
        int sel = ((IntValue)arg).intValue();
        if (sel >= 0 && sel < this.listPanel.listSize() && this.listPanel.at(sel) instanceof AJDevChatItem && (it = (AJDevChatItem)this.listPanel.at(sel)).isTask()) {
            it.setDone(!it.getDone());
            if (this.listPanel.getSelectedItem() == it) {
                this.itemProps.done.setSelected(it.getDone());
            }
            this.itemChanged(it);
            this.listPanel.repaintStartingAt(sel, 1);
        }
        return null;
    }

    public synchronized Object actionListSel(Object arg, Object sen) {
        ListItem lItem;
        if (this.lastSel instanceof AJDevChatItem && !this.isBuiltInItem(this.lastSel) && this.itemProps.isModified()) {
            this.itemProps.writeItem();
            this.listPanel.collapseAndExpandAllByIndentity();
            this.itemChanged(this.itemProps.item);
        }
        if ((lItem = (ListItem)this.listPanel.getSelectedItem()) instanceof AJDevChatItem) {
            ((AJDevChatItem)lItem).setRead(true);
        }
        if (lItem instanceof AJDevChatItem && !this.isBuiltInItem(lItem)) {
            AJDevChatItem ajdcItem = (AJDevChatItem)lItem;
            this.itemProps.readItem(ajdcItem);
            Tracer.This.println("ID:" + ajdcItem.getId());
        }
        this.lastSel = lItem;
        return null;
    }

    synchronized boolean isBuiltInItem(IListItem lItem) {
        return lItem == this.users || lItem == this.personal || lItem == this.pub || lItem == this.trash;
    }

    public synchronized void cancelBtn_actionPerformed(ActionEvent var0) {
    }

    public synchronized void okBtn_actionPerformed(ActionEvent var0) {
        AJDevChatItem ajdcItem = this.itemProps.item;
        if (ajdcItem != null) {
            this.itemProps.writeItem(ajdcItem);
            this.itemChanged(ajdcItem);
            this.listPanel.collapseAndExpandAllByIndentity();
        }
    }

    public synchronized void delBtn_actionPerformed(ActionEvent var0) {
        ListItem lItem = (ListItem)this.listPanel.getSelectedItem();
        if (lItem instanceof AJDevChatItem && !this.isBuiltInItem(lItem)) {
            this.delItem(((AJDevChatItem)lItem).getId(), ((AJDevChatItem)lItem).getVersion(), true, false);
            this.sendDelItem(((AJDevChatItem)lItem).getId(), ((AJDevChatItem)lItem).getVersion(), false);
        }
    }

    synchronized void sendDelItem(int id, int ver, boolean fullDel) {
        this.deletedItems.put("" + id, "" + ver);
        if (fullDel) {
            try {
                this.network.sendMulti("FULLDELITEMS", "" + id + "|" + ver);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        } else {
            try {
                this.network.sendMulti("DELITEMS", "" + id + "|" + ver);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        }
    }

    synchronized int createID() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public synchronized void newBtn_actionPerformed(ActionEvent var0) {
        ListItem lItem = (ListItem)this.listPanel.getSelectedItem();
        if (lItem instanceof AJDevChatItem) {
            AJDevChatItem ajdcItem = (AJDevChatItem)lItem;
            AJDevChatItem newItem = new AJDevChatItem(this.createID(), "New Item", "", "", "", 1, this.getUserKey());
            if (!ajdcItem.getIsDir()) {
                ajdcItem = this.findParentFor(ajdcItem.getId());
            }
            ajdcItem.addItem(newItem);
            this.listPanel.collapseAndExpandAllByIndentity();
            this.listPanel.expandNode(ajdcItem);
            this.listPanel.setSelectedItem(newItem);
            this.listPanel.binder().notifyTargets(this.listPanel.getSelectionIndex());
            this.itemProps.tabbedPane.setSelectedIndex(0);
            this.itemProps.subject.requestFocus();
            this.itemProps.subject.selectAll();
            this.okBtn_actionPerformed(null);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            JFrame jframe = new JFrame();
            jframe.getContentPane().add(AJDevChat.This());
            jframe.setBounds(10, 10, 400, 600);
            jframe.setDefaultCloseOperation(3);
            jframe.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        mypop = new String[]{"Add Task", "-", "Tasks"};
        User = "AnyJ User";
        Personal = "Personal";
        Public = "Public";
    }
}

