/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.devchat;

import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.devchat.AJDevChat;
import de.netcomputing.util.NCStringUtilities;
import java.awt.Color;
import java.awt.Image;
import java.util.Vector;

public class AJDevChatItem
extends ListItem {
    String text = "";
    boolean done;
    int prio;
    String duration = "";
    String finish = "";
    int id;
    String authorID = "";
    boolean read = false;
    boolean isDir;
    int version;

    public AJDevChatItem(String subject) {
        super(subject);
    }

    public AJDevChatItem(int id, String subject, String text, String finish, String duration, int prio, String authorID) {
        super(subject);
        this.setSubject(subject);
        this.setText(text);
        this.setPrio(prio);
        this.setDuration(duration);
        this.setFinish(finish);
        this.id = id;
        this.setOwnerID(authorID);
    }

    public AJDevChatItem findItemWithSubject(String name) {
        int i = 0;
        while (i < this.contents().length) {
            if (this.contents()[i] instanceof AJDevChatItem && ((AJDevChatItem)this.contents()[i]).getSubject().equals(name)) {
                return (AJDevChatItem)this.contents()[i];
            }
            ++i;
        }
        return null;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void incVersion() {
        this.incVersion(20);
    }

    public void incVersionRec(int count) {
        this.incVersion(count);
        int i = 0;
        while (i < this.contents().length) {
            ((AJDevChatItem)this.contents()[i]).incVersionRec(count);
            ++i;
        }
    }

    public void incVersion(int i) {
        this.version += i;
    }

    public void setIsDir(boolean isDir) {
        this.isDir = isDir;
    }

    public boolean getIsDir() {
        return this.isDir;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean getDone() {
        return this.done;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public String getFinish() {
        return this.finish;
    }

    public void setPrio(int prio) {
        this.prio = prio;
    }

    public int getPrio() {
        return this.prio;
    }

    public void setSubject(String subject) {
        this.setWrappedObject(subject);
    }

    public String getSubject() {
        return (String)this.wrappedObject();
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public void setOwnerIDRecursive(String authorID) {
        this.authorID = authorID;
        this.incVersion();
        int i = 0;
        while (i < this.contents().length) {
            ((AJDevChatItem)this.contents()[i]).setOwnerIDRecursive(authorID);
            ++i;
        }
    }

    public void setOwnerID(String authorID) {
        this.authorID = authorID;
    }

    public String getOwnerID() {
        return this.authorID;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean getRead() {
        return this.read;
    }

    public Image getImage() {
        if (this.getOwnerID().equals("SYSTEM_ID")) {
            if (this == AJDevChat.This().users) {
                return NCApplication.GetImage("/de/netcomputing/devchat/images/diruser.gif");
            }
            if (this == AJDevChat.This().trash) {
                return NCApplication.GetImage("/de/netcomputing/devchat/images/trash.gif");
            }
            return NCApplication.GetImage("/de/netcomputing/devchat/images/dir.gif");
        }
        if (!this.getIsDir()) {
            if (this.isTask()) {
                if (this.getDone()) {
                    return NCApplication.GetImage("check1.gif");
                }
                return NCApplication.GetImage("check0.gif");
            }
            if (this.getText().trim().length() == 0) {
                return NCApplication.GetImage("/de/netcomputing/devchat/images/line.gif");
            }
            return NCApplication.GetImage("/plugins/bookmarks/images/note.gif");
        }
        if (this.isTask()) {
            if (this.getDone()) {
                return NCApplication.GetImage("/de/netcomputing/devchat/images/dircheck.gif");
            }
            return NCApplication.GetImage("/de/netcomputing/devchat/images/diruncheck.gif");
        }
        return NCApplication.GetImage("/images/dir.gif");
    }

    protected Color getTextColor(NCPanel sender) {
        if (this.getRead()) {
            return super.getTextColor(sender);
        }
        return Color.red.darker();
    }

    public Image getOpenImage() {
        if (this.isTask()) {
            if (this.getDone()) {
                return NCApplication.GetImage("/de/netcomputing/devchat/images/dirunchecko.gif");
            }
            return NCApplication.GetImage("/de/netcomputing/devchat/images/dirchecko.gif");
        }
        if (this == AJDevChat.This().users) {
            return NCApplication.GetImage("/de/netcomputing/devchat/images/dirusero.gif");
        }
        if (this == AJDevChat.This().trash) {
            return NCApplication.GetImage("/de/netcomputing/devchat/images/trash.gif");
        }
        return NCApplication.GetImage("/images/diropen.gif");
    }

    public String getDisplayString() {
        if (this.getOwnerID().equals("SYSTEM_ID")) {
            return super.getDisplayString();
        }
        return super.getDisplayString() + " [" + this.authorID + "]";
    }

    public int updateFromSerializedString(String s) {
        Vector v = NCStringUtilities.SplitSeparatedString("|", s, true);
        int i = 0;
        while (i < v.size()) {
            v.set(i, AJDevChatItem.uq(v.get(i).toString()));
            ++i;
        }
        this.setSubject((String)v.get(0));
        this.setText((String)v.get(1));
        this.setDone("true".equals(v.get(2).toString()));
        this.setPrio(Integer.parseInt((String)v.get(3)));
        this.setDuration((String)v.get(4));
        this.setFinish((String)v.get(5));
        this.id = Integer.parseInt((String)v.get(6));
        this.setVersion(Integer.parseInt(v.get(7).toString()));
        this.setOwnerID(v.get(8).toString());
        if (v.size() > 10) {
            this.setIsDir("true".equals(v.get(10).toString()));
        }
        this.setRead(false);
        return Integer.parseInt(v.get(9).toString());
    }

    static String qt(String s) {
        s = NCStringUtilities.Replace(s, "&", "&&");
        s = NCStringUtilities.Replace(s, "|", "1&1");
        return s;
    }

    static String uq(String s) {
        s = NCStringUtilities.Replace(s, "1&1", "|");
        s = NCStringUtilities.Replace(s, "&&", "&");
        return s;
    }

    public String getSerializedString(int parentID) {
        return AJDevChatItem.qt(this.getSubject()) + "|" + AJDevChatItem.qt(this.getText()) + "|" + this.getDone() + "|" + this.getPrio() + "|" + AJDevChatItem.qt(this.getDuration()) + "|" + AJDevChatItem.qt(this.getFinish()) + "|" + this.getId() + "|" + this.getVersion() + "|" + AJDevChatItem.qt(this.getOwnerID()) + "|" + parentID + "|" + (this.getIsDir() || this.hasContent());
    }

    public boolean isTask() {
        return this.getFinish() != null && this.getFinish().trim().length() > 0;
    }

    public Object dataObject() {
        return this;
    }
}

