/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.devchat;

import de.netcomputing.beans.numberpanel.NumberPanel;
import de.netcomputing.devchat.AJDevChat;
import de.netcomputing.devchat.AJDevChatItem;
import de.netcomputing.devchat.DevChatItemPropsGUI;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DevChatItemProps
extends JPanel {
    JTabbedPane tabbedPane;
    JButton okBtn;
    JCheckBox isDir;
    JEditorPane text;
    JTextField subject;
    JCheckBox finish;
    JCheckBox done;
    NumberPanel prio;
    JTextField duration;
    AJDevChatItem item;

    public DevChatItemProps() {
        this.initGui();
    }

    public void initGui() {
        new DevChatItemPropsGUI().createGui(this);
    }

    public void readItem(AJDevChatItem ajdci) {
        this.item = ajdci;
        boolean userEnabled = ajdci.getOwnerID().equals(AJDevChat.This().getUserKey());
        this.text.setEditable(userEnabled);
        this.subject.setEditable(userEnabled);
        this.duration.setEnabled(userEnabled);
        this.finish.setEnabled(userEnabled);
        this.prio.setEnabled(userEnabled);
        this.text.setText(ajdci.getText());
        this.subject.setText(ajdci.getSubject());
        this.done.setSelected(ajdci.getDone());
        this.prio.setValue(ajdci.getPrio());
        this.isDir.setSelected(ajdci.getIsDir());
        this.duration.setText(ajdci.getDuration());
        this.finish.setSelected(ajdci.isTask());
        this.isDir.setEnabled(!ajdci.hasContent() && (userEnabled || !ajdci.isTask()));
        this.done.setEnabled(ajdci.isTask());
    }

    public void writeItem() {
        if (this.item != null) {
            this.writeItem(this.item);
        }
    }

    public void writeItem(AJDevChatItem ajdci) {
        ajdci.setText(this.text.getText());
        ajdci.setSubject(this.subject.getText());
        ajdci.setDone(this.done.isSelected());
        ajdci.setPrio(this.prio.getValue());
        ajdci.setIsDir(this.isDir.isSelected());
        ajdci.setDuration(this.duration.getText());
        ajdci.setFinish(this.finish.isSelected() ? "0" : "");
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public boolean isModified() {
        if (this.item == null) {
            return false;
        }
        AJDevChatItem ajdci = this.item;
        return !ajdci.getText().equals(this.text.getText()) || !ajdci.getSubject().equals(this.subject.getText()) || ajdci.getDone() != this.done.isSelected() || ajdci.getPrio() != this.prio.getValue() || !ajdci.getDuration().equals(this.duration.getText()) || !ajdci.getDuration().equals(this.duration.getText()) || ajdci.getIsDir() != this.isDir.isSelected() || ajdci.getFinish().length() > 0 != this.finish.isSelected();
    }

    public void okBtn_actionPerformed(ActionEvent var0) {
        AJDevChat.This().okBtn_actionPerformed(var0);
    }
}

