/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.modeller.ConnectSpec;
import de.netcomputing.modeller.ModellerEntity;
import de.netcomputing.modeller.model.IDataModelConnection;
import de.netcomputing.modeller.model.IDataModelEntity;
import de.netcomputing.util.connections.ArrowConnection;
import de.netcomputing.util.connections.INConnection;
import de.netcomputing.util.xml.Node;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import layedit.IConnection;
import layedit.LayoutController;
import layedit.swing.BopSwingRoot;

public class ModellerAssociation
implements IConnection,
IDataModelConnection {
    public static final int POINT_TO_MIDDLE = 1;
    public static final int POINT_TO_EDGE = 2;
    public static final int POINT_TO_FIELD = 4;
    ConnectSpec left;
    ConnectSpec right;
    String title = "";
    Node meta;
    INConnection doubleArrow;
    String shape;
    Color halfWhite = new Color(255, 255, 255, 128);
    static HashMap customConnections = new HashMap();
    Map props = new HashMap();
    boolean selected;
    static final int LABDIST = 14;

    public static void RegisterConnectionDrawer(String name, Class conClazz) {
        customConnections.put(name, conClazz);
    }

    public ModellerAssociation(ModellerEntity aleft, ModellerEntity aright, String shape, String leftTitle, String rightTitle) {
        this.left = new ConnectSpec();
        this.right = new ConnectSpec();
        this.left.target = aleft;
        this.right.target = aright;
        this.left.title = leftTitle;
        this.right.title = rightTitle;
        this.initShape(shape);
    }

    public ModellerEntity getLeft() {
        return this.left.target;
    }

    public ModellerEntity getRight() {
        return this.right.target;
    }

    protected void initShape(String s) {
        this.shape = s;
        if (s.equals("Association")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(0, 0, true);
        } else if (s.equals("Inheritance")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(0, 3, false);
        } else if (s.equals("ContainedIn")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(0, 2, false);
        } else if (s.equals("ComposedWith")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(0, 2, true);
        } else if (s.equals("PointTo")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(0, 1, true);
        } else if (s.equals("PointEachOther")) {
            this.left.connectType = 2;
            this.right.connectType = 2;
            this.doubleArrow = new ArrowConnection(1, 1, true);
        } else {
            this.left.connectType = 2;
            this.right.connectType = 2;
            Class concCl = (Class)customConnections.get(s);
            if (concCl != null) {
                try {
                    this.doubleArrow = (INConnection)concCl.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Confirm.MsgException(ex);
                }
            } else {
                this.doubleArrow = new ArrowConnection(0, 0, true);
            }
        }
    }

    public String getShape() {
        return this.shape;
    }

    public void setMeta(Node meta) {
        this.meta = meta;
    }

    public Node getMetaSpec() {
        return this.meta;
    }

    public Map getProperties() {
        return this.props;
    }

    public void setProperties(Map props) {
        this.props = props;
    }

    public void applyProperties() {
        this.title = "";
        if (this.props.get("Name") != null) {
            this.title = (String)this.props.get("Name");
        }
        this.right.title = "";
        if (this.props.get("RightCardinality") != null) {
            this.right.title = (String)this.props.get("RightCardinality");
        }
        this.left.title = "";
        if (this.props.get("LeftCardinality") != null) {
            this.left.title = (String)this.props.get("LeftCardinality");
        }
    }

    void computeMiddleTarget(Point result, Rectangle compBounds, Rectangle otherBounds, int count, int maxCount) {
        compBounds = new Rectangle(compBounds);
        otherBounds = new Rectangle(otherBounds);
        int fak = 36;
        if (maxCount > 1) {
            compBounds.width += (maxCount / 2 - count) * fak;
            compBounds.height += (maxCount / 2 - count) * fak;
            otherBounds.width += (maxCount / 2 - count) * fak;
            otherBounds.height += (maxCount / 2 - count) * fak;
        }
        result.x = compBounds.width / 2;
        result.y = compBounds.height / 2;
        if (compBounds.x <= otherBounds.x && compBounds.x + compBounds.width >= otherBounds.x) {
            result.x = otherBounds.x - compBounds.x + (Math.min(compBounds.x + compBounds.width, otherBounds.x + otherBounds.width) - otherBounds.x) / 2;
        } else if (otherBounds.x <= compBounds.x && otherBounds.x + otherBounds.width >= compBounds.x) {
            result.x = (Math.min(compBounds.x + compBounds.width, otherBounds.x + otherBounds.width) - compBounds.x) / 2;
        }
        if (compBounds.y <= otherBounds.y && compBounds.y + compBounds.height >= otherBounds.y) {
            result.y = otherBounds.y - compBounds.y + (Math.min(compBounds.y + compBounds.height, otherBounds.y + otherBounds.height) - otherBounds.y) / 2;
        } else if (otherBounds.y <= compBounds.y && otherBounds.y + otherBounds.height >= compBounds.y) {
            result.y = (Math.min(compBounds.y + compBounds.height, otherBounds.y + otherBounds.height) - compBounds.y) / 2;
        }
    }

    void computeArrowTarget(Rectangle rect, int[] line) {
        int x = line[0];
        int y = line[1];
        int x1 = line[2];
        int y1 = line[3];
        double m = (double)(y1 - y) / (double)(x1 - x);
        int[] xy = new int[]{x1, y1};
        this.computeIntersectX(m, xy, x < rect.x + rect.width / 2 ? rect.x : rect.x + rect.width);
        int[] xy1 = new int[]{x1, y1};
        this.computeIntersectY(m, xy1, y < rect.y + rect.height / 2 ? rect.y : rect.y + rect.height);
        if (xy1[0] < rect.x - 1 || xy1[0] > rect.width + rect.x + 1) {
            line[2] = xy[0];
            line[3] = xy[1];
        } else {
            line[2] = xy1[0];
            line[3] = xy1[1];
        }
        line[0] = x;
        line[1] = y;
    }

    void computeIntersectX(double m, int[] xy, int xa) {
        xy[1] = xy[1] + (int)(m * (double)(xa - xy[0]));
        xy[0] = xa;
    }

    void computeIntersectY(double m, int[] xy, int ya) {
        xy[0] = xy[0] + (int)(1.0 / m * (double)(ya - xy[1]));
        xy[1] = ya;
    }

    public void connectionClicked() {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void paint(Graphics g, LayoutController contr, int dualCount, int initalDualCount) {
        Rectangle p1 = this.left.target.getParent().getBounds();
        Rectangle p2 = this.right.target.getParent().getBounds();
        Point target1 = new Point(0, 0);
        Point target2 = new Point(0, 0);
        this.computeMiddleTarget(target1, p1, p2, dualCount, initalDualCount);
        this.computeMiddleTarget(target2, p2, p1, dualCount, initalDualCount);
        g.setColor(Color.darkGray);
        int[] li = new int[]{target1.x + p1.x, target1.y + p1.y, target2.x + p2.x, target2.y + p2.y};
        if ((this.right.connectType & 2) != 0) {
            this.computeArrowTarget(p2, li);
        }
        int[] li1 = new int[]{li[2], li[3], li[0], li[1]};
        if ((this.left.connectType & 2) != 0) {
            this.computeArrowTarget(p1, li1);
        }
        this.doubleArrow.draw(this, g, li1[0], li1[1], li1[2], li1[3]);
        if (contr != null && !BopSwingRoot.IsPrinting) {
            Color primary = Color.black;
            int titX = li1[0] - (li1[0] - li1[2]) / 2;
            int titY = li1[1] - (li1[1] - li1[3]) / 2;
            int w = 10;
            int h = 10;
            Rectangle rect = new Rectangle(titX - w / 2, titY - h / 2, w, h);
            if (this.selected) {
                g.setColor(Color.white);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(Color.red);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(primary);
            } else {
                g.setColor(Color.lightGray);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(Color.white);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            contr.registerConnectionHotZone(rect, this);
        }
        g.setColor(Color.black);
        if (this.title != null && this.title.length() > 0) {
            int titX = li1[0] - (li1[0] - li1[2]) / 2;
            int titY = li1[1] - (li1[1] - li1[3]) / 2;
            int w = g.getFontMetrics().stringWidth(this.title);
            g.drawString(this.title, titX - w / 2, titY);
        }
        if (this.left.title != null && this.left.title.length() > 0) {
            int lw = g.getFontMetrics().stringWidth(this.left.title) + (li1[0] - li1[2] >= 0 ? 14 : 0);
            int lh = g.getFontMetrics().getHeight();
            int ld = g.getFontMetrics().getDescent();
            int ltitX = li1[0] - lw * (li1[0] - li1[2] >= 0 ? 1 : -1) / 2 + (li1[0] - li1[2] >= 0 ? 0 : 14);
            int ltitY = li1[1] - lh * (li1[1] - li1[3] >= 0 ? 0 : -1);
            g.drawString(this.left.title, ltitX - lw / 2, ltitY - ld);
        }
        if (this.right.title != null && this.right.title.length() > 0) {
            int rw = g.getFontMetrics().stringWidth(this.right.title) + (li1[0] - li1[2] >= 0 ? 0 : 10);
            int rh = g.getFontMetrics().getHeight();
            int rd = g.getFontMetrics().getDescent();
            int rtitX = li1[2] + rw * (li1[0] - li1[2] >= 0 ? 1 : -1) / 2 + (li1[0] - li1[2] >= 0 ? 10 : 0);
            int rtitY = li1[3] + rh * (li1[1] - li1[3] >= 0 ? 1 : 0);
            g.drawString(this.right.title, rtitX - rw / 2, rtitY - rd);
        }
    }

    public IDataModelEntity getLeftEntity() {
        return this.left.target.getAssoc();
    }

    public IDataModelEntity getRightEntity() {
        return this.right.target.getAssoc();
    }
}

