/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.runtime;

import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.runtime.ITypeMapper;
import de.netcomputing.runtime.SmallMemTable;
import de.netcomputing.runtime.SwingInstantiator;
import de.netcomputing.runtime.XMLNode;
import de.netcomputing.runtime.XMLTag;
import de.netcomputing.util.Tracer;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class XMLInstantiator
implements XmlHandler {
    XmlParser parser;
    Stack tags = new Stack();
    XMLTag root;
    SmallMemTable attributes = new SmallMemTable();
    String includeBaseDir = ".";
    protected ITypeMapper typeMapper;
    protected Vector instances;
    protected SmallMemTable nameMap;
    protected SmallMemTable idMap;
    protected String[] packages = new String[]{"java.awt."};
    static SmallMemTable beanInfoCache = new SmallMemTable();
    static SmallMemTable methodCache = new SmallMemTable(100);
    protected static Class[] objarg = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = XMLInstantiator.class$("java.lang.Object")) : class$java$lang$Object};
    protected static Object[] args = new Object[]{null};
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Object;

    public static int[] ParseMultiInt(String commaSep, int length) {
        String s = null;
        int[] res = new int[length];
        try {
            s = commaSep;
            int resIdx = 0;
            int pot = 1;
            int n = s.length() - 1;
            while (n >= 0 && resIdx < length) {
                int c = s.charAt(n) - 48;
                if (c <= 9 && c >= 0) {
                    int n2 = resIdx;
                    res[n2] = res[n2] + c * pot;
                    pot *= 10;
                } else {
                    pot = 1;
                    ++resIdx;
                }
                --n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public XMLInstantiator(ITypeMapper mapper) {
        this.typeMapper = mapper;
    }

    public XMLInstantiator() {
    }

    public void setIncludeBaseDir(String baseDir) {
        this.includeBaseDir = baseDir;
    }

    public String getIncludeBaseDir() {
        return this.includeBaseDir;
    }

    public void init() {
        this.root = new XMLTag(null);
        this.tags.setSize(0);
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        this.instances = new Vector(71);
        this.nameMap = new SmallMemTable(71);
        this.idMap = new SmallMemTable(71);
        this.instances.addElement(null);
    }

    public void doParse(String url) throws Exception {
        this.tags.setSize(0);
        this.root = new XMLTag("root");
        this.tags.push(this.root);
        String docURL = ApplicationHelper.Singleton().getURL(url);
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        this.parser.parse(docURL, null, (String)null);
    }

    public void doParse(URL url) throws Exception {
        InputStream in = url.openStream();
        this.doParse(in);
        in.close();
    }

    public void doParse(InputStream input) throws Exception {
        this.tags.setSize(0);
        this.root = new XMLTag("root");
        this.tags.push(this.root);
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        this.parser.parse(null, null, input, null);
    }

    public XMLTag getActTag() {
        try {
            return (XMLTag)this.tags.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void displayText(String s) {
        Tracer.This.println(s);
    }

    public void error(String message, String url, int line, int column) {
        this.displayText("FATAL ERROR: " + message);
        this.displayText("  at " + url.toString() + ": line " + line + " column " + column);
        throw new Error(message);
    }

    public Object resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void startExternalEntity(String systemId) {
    }

    public void endExternalEntity(String systemId) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void doctypeDecl(String name, String pubid, String sysid) {
    }

    public void attribute(String name, String value, boolean isSpecified) {
        this.attributes.put(name, value);
    }

    public void startElement(String name) {
        XMLTag newTag = new XMLTag(name);
        this.tags.push(newTag);
        newTag.setAttributes(this.attributes);
        this.attributes = new SmallMemTable();
    }

    public void endElement(String name) {
        XMLTag newTag = this.getActTag();
        this.tags.pop();
        this.getActTag().add(newTag);
    }

    public void charData(char[] ch, int start, int length) {
    }

    String escape(char[] ch, int length) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < length) {
            switch (ch[i]) {
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\n': {
                    out.append("\\n");
                    break;
                }
                case '\t': {
                    out.append("\\t");
                    break;
                }
                case '\r': {
                    out.append("\\r");
                    break;
                }
                case '\f': {
                    out.append("\\f");
                    break;
                }
                default: {
                    out.append(ch[i]);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    protected Object makeInstance(XMLTag tag) {
        Object instance = null;
        String clazz = tag.getName();
        if ("String".equals(clazz)) {
            instance = new String(tag.getSaveString("value"));
            tag.remAttr("value");
            return instance;
        }
        if ("Font".equals(clazz)) {
            instance = Font.decode(tag.getSaveString("value"));
            tag.remAttr("value");
            return instance;
        }
        if ("Color".equals(clazz)) {
            instance = this.decodeString(class$java$awt$Color == null ? (class$java$awt$Color = XMLInstantiator.class$("java.awt.Color")) : class$java$awt$Color, tag.getSaveString("value"));
            tag.remAttr("value");
            return instance;
        }
        int n = 0;
        while (n < this.packages.length && instance == null) {
            try {
                instance = Class.forName(this.packages[n] + clazz).newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException ee) {
            }
            catch (InstantiationException eee) {
                // empty catch block
            }
            ++n;
        }
        return instance;
    }

    public int applyAttrImpl(XMLTag parent, int n) {
        XMLTag tag = (XMLTag)parent.getChildren();
        while (tag != null) {
            this.applyAttributes(this.instances.elementAt(++n), tag);
            n = this.applyAttrImpl(tag, n);
            tag = (XMLTag)tag.getNext();
        }
        return n;
    }

    public void createStructure(XMLTag root) {
        this.makeInstances(root);
        this.build(root, 0);
        this.applyAttrImpl(root, 0);
    }

    protected void makeInstancesImpl(XMLTag parent) {
        XMLTag tag = (XMLTag)parent.getChildren();
        while (tag != null) {
            String name = tag.getString("id");
            Object instance = this.makeInstance(tag);
            this.instances.addElement(instance);
            if (name != null) {
                this.nameMap.put(name, instance);
                this.idMap.put(instance, name);
                tag.remAttr("id");
            }
            this.makeInstancesImpl(tag);
            tag = (XMLTag)tag.getNext();
        }
    }

    protected void makeInstances(XMLTag root) {
        this.makeInstancesImpl(root);
    }

    public static BeanInfo getBeanInfo(Class clazz) {
        try {
            BeanInfo inf = (BeanInfo)beanInfoCache.get(clazz);
            if (inf == null) {
                inf = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = XMLInstantiator.class$("java.lang.Object")) : class$java$lang$Object);
                beanInfoCache.put(clazz, inf);
            }
            return inf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getWriteMethod(Class clazz, String property) {
        String hash = clazz.getName() + property;
        Method m = null;
        try {
            m = (Method)methodCache.get(hash);
            if (m == null) {
                BeanInfo inf = (BeanInfo)beanInfoCache.get(clazz);
                if (inf == null) {
                    inf = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = XMLInstantiator.class$("java.lang.Object")) : class$java$lang$Object);
                    beanInfoCache.put(clazz, inf);
                }
                PropertyDescriptor[] desc = inf.getPropertyDescriptors();
                int n = 0;
                while (n < desc.length) {
                    if (desc[n].getName().equals(property)) {
                        m = desc[n].getWriteMethod();
                        methodCache.put(hash, m);
                        return m;
                    }
                    ++n;
                }
            }
        }
        catch (Exception e) {
            methodCache.put(hash, Boolean.FALSE);
        }
        return m;
    }

    protected int build(XMLTag parent, int count) {
        XMLNode tag = parent.getChildren();
        int parCount = count;
        while (tag != null) {
            ++count;
            if (this.instances.elementAt(parCount) != null) {
                this.addChild(this.instances.elementAt(parCount), this.instances.elementAt(count), tag);
            }
            count = this.build((XMLTag)tag, count);
            tag = tag.getNext();
        }
        return count;
    }

    protected void applyAttribute(XMLTag tag, Object obj, String name, String val) {
        this.defaultApplyAttribute(tag, obj, name, val);
    }

    protected void defaultApplyAttribute(XMLTag tag, Object obj, String name, String val) {
        block5: {
            try {
                Object arg = null;
                Method m = XMLInstantiator.getWriteMethod(obj.getClass(), name);
                Class<?> c = m.getParameterTypes()[0];
                arg = this.nameMap.get(val);
                if (arg == null || !this.typeMapper.isInstanceOf(arg.getClass(), c)) {
                    arg = this.decodeString(c, val);
                }
                XMLInstantiator.args[0] = arg;
                if (arg != null) {
                    m.invoke(obj, args);
                }
            }
            catch (Exception e) {
                if (name.toString().equals("source")) break block5;
                if (obj == null && SwingInstantiator.DEBUG) {
                    Tracer.This.println(name + " not found:" + obj);
                }
                if (!SwingInstantiator.DEBUG) break block5;
                Tracer.This.println(name + " not found:" + obj.getClass());
            }
        }
    }

    protected void applyAttributes(Object obj, XMLTag tag) {
        if (tag.hasAttributes()) {
            SmallMemTable att = tag.getAttributes();
            Enumeration en = att.clonedKeys();
            String events = null;
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String tmp = (String)att.get(name);
                if (tmp == null) {
                    tmp = "";
                }
                if (name.equals("events")) {
                    events = tmp;
                    continue;
                }
                this.applyAttribute(tag, obj, name, tmp);
            }
            if (events != null) {
                this.applyAttribute(tag, obj, "events", events);
            }
        }
    }

    protected Object decodeFromString(Class clazz, String s) {
        return this.decodeString(clazz, s);
    }

    protected Object decodeString(Class clazz, String s) {
        return this.typeMapper.extractFromString(s, clazz);
    }

    protected void addChild(Object parent, Object child, XMLNode tag) {
    }

    public XMLTag getRoot() {
        return this.root;
    }

    public XmlParser getParser() {
        return this.parser;
    }

    public SmallMemTable getNameMap() {
        return this.nameMap;
    }

    public Vector getInstances() {
        return this.instances;
    }

    public static void main(String[] arg) {
        try {
            URL url = new URL("file:///g:\\j11\\source\\srvopt.prp");
            InputStream inputStream = url.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

