/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.CollapsedPanelBar;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingContainer;
import de.netcomputing.swingx.DockingDesktop;
import de.netcomputing.swingx.DockingWindowTitleBar;
import de.netcomputing.swingx.DragHelper;
import de.netcomputing.swingx.DragHelperListener;
import de.netcomputing.swingx.IDockingContainer;
import de.netcomputing.swingx.SplitButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class DockingComponentWrapper
extends JPanel
implements DragHelperListener {
    JButton dragHandle;
    private JComponent contentPanel;
    JComponent decoratedPanel;
    DockingComponentInfo info;
    DockingWindowTitleBar titleBar;
    boolean isHorizontal = false;
    String saveId = null;
    DragHelper helper;
    JComponent dragPanel = new JPanel(new BorderLayout(0, 0));

    public static void translatePoint(Component now, Component newC, Point p) {
        try {
            Point act = now.getLocationOnScreen();
            Point n = newC.getLocationOnScreen();
            act.x -= n.x;
            act.y -= n.y;
            p.x += act.x;
            p.y += act.y;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public DockingComponentWrapper(JButton aCloseButton, JComponent content, DockingComponentInfo info, boolean horizontal) {
        this.isHorizontal = horizontal;
        this.info = info;
        this.setLayout(new BorderLayout(0, 0));
        this.dragHandle = aCloseButton;
        this.contentPanel = content;
        if (!info.getShowTitleBar()) {
            if (this.isHorizontal) {
                this.add("North", this.dragHandle);
                this.add("Center", this.contentPanel);
            } else {
                this.add("West", this.dragHandle);
                this.add("Center", this.contentPanel);
            }
            this.helper = info.getCanDrag() ? new DragHelper(this, this.dragHandle) : null;
            this.decoratedPanel = this.getContentPanel();
        } else {
            this.decoratedPanel = new JPanel();
            this.decoratedPanel.setLayout(new BorderLayout());
            this.titleBar = new DockingWindowTitleBar(0, this.getInfo());
            this.decoratedPanel.add("North", this.titleBar);
            this.decoratedPanel.add("Center", this.contentPanel);
            this.add("West", this.dragHandle);
            this.add("Center", this.decoratedPanel);
            this.helper = info.getCanDrag() ? new DragHelper(this, this.titleBar) : null;
            this.setInfo(info);
        }
    }

    public void setSaveId(String saveId) {
        this.saveId = saveId;
    }

    public String getSaveId() {
        if (this.saveId == null) {
            return this.getContentPanel().getClass().getName();
        }
        return this.saveId;
    }

    public void setVisible(boolean visible) {
        DockingContainer cont;
        if (visible && !this.isVisible() && (cont = DockingContainer.findDockingContainer(this)) != null && cont.isAnyComponentVisible()) {
            int visi = cont.findLastVisibleIndex();
            int conti = cont.indexOfWrapper(this);
            if (conti > visi) {
                cont.freeSpace(conti, this.getSize());
            }
        }
        this.decoratedPanel.setVisible(visible);
        this.contentPanel.setVisible(visible);
        super.setVisible(visible);
    }

    public DockingWindowTitleBar getTitleBar() {
        return this.titleBar;
    }

    public void setInfo(DockingComponentInfo info) {
        this.info = info;
        if (this.titleBar != null) {
            this.titleBar.setTitle(info.getTitle());
        }
    }

    public DockingComponentInfo getInfo() {
        return this.info;
    }

    public void setContentPanel(JComponent comp, CollapsedPanelBar cpBar) {
        DockingDesktop dDesktop;
        boolean oldVisible;
        if (comp == null) {
            throw new RuntimeException("COMPONENT IS NULL");
        }
        JComponent oldContent = this.getContentPanel();
        if (this.decoratedPanel == this.contentPanel) {
            oldVisible = true;
            if (this.contentPanel != null) {
                oldVisible = this.contentPanel.isVisible();
                this.remove(this.contentPanel);
            }
            this.decoratedPanel = this.contentPanel = comp;
            comp.setVisible(oldVisible);
            this.add("Center", this.contentPanel);
        } else {
            oldVisible = true;
            if (this.contentPanel != null) {
                oldVisible = this.contentPanel.isVisible();
            }
            this.decoratedPanel.remove(this.contentPanel);
            this.contentPanel = comp;
            comp.setVisible(oldVisible);
            this.decoratedPanel.add("Center", this.contentPanel);
        }
        if (cpBar != null && comp != oldContent) {
            cpBar.updateInfo(oldContent, this);
        }
        if (comp != oldContent && (dDesktop = DockingContainer.findDockingDesktop(this)) != null) {
            DockingContainer dContainer = DockingContainer.findDockingContainer(this);
            dDesktop.handleActivation(dContainer, this);
            dDesktop.fireComponentAdded(this);
        }
        this.invalidate();
        this.repaint();
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    public JButton getDragButton() {
        return this.dragHandle;
    }

    public boolean isVisible() {
        return this.getContentPanel().isVisible() && super.isVisible();
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
        this.getTitleBar().repaint();
    }

    public JComponent getShapeOnStartDragging(MouseEvent ev) {
        if (!this.info.getCanDrag() || ev.getSource() instanceof SplitButton) {
            return null;
        }
        Dimension size = this.getSize();
        this.remove(this.decoratedPanel);
        this.remove(this.getDragButton());
        this.dragPanel.add("Center", this.decoratedPanel);
        if (!this.info.getShowTitleBar()) {
            if (this.isHorizontal) {
                this.dragPanel.add("North", this.getDragButton());
            } else {
                this.dragPanel.add("West", this.getDragButton());
            }
        }
        this.decoratedPanel.setSize(size.width, size.height);
        this.dragPanel.setSize(size.width, size.height);
        this.dragPanel.doLayout();
        return this.dragPanel;
    }

    public void notifyStopDragging(IDockingContainer dContainer, JComponent dragHandle, int screenX, int screenY, boolean componentExited) {
        if (componentExited) {
            DockingContainer cont = DockingContainer.findDockingContainer(this);
            JRootPane root = this.getRootPane();
            dContainer.componentDropped(screenX, screenY, cont, this);
            this.getParent().remove(this);
            this.remove(this.decoratedPanel);
            this.invalidate();
            this.validate();
            if (this.getRootPane() != null) {
                this.getRootPane().repaint();
            }
            if (dContainer != null) {
                dContainer.fireComponentRemovedToOtherContainer(cont, this);
            }
        } else {
            this.add("Center", this.decoratedPanel);
            if (this.isHorizontal) {
                this.add("North", this.getDragButton());
            } else {
                this.add("West", this.getDragButton());
            }
            this.invalidate();
            this.validate();
            if (this.getRootPane() != null) {
                this.getRootPane().repaint();
            }
        }
    }

    public void fireDragEnter(IDockingContainer target, int targetX, int targetY) {
        target.dragEnter(targetX, targetY, this);
    }

    public void fireDragOver(IDockingContainer target, int targetX, int targetY) {
        target.dragOver(targetX, targetY, this);
    }

    public void fireDragExit(IDockingContainer target) {
        if (target != null) {
            target.dragExit();
        }
    }
}

