/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.CollapsedPanelBar;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingComponentWrapper;
import de.netcomputing.swingx.DockingContainerListener;
import de.netcomputing.swingx.DockingDesktop;
import de.netcomputing.swingx.IDockingContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DockingContainer
extends JPanel
implements IDockingContainer,
MouseMotionListener,
MouseListener {
    CollapsedPanelBar stack;
    JPanel center;
    boolean isHorizontal = true;
    int maxComponents = 100;
    Vector listeners = new Vector(3);
    public static HashMap layoutCache = new HashMap(7);
    public static boolean disableLayoutRecalling = false;
    int xCorrection = 0;
    JComponent previewPanel;
    int lastInsertionIndex;
    HashMap savedLayout;

    public static DockingComponentWrapper findDockingWrapper(JComponent comp) {
        Container act = comp;
        while (act != null && !(act instanceof DockingComponentWrapper)) {
            act = act.getParent();
        }
        return (DockingComponentWrapper)act;
    }

    public static DockingComponentWrapper findWindowedDockingWrapper(JComponent comp) {
        Container act = comp;
        while (!(act == null || act instanceof DockingComponentWrapper || act instanceof DockingComponentWrapper && ((DockingComponentWrapper)act).getTitleBar() == null)) {
            act = act.getParent();
        }
        return (DockingComponentWrapper)act;
    }

    public static DockingContainer findDockingContainer(JComponent comp) {
        Container act = comp;
        while (act != null && !(act instanceof DockingContainer)) {
            act = act.getParent();
        }
        return (DockingContainer)act;
    }

    public static DockingDesktop findDockingDesktop(JComponent comp) {
        Container act = comp;
        while (act != null && !(act instanceof DockingDesktop)) {
            act = act.getParent();
        }
        return (DockingDesktop)act;
    }

    public DockingContainer(CollapsedPanelBar aStack) {
        this(aStack, true);
    }

    public DockingContainer(CollapsedPanelBar aStack, boolean horizontal) {
        this.stack = aStack;
        this.isHorizontal = horizontal;
        this.setLayout(new BorderLayout());
        this.center = new JPanel(){

            public void doLayout() {
                DockingContainer.this.layoutCenter();
            }

            public void remove(Component comp) {
                DockingContainer.this.stack.remove(comp);
                super.remove(comp);
            }
        };
        this.add("Center", this.center);
        this.center.setLayout(null);
    }

    public boolean getIsHorizontal() {
        return this.isHorizontal;
    }

    public int getDockedComponentCount() {
        return this.center.getComponentCount();
    }

    public DockingComponentWrapper getDockedComponent(int i) {
        return (DockingComponentWrapper)this.center.getComponent(i);
    }

    protected void wrapperAdded(DockingComponentWrapper dcWrapper) {
    }

    public void addDockingContainerListener(DockingContainerListener li) {
        if (!this.listeners.contains(li)) {
            this.listeners.add(li);
        }
    }

    public void removeDockingContainerListener(DockingContainerListener li) {
        this.listeners.remove(li);
    }

    public void fireComponentRemovedToOtherContainer(IDockingContainer oldCont, DockingComponentWrapper dragged) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingContainerListener)this.listeners.get(i)).componentRemovedToOtherContainer(oldCont, dragged);
            ++i;
        }
    }

    public void fireComponentDroppedFromOtherContainer(DockingComponentWrapper dragged) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingContainerListener)this.listeners.get(i)).componentDroppedFromOtherContainer(dragged);
            ++i;
        }
    }

    public DockingComponentWrapper setComponent(JComponent comp, DockingComponentInfo title, int index) {
        if (index < this.center.getComponentCount()) {
            this.center.remove(index);
        }
        DockingComponentWrapper sp = this.stack.addDockedComponent(comp, title);
        this.center.add((Component)sp, index);
        ((JComponent)comp.getParent()).setOpaque(true);
        this.wrapperAdded(sp);
        return sp;
    }

    public DockingComponentWrapper insertComponent(JComponent comp, DockingComponentInfo title, int index) {
        DockingComponentWrapper sp = this.stack.addDockedComponent(comp, title, !this.isHorizontal);
        sp.getDragButton().addMouseListener(this);
        sp.getDragButton().addMouseMotionListener(this);
        this.center.add((Component)sp, index);
        sp.setSize(comp.getSize());
        sp.setOpaque(true);
        comp.setVisible(true);
        sp.doLayout();
        this.center.doLayout();
        this.wrapperAdded(sp);
        return sp;
    }

    public DockingComponentWrapper addComponent(JComponent comp, DockingComponentInfo title) {
        return this.addComponent(comp, title, !this.isHorizontal);
    }

    public DockingComponentWrapper addComponent(JComponent comp, DockingComponentInfo title, boolean horiz) {
        if (title.getShowTitleBar()) {
            horiz = false;
        }
        if (title.getHideDragButton()) {
            this.center.add(comp);
            return null;
        }
        DockingComponentWrapper sp = this.stack.addDockedComponent(comp, title, horiz);
        this.center.add(sp);
        sp.getDragButton().addMouseListener(this);
        sp.getDragButton().addMouseMotionListener(this);
        ((JComponent)comp.getParent()).setOpaque(true);
        ((JComponent)comp.getParent()).setSize(comp.getMinimumSize());
        this.wrapperAdded(sp);
        return sp;
    }

    public void removeDockingComponent(JComponent contentComponent) {
        DockingComponentWrapper dcWrapper = DockingContainer.findDockingWrapper(contentComponent);
        if (dcWrapper != null) {
            this.center.remove(dcWrapper);
        } else {
            this.center.remove(contentComponent);
        }
    }

    public void removeDockingComponent(DockingComponentWrapper dc) {
        this.center.remove(dc);
        this.stack.remove(dc);
    }

    public int indexOfWrapper(DockingComponentWrapper dcWrapper) {
        int i = 0;
        while (i < this.center.getComponentCount()) {
            if (this.center.getComponent(i) == dcWrapper) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void freeSpace(int insertionIndex, Dimension d) {
        int i = this.findLastVisibleIndex();
        if (i >= 0 && i < this.center.getComponentCount()) {
            if (this.isHorizontal) {
                int toFree = d.width;
                JComponent comp = (JComponent)this.center.getComponent(i);
                comp.setSize(comp.getWidth() - toFree, comp.getHeight());
            } else {
                int toFree = d.height;
                JComponent comp = (JComponent)this.center.getComponent(i);
                comp.setSize(comp.getWidth(), comp.getHeight() - toFree);
            }
        }
    }

    public int findLastVisibleIndex() {
        int lastVisible = this.center.getComponentCount() - 1;
        if (lastVisible < 0) {
            return -1;
        }
        JComponent act = (JComponent)this.center.getComponent(lastVisible);
        while (lastVisible > 0 && !act.isVisible()) {
            act = (JComponent)this.center.getComponent(--lastVisible);
        }
        return lastVisible;
    }

    public void layoutCenter() {
        if (this.isHorizontal) {
            Component[] comps = this.center.getComponents();
            int xpos = 0;
            int lastVisibleIndex = this.findLastVisibleIndex();
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent comp = (JComponent)this.center.getComponent(i);
                if (comp.isVisible()) {
                    int sumMin = 0;
                    int ii = i;
                    while (ii >= 0 && ii < this.center.getComponentCount()) {
                        if (this.center.getComponent(ii).isVisible()) {
                            sumMin += this.center.getComponent((int)ii).getMinimumSize().width;
                        }
                        ++ii;
                    }
                    if (i != 0 && xpos > this.center.getWidth() - sumMin) {
                        int newxpos = this.center.getWidth() - sumMin;
                        int correction = xpos - newxpos;
                        xpos = newxpos;
                        int lastVisible = i - 1;
                        JComponent act = (JComponent)this.center.getComponent(lastVisible);
                        while (lastVisible > 0 && !act.isVisible()) {
                            act = (JComponent)this.center.getComponent(--lastVisible);
                        }
                        if (lastVisible >= 0) {
                            this.center.getComponent(lastVisible).setSize(this.center.getComponent(lastVisible).getWidth() - correction, this.center.getHeight());
                            comp.setBounds(xpos, 0, comp.getMinimumSize().width, this.center.getHeight());
                        }
                    } else if (i == lastVisibleIndex) {
                        comp.setBounds(xpos, 0, this.getWidth() - xpos, this.center.getHeight());
                    } else {
                        comp.setBounds(xpos, 0, Math.max(comp.getWidth(), comp.getMinimumSize().width), this.center.getHeight());
                    }
                    xpos += comp.getWidth();
                }
                ++i;
            }
            this.putCurrentLayout();
        } else {
            Component[] comps = this.center.getComponents();
            int ypos = 0;
            int lastVisibleIndex = this.findLastVisibleIndex();
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent comp = (JComponent)this.center.getComponent(i);
                if (comp.isVisible()) {
                    int sumMin = 0;
                    int ii = i;
                    while (ii >= 0 && ii < this.center.getComponentCount()) {
                        if (this.center.getComponent(ii).isVisible()) {
                            sumMin += this.center.getComponent((int)ii).getMinimumSize().height;
                        }
                        ++ii;
                    }
                    if (i != 0 && ypos > this.center.getHeight() - sumMin) {
                        int newypos = this.center.getHeight() - sumMin;
                        int correction = ypos - newypos;
                        ypos = newypos;
                        int lastVisible = i - 1;
                        JComponent act = (JComponent)this.center.getComponent(lastVisible);
                        while (lastVisible > 0 && !act.isVisible()) {
                            act = (JComponent)this.center.getComponent(--lastVisible);
                        }
                        if (lastVisible >= 0) {
                            this.center.getComponent(lastVisible).setSize(this.center.getWidth(), this.center.getComponent(lastVisible).getHeight() - correction);
                            comp.setBounds(0, ypos, this.center.getWidth(), comp.getMinimumSize().height);
                        }
                    } else if (i == lastVisibleIndex) {
                        comp.setBounds(0, ypos, this.center.getWidth(), this.getHeight() - ypos);
                    } else {
                        comp.setBounds(0, ypos, this.center.getWidth(), Math.max(comp.getHeight(), comp.getMinimumSize().height));
                    }
                    ypos += comp.getHeight();
                }
                ++i;
            }
            this.putCurrentLayout();
        }
    }

    public boolean isEmpty() {
        return this.center.getComponentCount() == 0;
    }

    public IDockingContainer getDockingParent() {
        return DockingContainer.findDockingContainer((JComponent)this.getParent());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean isAnyComponentVisible() {
        int ii = 0;
        while (ii < this.center.getComponentCount()) {
            if (this.center.getComponent(ii).isVisible()) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public Dimension getMinimumSize() {
        if (!this.isAnyComponentVisible()) {
            return new Dimension(0, 0);
        }
        if (this.isHorizontal) {
            int minHeight = 0;
            int ii = 0;
            while (ii < this.center.getComponentCount()) {
                if (this.center.getComponent(ii).isVisible()) {
                    minHeight = Math.max(minHeight, this.center.getComponent((int)ii).getMinimumSize().height);
                }
                ++ii;
            }
            return new Dimension(10, minHeight);
        }
        int minWidth = 0;
        int ii = 0;
        while (ii < this.center.getComponentCount()) {
            if (this.center.getComponent(ii).isVisible()) {
                minWidth = Math.max(minWidth, this.center.getComponent((int)ii).getMinimumSize().width);
            }
            ++ii;
        }
        return new Dimension(minWidth, 10);
    }

    public JComponent createNewComponent(DockingComponentInfo[] resTitle) {
        resTitle[0] = new DockingComponentInfo("New Component");
        return new JButton("NEW");
    }

    public HashMap saveLayout() {
        HashMap<Component, Dimension> res = new HashMap<Component, Dimension>();
        int i = 0;
        while (i < this.center.getComponentCount()) {
            res.put(this.center.getComponent(i), this.center.getComponent(i).size());
            ++i;
        }
        return res;
    }

    public void loadLayout(HashMap map) {
        int i = 0;
        while (i < this.center.getComponentCount()) {
            Dimension dimension = (Dimension)map.get(this.center.getComponent(i));
            if (dimension != null) {
                this.center.getComponent(i).setSize(dimension);
            }
            ++i;
        }
    }

    public ArrayList getLayoutAsList() {
        ArrayList<Dimension> res = new ArrayList<Dimension>(7);
        int i = 0;
        while (i < this.center.getComponentCount()) {
            if (this.center.getComponent(i).isVisible()) {
                Dimension dimension = this.center.getComponent(i).getSize();
                res.add(dimension);
            }
            ++i;
        }
        return res;
    }

    public String computeLayoutKey() {
        String key = "";
        int i = 0;
        while (i < this.center.getComponentCount()) {
            DockingComponentWrapper dcWrapper;
            if (this.center.getComponent(i) instanceof DockingComponentWrapper && (dcWrapper = (DockingComponentWrapper)this.center.getComponent(i)).isVisible() && dcWrapper.getTitleBar() != null) {
                key = key + dcWrapper.getTitleBar().getTitle() + "#";
            }
            ++i;
        }
        return key;
    }

    public void putCurrentLayout() {
        if (!disableLayoutRecalling) {
            String s = this.computeLayoutKey();
            layoutCache.put(s, this.getLayoutAsList());
        }
    }

    public void recallCurrentLayout() {
        if (disableLayoutRecalling || !this.isHorizontal) {
            return;
        }
        String s = this.computeLayoutKey();
        System.out.println("RETRIEVE LAYOUT:" + s);
        ArrayList al = (ArrayList)layoutCache.get(s);
        if (al != null) {
            int alCount = 0;
            int i = 0;
            while (i < this.center.getComponentCount()) {
                DockingComponentWrapper dcWrapper;
                if (this.center.getComponent(i) instanceof DockingComponentWrapper && (dcWrapper = (DockingComponentWrapper)this.center.getComponent(i)).isVisible() && dcWrapper.getTitleBar() != null) {
                    Dimension dim = (Dimension)al.get(alCount++);
                    dim.height = this.center.getComponent(i).getHeight();
                    this.center.getComponent(i).setSize(dim);
                }
                ++i;
            }
        }
        this.layoutCenter();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isHorizontal) {
            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
            int x = e.getX() + p.x;
            JComponent comp = (JComponent)e.getSource();
            if (!e.isControlDown()) {
                int newPos;
                int index = -1;
                int i = 0;
                while (i < this.center.getComponentCount()) {
                    if (this.center.getComponent(i) == comp.getParent()) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                int currentPos = this.center.getLocationOnScreen().x;
                int xpos = newPos = x - currentPos - this.xCorrection;
                if (index > 0) {
                    int lastVisible = index - 1;
                    JComponent act = (JComponent)this.center.getComponent(lastVisible);
                    while (lastVisible > 0 && !act.isVisible()) {
                        act = (JComponent)this.center.getComponent(--lastVisible);
                    }
                    if (lastVisible >= 0) {
                        act.setSize(newPos - act.getX(), act.getHeight());
                    }
                } else if (newPos > 10 && this.center.getComponentCount() < this.maxComponents) {
                    this.addEmptyComponent();
                }
                this.center.invalidate();
                this.center.validate();
            }
        } else {
            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
            int y = e.getY() + p.y;
            JComponent comp = (JComponent)e.getSource();
            if (!e.isControlDown()) {
                int newPos;
                int index = -1;
                int i = 0;
                while (i < this.center.getComponentCount()) {
                    if (this.center.getComponent(i) == comp.getParent()) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                int currentPos = this.center.getLocationOnScreen().y;
                int ypos = newPos = y - currentPos - this.xCorrection;
                if (index > 0) {
                    int lastVisible = index - 1;
                    JComponent act = (JComponent)this.center.getComponent(lastVisible);
                    while (lastVisible > 0 && !act.isVisible()) {
                        act = (JComponent)this.center.getComponent(--lastVisible);
                    }
                    if (lastVisible >= 0) {
                        act.setSize(act.getWidth(), newPos - act.getY());
                    }
                } else if (newPos > 10 && this.center.getComponentCount() < this.maxComponents) {
                    this.addEmptyComponent();
                }
                this.center.invalidate();
                this.center.validate();
            }
        }
    }

    public void addEmptyComponent() {
        this.addEmptyComponent(0);
    }

    public void addEmptyComponent(int index) {
        DockingComponentInfo[] title = new DockingComponentInfo[]{null};
        JComponent newComp = this.createNewComponent(title);
        this.insertComponent(newComp, title[0], index);
    }

    public void setMaxComponents(int maxComponents) {
        this.maxComponents = maxComponents;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.xCorrection = this.isHorizontal ? e.getX() : e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.xCorrection = 0;
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.isHorizontal) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean canDrop(int x, int y, JComponent sp) {
        return true;
    }

    public void dragOver(int x, int y, DockingComponentWrapper sp) {
        JComponent comp = sp.getContentPanel();
        if (this.isHorizontal) {
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (x < c.getX() + c.getWidth() / 2) {
                    if (this.lastInsertionIndex == i) break;
                    System.out.println("LI:" + this.lastInsertionIndex + " I:" + i);
                    System.out.println("x:" + x + " c.getX()-c.getWidth()/2:" + (c.getX() - c.getWidth() / 2));
                    this.center.remove(this.previewPanel);
                    this.previewPanel.setMinimumSize(comp.getMinimumSize());
                    this.center.add((Component)this.previewPanel, i);
                    this.lastInsertionIndex = i + 1;
                    this.center.invalidate();
                    this.center.validate();
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (y < c.getY() + c.getHeight() / 2) {
                    if (this.lastInsertionIndex == i) break;
                    System.out.println("LI:" + this.lastInsertionIndex + " I:" + i);
                    System.out.println("y:" + y + " c.getY()-c.getHeight()/2:" + (c.getY() - c.getHeight() / 2));
                    this.center.remove(this.previewPanel);
                    this.previewPanel.setMinimumSize(comp.getMinimumSize());
                    this.center.add((Component)this.previewPanel, i);
                    this.lastInsertionIndex = i + 1;
                    this.center.invalidate();
                    this.center.validate();
                    break;
                }
                ++i;
            }
        }
    }

    public void dragEnter(int x, int y, DockingComponentWrapper sp) {
        JComponent comp = sp.getContentPanel();
        this.savedLayout = this.saveLayout();
        if (this.isHorizontal) {
            if (this.previewPanel == null) {
                this.previewPanel = new JLabel("");
                this.previewPanel.setOpaque(true);
                this.previewPanel.setBackground(this.getBackground().darker());
                this.previewPanel.setMinimumSize(new Dimension(40, 40));
            }
            this.previewPanel.setSize(comp.getMinimumSize().width, this.center.getHeight());
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (x > c.getX() - c.getWidth() / 2 && x < c.getX() + c.getWidth() / 2) {
                    this.center.add((Component)this.previewPanel, i);
                    this.previewPanel.setMinimumSize(comp.getMinimumSize());
                    this.lastInsertionIndex = i + 1;
                    this.center.invalidate();
                    this.center.validate();
                    break;
                }
                ++i;
            }
        } else {
            if (this.previewPanel == null) {
                this.previewPanel = new JLabel("");
                this.previewPanel.setOpaque(true);
                this.previewPanel.setBackground(this.getBackground().darker());
                this.previewPanel.setMinimumSize(new Dimension(40, 40));
            }
            this.previewPanel.setSize(this.center.getWidth(), comp.getMinimumSize().height);
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (y > c.getY() - c.getHeight() / 2 && y < c.getY() + c.getHeight() / 2) {
                    this.center.add((Component)this.previewPanel, i);
                    this.previewPanel.setMinimumSize(comp.getMinimumSize());
                    this.lastInsertionIndex = i + 1;
                    this.center.invalidate();
                    this.center.validate();
                    break;
                }
                ++i;
            }
        }
    }

    public void dragExit() {
        if (this.savedLayout != null) {
            this.loadLayout(this.savedLayout);
        }
        this.savedLayout = null;
        if (this.previewPanel != null) {
            this.center.remove(this.previewPanel);
            this.center.invalidate();
            this.center.validate();
        }
        this.lastInsertionIndex = -1;
    }

    public void componentDropped(int x, int y, DockingContainer oldDock, DockingComponentWrapper sp) {
        DockingContainer cont = this.createAutoWrapDockingContainer(sp);
        if (cont == null) {
            JComponent comp = sp.getContentPanel();
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (c == this.previewPanel) {
                    this.center.remove(this.previewPanel);
                    comp.setVisible(true);
                    this.insertComponent(comp, sp.getInfo(), i);
                    break;
                }
                ++i;
            }
        } else {
            DockingComponentWrapper wr = cont.addComponent(sp.getContentPanel(), sp.getInfo());
            boolean found = false;
            int i = 0;
            while (i < this.center.getComponentCount()) {
                JComponent c = (JComponent)this.center.getComponent(i);
                if (c == this.previewPanel) {
                    this.center.remove(this.previewPanel);
                    cont.setVisible(true);
                    this.insertComponent(cont, this.createAutoWrapDockingInfo(sp), i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.insertComponent(cont, this.createAutoWrapDockingInfo(sp), 0);
            }
            this.wrapperAdded(wr);
        }
        this.lastInsertionIndex = -1;
        this.previewPanel = null;
        this.dragExit();
        this.center.invalidate();
        this.invalidate();
        this.validate();
        this.fireComponentRemovedToOtherContainer(oldDock, sp);
        this.fireComponentDroppedFromOtherContainer(sp);
    }

    public DockingContainer createAutoWrapDockingContainer(DockingComponentWrapper sp) {
        return null;
    }

    public DockingComponentInfo createAutoWrapDockingInfo(DockingComponentWrapper sp) {
        DockingComponentInfo result = new DockingComponentInfo("");
        result.setShowTitleBar(false);
        result.setCanHide(false);
        result.setButtonType(2);
        return result;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        CollapsedPanelBar stack = new CollapsedPanelBar(null, "Eurex", null);
        DockingContainer dc = new DockingContainer(stack);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add("South", stack);
        JPanel center = new JPanel();
        f.getContentPane().add("Center", center);
        center.setLayout(new BoxLayout(center, 1));
        center.add(dc);
        dc.addComponent(new ColButton(Color.red, "Button 0"), new DockingComponentInfo("0"));
        dc.addComponent(new ColButton(Color.green, "Button 2"), new DockingComponentInfo("0"));
        dc.addComponent(new ColButton(Color.yellow, "Button 3"), new DockingComponentInfo("0"));
        dc.addComponent(new ColButton(Color.blue, "Button 4"), new DockingComponentInfo("0"));
        f.pack();
        f.setBounds(0, 0, 640, 400);
        f.show();
    }

    static class ColButton
    extends JButton {
        public ColButton(Color c, String tit) {
            super(tit);
            this.setBackground(c);
        }
    }
}

