/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

class SplitButton
extends JButton {
    boolean isHorizontal;
    static BasicButtonUI ui = new BasicButtonUI();

    public SplitButton(boolean horz) {
        this.isHorizontal = horz;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setOpaque(true);
    }

    public ButtonUI getUI() {
        return ui;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isHorizontal) {
            graphics.setColor(Color.black);
            graphics.drawLine(0, 3, this.getWidth(), 3);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(0, 2, this.getWidth(), 2);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(3, 0, 3, this.getHeight());
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(0, 0, 0, this.getHeight());
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(2, 0, 2, this.getHeight());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        if (this.isHorizontal && this.getParent() != null) {
            return this.getParent().getWidth();
        }
        return 4;
    }

    public int getHeight() {
        if (this.getParent() == null) {
            return 4;
        }
        if (!this.isHorizontal) {
            return this.getParent().getHeight();
        }
        return 4;
    }
}

