/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.templates.engine;

import de.netcomputing.templates.engine.IContextReceiver;
import de.netcomputing.templates.engine.TemplateExecutionException;
import de.netcomputing.templates.engine.TemplateSplitter;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Executor;
import netcomputing.tools.INCExtendedPrintout;

public class TemplateExecutor {
    File templateFile;
    File outputFile;
    Object context;
    static String TMPDIR = "tempgen";
    boolean sysout = false;
    static boolean CompileIntern = false;

    public TemplateExecutor(String tmpDir) {
        TMPDIR = tmpDir;
    }

    public TemplateExecutor(String tmpDir, File templateFile, File outputFile, Object context) {
        this(tmpDir);
        this.setFiles(templateFile, outputFile, context);
    }

    String getNameWithoutExt(File f) {
        String fil = f.getName();
        if (fil.lastIndexOf(46) >= 0) {
            return fil.substring(0, fil.lastIndexOf(46));
        }
        return fil;
    }

    public void setFiles(File templateFile, File outputFile, Object context) {
        this.templateFile = templateFile;
        this.outputFile = outputFile;
        this.context = context;
    }

    public boolean execute() throws Exception {
        return this.execute(null);
    }

    public boolean execute(PrintStream output) throws Exception {
        INCExtendedPrintout ncout = JEBatchHostFrame.This().createOutput("TExec");
        File tempFile = new File(TMPDIR);
        MyCL myCl = new MyCL();
        if (!tempFile.exists()) {
            tempFile.mkdir();
        }
        if (!tempFile.exists() || !tempFile.isDirectory()) {
            throw new TemplateExecutionException("Could not create temporary directory, aborting. (" + tempFile.getAbsolutePath() + ")");
        }
        try {
            String className = null;
            className = this.outputFile != null ? this.getNameWithoutExt(this.outputFile) : "GEN" + (int)(Math.random() * 10000.0);
            File clazzFile = new File(TMPDIR + File.separator + className + "GEN.class");
            tempFile = new File(TMPDIR + File.separator + className + "GEN.java");
            PrintStream javaOut = new PrintStream(new FileOutputStream(tempFile));
            if (!clazzFile.exists() || clazzFile.lastModified() != this.templateFile.lastModified()) {
                new File(TMPDIR + File.separator + className + "GEN.class").delete();
                FileInputStream in = null;
                in = new FileInputStream(this.templateFile);
                TemplateSplitter splitter = new TemplateSplitter(in, javaOut);
                splitter.setClazzName(className + "GEN");
                splitter.run();
                splitter.closeIn();
                splitter.closeOut();
                Tracer.This.println("Compiling:" + tempFile.getAbsolutePath());
                int res = TemplateExecutor.compile(new String[]{"-d", TMPDIR, tempFile.getAbsolutePath()});
                if (res != 0) {
                    throw new TemplateExecutionException("COMPILE ERROR:" + res);
                }
                Tracer.This.println("COMPILE PROCESS RESULT:" + res);
            }
            File clzFi = new File(TMPDIR + File.separator + className + "GEN.class");
            int len = (int)clzFi.length();
            byte[] clz = new byte[len];
            FileInputStream clzIn = new FileInputStream(clzFi);
            clzIn.read(clz);
            clzIn.close();
            myCl.defineClass(clz);
            Class<?> clazz = null;
            try {
                clazz = myCl.loadClass(className + "GEN");
            }
            catch (ClassNotFoundException ex) {
                NCStringUtilities.DumpException(ncout, ex);
                throw new TemplateExecutionException("ERROR: Could not locate compiled class, please add '.\\tempgen' to your bootclasspath");
            }
            Tracer.This.println("loaded class:" + clazz.getName());
            Object target = clazz.newInstance();
            PrintStream out = output;
            if (out == null) {
                out = new PrintStream(new FileOutputStream(this.outputFile));
            }
            if (this.sysout) {
                ((IContextReceiver)target).receiveContext(this.context, Tracer.This);
            }
            ((IContextReceiver)target).receiveContext(this.context, out);
            if (this.outputFile != null) {
                out.close();
            }
        }
        catch (Throwable ex) {
            NCStringUtilities.DumpException(ncout, ex);
            throw new TemplateExecutionException("Error during template Execution, view Tracer.This");
        }
        return true;
    }

    public static int compile(String[] args) {
        if (CompileIntern) {
            return 0;
        }
        String cline = "($jdkhome)" + File.separator + "bin" + File.separator + "javac " + "-classpath " + "($anyjbin)" + File.separator + "classes" + File.pathSeparator + "($anyjbin)" + File.separator + "anyj.jar" + File.pathSeparator + "($outputDir) ";
        cline = EditApp.App.getTemplateEngine().insertEnvVars(cline, null);
        System.out.println(cline);
        int i = 0;
        while (i < args.length) {
            cline = cline + args[i] + " ";
            ++i;
        }
        INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("TExec", false);
        Process p = Executor.Exec(cline, File.separator, out);
        try {
            return p.waitFor();
        }
        catch (Exception ex) {
            NCStringUtilities.DumpException(out, ex);
            return -99;
        }
    }

    static class MyCL
    extends ClassLoader {
        MyCL() {
        }

        public void defineClass(byte[] b) {
            super.defineClass(b, 0, b.length);
        }
    }
}

