/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.templates.engine;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class TemplateSplitter {
    InputStream in;
    PrintStream out;
    String clazzName;

    String replace(String s, String key, String value, int start) {
        int i = s.indexOf(key, start);
        if (i < 0) {
            return s;
        }
        StringBuffer res = new StringBuffer(s.length());
        res.append(s.substring(0, i));
        res.append(value);
        res.append(s.substring(i + key.length()));
        return this.replace(res.toString(), key, value, i + value.length());
    }

    public TemplateSplitter() {
    }

    public TemplateSplitter(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    public void run(InputStream in, PrintStream out) throws IOException {
        this.in = in;
        this.out = out;
        this.run();
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public void run() throws IOException {
        int prevChar = -1;
        int c = 0;
        StringBuffer line = new StringBuffer(2000);
        int lineCount = 0;
        while ((c = this.in.read()) >= 0) {
            if (c == 10) {
                ++lineCount;
            }
            if (c == 37 && prevChar == 60) {
                boolean isInLine = false;
                if (line.length() > 0) {
                    line.setLength(line.length() - 1);
                    if (line.length() > 0) {
                        isInLine = true;
                        this.out.print("out.print( \"" + line.toString() + "\"");
                    }
                }
                StringBuffer b = new StringBuffer(2000);
                while (((c = this.in.read()) != 62 || prevChar != 37) && c > 0) {
                    if (c == 10) {
                        ++lineCount;
                    }
                    b.append((char)c);
                    prevChar = c;
                }
                b.setLength(b.length() - 1);
                if (isInLine && (b.length() <= 0 || b.charAt(0) != '+')) {
                    this.out.println("); // template line:" + lineCount);
                    line.setLength(0);
                    isInLine = false;
                }
                String toInsert = b.toString();
                if (this.clazzName != null) {
                    toInsert = this.replace(toInsert, "CLAZZNAME", this.clazzName, 0);
                }
                if (isInLine) {
                    this.out.print(toInsert);
                    this.out.println(");// template line:" + lineCount);
                    line.setLength(0);
                } else if (toInsert.length() > 0 && toInsert.charAt(0) == '+') {
                    this.out.println("out.print(\"\"" + toInsert + " ); // template line:" + lineCount);
                } else {
                    this.out.println(toInsert + "// template line:" + lineCount);
                }
                prevChar = -1;
                continue;
            }
            line.append((char)c);
            if (prevChar >= 0 && c == 10) {
                while (line.length() > 0 && line.charAt(line.length() - 1) <= ' ') {
                    line.setLength(line.length() - 1);
                }
                this.out.println("out.println( \"" + line.toString() + "\" ); // template line:" + lineCount);
                line.setLength(0);
            }
            prevChar = c;
        }
        if (line.length() > 0) {
            while (line.length() > 0 && line.charAt(line.length() - 1) <= '\u0000') {
                line.setLength(line.length() - 1);
            }
            this.out.println("out.println( \"" + line.toString() + "\" ); // template line:" + lineCount);
        }
    }

    public void closeIn() {
        try {
            this.in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void closeOut() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream("c:\\temp\\tpl\\sample.jpl");
        PrintStream out = new PrintStream(new FileOutputStream("c:\\temp\\tpl\\sample.java"));
        TemplateSplitter splitter = new TemplateSplitter(in, out);
        splitter.run();
        splitter.closeIn();
        splitter.closeOut();
    }
}

