/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util;

import JCollections.DirIterator;
import JCollections.JIterationFunc;
import JCollections.JSet;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.DirDiffResult;
import de.netcomputing.anyj.jwidgets.INCStatus;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import netcomputing.file.SimpleDirCopier;
import netcomputing.tools.INCPrintOut;

public class NCFileUtilities {
    static int cnt = 0;

    public static File GetTmpFile() {
        ++cnt;
        File d = new File("c:\\temp");
        if (EditApp.App != null) {
            d = new File(VFile.ResolveName("#process"));
        }
        File f = new File(d, "tmpout" + cnt + ".txt");
        while (f.exists()) {
            f = new File(d, "tmpout" + cnt + ".txt");
            ++cnt;
        }
        return f;
    }

    public static File GetRenamedFile(File start) {
        boolean cnt = false;
        File f = new File(start.getAbsolutePath() + "~");
        while (f.exists()) {
            f = new File(f.getAbsolutePath() + "~");
        }
        return f;
    }

    public static File FindCFGFile(String fiName, File dir) {
        while (dir != null && dir.getAbsolutePath().length() > 3) {
            File res = new File(dir, fiName);
            if (res.exists()) {
                return res;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties AsProps(File f) {
        block12: {
            if (f == null) break block12;
            Properties res = new Properties();
            FileInputStream in = null;
            in = new FileInputStream(f);
            res.load(in);
            Properties properties = res;
            Object var5_5 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
            return properties;
            catch (Exception ex) {
                ex.printStackTrace();
                Object var5_6 = null;
                {
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        return null;
    }

    public static File SourcepathLookUp(String path, String fullName) {
        return NCFileUtilities.SourcepathLookUp(NCFileUtilities.GetPathAsVector(path), fullName);
    }

    public static void CopyDirRec(File source, File target, boolean deleteSource) throws Exception {
        target.mkdirs();
        SimpleDirCopier rfCopier = new SimpleDirCopier(deleteSource);
        rfCopier.copyRecursive(source.getAbsolutePath(), target.getAbsolutePath());
    }

    public static File SourcepathLookUp(Vector path, String fullName) {
        if (fullName == null) {
            return null;
        }
        try {
            fullName = fullName.replace('.', File.separatorChar);
            fullName = fullName.replace('/', File.separatorChar);
            int n = 0;
            while (n < path.size()) {
                String dir = path.elementAt(n).toString();
                File f = new File(dir + File.separator + fullName + ".java");
                if (f.exists() && f.getCanonicalFile().getName().equals(f.getName())) {
                    return f;
                }
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static DirDiffResult compare(File a, File b, FilenameFilter filter, boolean ignoreComments, boolean ignoreWS) throws Exception {
        String s;
        a = a.getCanonicalFile();
        b = b.getCanonicalFile();
        final JSet setA = new JSet(100);
        final JSet setB = new JSet(100);
        JSet diffs = new JSet(100);
        final int aLen = a.getAbsolutePath().length();
        final int bLen = b.getAbsolutePath().length();
        DirIterator.Iterate(a, new JIterationFunc(){

            public boolean func(Object o) {
                String s = ((File)o).getAbsolutePath().substring(aLen);
                setA.add(s);
                return false;
            }
        }, true, filter);
        DirIterator.Iterate(b, new JIterationFunc(){

            public boolean func(Object o) {
                String s = ((File)o).getAbsolutePath().substring(bLen);
                setB.add(s);
                return false;
            }
        }, true, filter);
        Enumeration e = setA.enumerate();
        while (e.hasMoreElements()) {
            String s2 = (String)e.nextElement();
            if (setB.find(s2) == null) continue;
            try {
                TextDocument doc = new TextDocument();
                doc.init(null);
                doc.coreLoad(new File(a.getAbsolutePath() + File.separator + s2));
                TextDocument doc1 = new TextDocument();
                doc1.init(null);
                doc1.coreLoad(new File(b.getAbsolutePath() + File.separator + s2));
                if (!ignoreComments) {
                    if (doc.isEqual(doc1, ignoreWS)) continue;
                    diffs.add(s2);
                    continue;
                }
                if (doc.isEqualsIgnoreComments(doc1, ignoreWS)) continue;
                diffs.add(s2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JSet toRemove = new JSet(200);
        e = setB.enumerate();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (!setA.contains(s)) continue;
            toRemove.add(s);
        }
        e = toRemove.enumerate();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            setA.rem(s);
            setB.rem(s);
        }
        return new DirDiffResult(a.getAbsolutePath(), b.getAbsolutePath(), setA, setB, diffs, filter);
    }

    public static byte[] GetFileBytes(File f) throws IOException {
        byte[] b = new byte[(int)f.length()];
        FileInputStream fin = new FileInputStream(f);
        fin.read(b);
        fin.close();
        return b;
    }

    public static void BuildImportMap(Vector files, HashMap fileToImport, HashSet knownPacks, INCPrintOut warnings, INCStatus status) {
        if (status != null) {
            status.setText("Scanning for unknown packages ");
            status.setDone(0);
        }
        Vector v = files;
        if (status != null) {
            status.setToDo(v.size());
        }
        JSet tmpCol = new JSet();
        int i = 0;
        while (i < v.size()) {
            File fi;
            if (status != null) {
                status.setDone(i);
            }
            if (!(fi = (File)v.get(i)).isDirectory()) {
                tmpCol.clear();
                TextDocument tmpDoc = new TextDocument(fi);
                String pack = DocumentStream.ScanImports(tmpDoc, tmpCol);
                fileToImport.put(fi.getAbsolutePath(), tmpCol.asVector());
                knownPacks.add(pack);
            }
            ++i;
        }
    }

    public static Vector IsSourceRootDir(String baseDir, boolean[] abort) {
        Vector v = DirIterator.DirContent(new File(baseDir), ".java", true);
        Vector<String> result = new Vector<String>();
        abort[0] = false;
        if (v.size() == 0) {
            abort[0] = false;
            result.add("Directory contains no .java Files !");
        } else {
            int i = 0;
            while (i < v.size()) {
                File f = (File)v.get(i);
                if (!f.isDirectory()) {
                    String pack = DocumentStream.ScanPackage(f);
                    if (!f.equals(new File(baseDir, (pack = pack.replace('.', File.separatorChar)) + File.separator + f.getName()))) {
                        result.add("Package / Directory mismatch in " + f.getAbsolutePath());
                        abort[0] = true;
                    }
                    if (result.size() > 15) {
                        result.addElement("more errors ..");
                        return result;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static void CheckSourceDir(String baseDir, HashMap fqClazzToFile, INCPrintOut warnings, INCStatus status, List packMismatch, List doubleClass) {
        if (status != null) {
            status.setText("Scanning " + baseDir);
            status.setDone(0);
        }
        Vector v = DirIterator.DirContent(new File(baseDir), ".java");
        if (status != null) {
            status.setToDo(v.size());
        }
        int i = 0;
        while (i < v.size()) {
            File fi;
            if (status != null) {
                status.setDone(i);
            }
            if (!(fi = (File)v.get(i)).isDirectory()) {
                String conflict;
                String pack = DocumentStream.ScanPackage(fi);
                if (pack == null || pack.length() == 0) {
                    if (warnings != null) {
                        warnings.printLine("[WARN ] NO PACKAGE - " + fi.getAbsolutePath() + ":0");
                    }
                    pack = "";
                }
                String fqClass = pack + "." + fi.getName().substring(0, fi.getName().length() - ".java".length());
                pack = pack.replace('.', File.separatorChar);
                if (!fi.getParent().endsWith(pack)) {
                    if (warnings != null) {
                        warnings.printLine("[ERROR] PACKAGE/DIRECTORY MISMATCH - " + fi.getAbsolutePath() + ":0:");
                    }
                    packMismatch.add(fi);
                }
                if ((conflict = (String)fqClazzToFile.get(fqClass)) != null && !fi.getAbsolutePath().equals(conflict)) {
                    if (warnings != null) {
                        warnings.printLine("[ERROR] Double Class - " + fi.getAbsolutePath() + ":0:");
                        warnings.printLine("                     - " + conflict + ":0:");
                    }
                    doubleClass.add(new Object[]{conflict, fi.getAbsolutePath()});
                } else {
                    fqClazzToFile.put(fqClass, fi.getAbsolutePath());
                }
            }
            ++i;
        }
    }

    public static Vector GetPathAsVector(String path) {
        Vector res = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        int i = 0;
        while (i < res.size()) {
            String s = (String)res.get(i);
            while (s.endsWith(File.separator)) {
                s = s.substring(0, s.length() - 1);
            }
            res.set(i, s);
            ++i;
        }
        return res;
    }

    public static String GetVectorAsPath(Vector path) {
        String res = "";
        int i = 0;
        while (i < path.size()) {
            res = res + path.get(i) + File.pathSeparator;
            ++i;
        }
        return res;
    }

    public static String RelativePath(Hashtable env, String baseDir, String path) {
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        path = path.replace(';', File.pathSeparatorChar);
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        StringBuffer result = new StringBuffer(path.length() * 2);
        int n = 0;
        while (n < v.size()) {
            if (n == v.size() - 1) {
                result.append(NCFileUtilities.RelativeFile(env, baseDir, v.elementAt(n).toString()));
            } else {
                result.append(NCFileUtilities.RelativeFile(env, baseDir, v.elementAt(n).toString()) + File.pathSeparator);
            }
            ++n;
        }
        return result.toString();
    }

    public static String InsertEnv(Hashtable tab, String file2) {
        Enumeration en = tab.keys();
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            String val = (String)tab.get(s);
            if (val.length() <= 0 || !file2.startsWith(val) || file2.indexOf("($") >= val.length()) continue;
            return NCStringUtilities.Replace(file2, val, "($" + s + ")");
        }
        return file2;
    }

    public static String RelativeFile(Hashtable env, String baseDir, String file2) {
        int i;
        if (env != null) {
            file2 = NCFileUtilities.InsertEnv(env, file2);
        }
        if (file2.indexOf("($") >= 0) {
            return file2;
        }
        if (file2.indexOf("(_$") >= 0) {
            return file2;
        }
        file2 = VFile.StripDoubleSeps(file2, File.separatorChar).toString();
        Vector fiV = NCStringUtilities.SplitSeparatedString(File.separator, file2);
        baseDir = VFile.StripDoubleSeps(baseDir, File.separatorChar).toString();
        Vector baseV = NCStringUtilities.SplitSeparatedString(File.separator, baseDir);
        StringBuffer result = new StringBuffer("");
        int n = 0;
        while (n < Math.min(fiV.size(), baseV.size())) {
            if (!baseV.get(n).toString().equalsIgnoreCase(fiV.get(n).toString())) break;
            ++n;
        }
        if (n == 0) {
            return file2;
        }
        boolean resultStartIndex = false;
        if (n < baseV.size()) {
            i = n;
            while (i < baseV.size()) {
                result.append(".." + File.separator);
                ++i;
            }
        }
        i = n;
        while (i < fiV.size()) {
            if (result.length() == 0) {
                result.append("." + File.separator);
            }
            result.append(fiV.get(i));
            if (i < fiV.size() - 1) {
                result.append(File.separator);
            }
            ++i;
        }
        if (result.length() == 0) {
            return ".";
        }
        return result.toString();
    }

    public static String DerelativeDir(String baseDir, String fileOrDir) {
        if (fileOrDir == null) {
            fileOrDir = "";
        }
        if (fileOrDir.endsWith(File.pathSeparator)) {
            fileOrDir = fileOrDir.substring(0, fileOrDir.length() - 1);
        }
        if (fileOrDir.indexOf("($") >= 0) {
            return fileOrDir;
        }
        if (fileOrDir.indexOf("(_$") >= 0) {
            return fileOrDir;
        }
        fileOrDir = fileOrDir.replace('/', File.separatorChar);
        fileOrDir = fileOrDir.replace('\\', File.separatorChar);
        File f = new File(baseDir + File.separator + fileOrDir);
        if (fileOrDir.startsWith(".") || fileOrDir.startsWith("..")) {
            try {
                return new File(baseDir, fileOrDir).getCanonicalPath();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (fileOrDir.indexOf(".") >= 0) {
            try {
                return new File(fileOrDir).getCanonicalPath();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return fileOrDir;
    }

    public static String DerelativePath(String baseDir, String path) {
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        path = path.replace(';', File.pathSeparatorChar);
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        StringBuffer result = new StringBuffer(path.length() * 2);
        int n = 0;
        while (n < v.size()) {
            result.append(NCFileUtilities.DerelativeDir(baseDir, v.elementAt(n).toString()) + File.pathSeparator);
            ++n;
        }
        String resultString = result.toString();
        if (resultString.endsWith(File.pathSeparator)) {
            resultString = resultString.substring(0, resultString.length() - 1);
        }
        return resultString;
    }

    public static boolean DelRecursive(File target) throws Exception {
        Vector v = DirIterator.DirContent(target, "");
        int lastSiz = 0;
        do {
            lastSiz = v.size();
            int i = 0;
            while (i < v.size()) {
                File f = (File)v.get(i);
                if (f.delete()) {
                    v.remove(i);
                    --i;
                }
                ++i;
            }
        } while (v.size() != lastSiz);
        return v.size() == 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(0);
    }
}

