/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicIconFactory;
import jazzware.freestyle.JWUtil;

public class NCGraphicUtilities {
    public static Polygon rectangle(int h) {
        int[] x = new int[]{0, 100, 100, 0};
        int[] y = new int[]{-h, -h, h, h};
        return new Polygon(x, y, 4);
    }

    public static Polygon arrowLeft() {
        int[] x = new int[]{0, 100, 100, 0};
        int[] y = new int[]{0, 50, -50, 0};
        return new Polygon(x, y, 4);
    }

    public static Polygon arrowRight() {
        int[] x = new int[]{0, 0, 100, 0};
        int[] y = new int[]{50, -50, 0, 50};
        return new Polygon(x, y, 4);
    }

    public static void adjustScreenPos(Rectangle rect, Component comp) {
        Point p = comp.getLocationOnScreen();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.x + rect.x + rect.width > d.width) {
            rect.x -= p.x + rect.x + rect.width - d.width;
        }
        if (p.y + rect.y + rect.height > d.height) {
            rect.y -= p.y + rect.y + rect.height - d.height;
        }
    }

    public static Image computeKippedItem(Icon img, String s, Font f, Color bg, Component c) {
        AffineTransform trans = AffineTransform.getRotateInstance(-1.5707963267948966);
        Font kippF = f.deriveFont(trans);
        FontMetrics fm = c.getFontMetrics(f);
        int sw = fm.stringWidth(s);
        int h = fm.getHeight();
        int asc = fm.getMaxAscent();
        Image target = JWUtil.createImage(2 + Math.max(img.getIconWidth(), h) + 2, 2 + img.getIconHeight() + 2 + sw + 2);
        Graphics g = target.getGraphics();
        g.setColor(bg);
        g.fillRect(0, 0, 4000, 4000);
        g.setColor(c.getForeground());
        g.setFont(kippF);
        img.paintIcon(c, g, 2, target.getHeight(c) - 2 - img.getIconHeight());
        g.drawString(s, 2 + img.getIconHeight(), target.getHeight(c) - 2 - img.getIconHeight());
        g.dispose();
        return target;
    }

    public static boolean IsInFocusPath(JComponent comp) {
        Window w = (Window)comp.getTopLevelAncestor();
        Component c = w.getFocusOwner();
        while (c != null) {
            if (c == comp) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JLabel lab = new JLabel();
        f.getContentPane().add(lab);
        f.show();
        lab.setIcon(new ImageIcon(NCGraphicUtilities.computeKippedItem(BasicIconFactory.getMenuArrowIcon(), "Hallo trulli", new Font("SansSerif", 0, 14), Color.gray, lab)));
        f.pack();
    }
}

