/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.dtd;

import de.netcomputing.util.dtd.DTD;
import de.netcomputing.util.dtd.DTDAny;
import de.netcomputing.util.dtd.DTDAttribute;
import de.netcomputing.util.dtd.DTDCardinal;
import de.netcomputing.util.dtd.DTDChoice;
import de.netcomputing.util.dtd.DTDElement;
import de.netcomputing.util.dtd.DTDEmpty;
import de.netcomputing.util.dtd.DTDEntity;
import de.netcomputing.util.dtd.DTDEnumeration;
import de.netcomputing.util.dtd.DTDItem;
import de.netcomputing.util.dtd.DTDMixed;
import de.netcomputing.util.dtd.DTDName;
import de.netcomputing.util.dtd.DTDNotation;
import de.netcomputing.util.dtd.DTDNotationList;
import de.netcomputing.util.dtd.DTDPCData;
import de.netcomputing.util.dtd.DTDParser;
import de.netcomputing.util.dtd.DTDPublic;
import de.netcomputing.util.dtd.DTDSequence;
import de.netcomputing.util.dtd.DTDSystem;
import java.io.File;
import java.util.Enumeration;

class Tokenize {
    Tokenize() {
    }

    public static void main(String[] args) {
        try {
            DTDPublic pub;
            DTDParser parser = new DTDParser(new File(args[0]), true);
            DTD dtd = parser.parse(true);
            if (dtd.rootElement != null) {
                System.out.println("Root element is probably: " + dtd.rootElement.name);
            }
            Enumeration e = dtd.elements.elements();
            while (e.hasMoreElements()) {
                DTDElement elem = (DTDElement)e.nextElement();
                System.out.println("Element: " + elem.name);
                System.out.print("   Content: ");
                Tokenize.dumpDTDItem(elem.content);
                System.out.println();
                if (elem.attributes.size() <= 0) continue;
                System.out.println("   Attributes: ");
                Enumeration attrs = elem.attributes.elements();
                while (attrs.hasMoreElements()) {
                    System.out.print("        ");
                    DTDAttribute attr = (DTDAttribute)attrs.nextElement();
                    Tokenize.dumpAttribute(attr);
                }
                System.out.println();
            }
            e = dtd.entities.elements();
            while (e.hasMoreElements()) {
                DTDEntity entity = (DTDEntity)e.nextElement();
                if (entity.isParsed) {
                    System.out.print("Parsed ");
                }
                System.out.println("Entity: " + entity.name);
                if (entity.value != null) {
                    System.out.println("    Value: " + entity.value);
                }
                if (entity.externalID != null) {
                    if (entity.externalID instanceof DTDSystem) {
                        System.out.println("    System: " + entity.externalID.system);
                    } else {
                        pub = (DTDPublic)entity.externalID;
                        System.out.println("    Public: " + pub.pub + " " + pub.system);
                    }
                }
                if (entity.ndata == null) continue;
                System.out.println("    NDATA " + entity.ndata);
            }
            e = dtd.notations.elements();
            while (e.hasMoreElements()) {
                DTDNotation notation = (DTDNotation)e.nextElement();
                System.out.println("Notation: " + notation.name);
                if (notation.externalID == null) continue;
                if (notation.externalID instanceof DTDSystem) {
                    System.out.println("    System: " + notation.externalID.system);
                    continue;
                }
                pub = (DTDPublic)notation.externalID;
                System.out.print("    Public: " + pub.pub + " ");
                if (pub.system != null) {
                    System.out.println(pub.system);
                    continue;
                }
                System.out.println();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }

    public static void dumpDTDItem(DTDItem item) {
        if (item == null) {
            return;
        }
        if (item instanceof DTDAny) {
            System.out.print("Any");
        } else if (item instanceof DTDEmpty) {
            System.out.print("Empty");
        } else if (item instanceof DTDName) {
            System.out.print(((DTDName)item).value);
        } else if (item instanceof DTDChoice) {
            System.out.print("(");
            DTDItem[] items = ((DTDChoice)item).getItems();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    System.out.print("|");
                }
                Tokenize.dumpDTDItem(items[i]);
                ++i;
            }
            System.out.print(")");
        } else if (item instanceof DTDSequence) {
            System.out.print("(");
            DTDItem[] items = ((DTDSequence)item).getItems();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    System.out.print(",");
                }
                Tokenize.dumpDTDItem(items[i]);
                ++i;
            }
            System.out.print(")");
        } else if (item instanceof DTDMixed) {
            System.out.print("(");
            DTDItem[] items = ((DTDMixed)item).getItems();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    System.out.print(",");
                }
                Tokenize.dumpDTDItem(items[i]);
                ++i;
            }
            System.out.print(")");
        } else if (item instanceof DTDPCData) {
            System.out.print("#PCDATA");
        }
        if (item.cardinal == DTDCardinal.OPTIONAL) {
            System.out.print("?");
        } else if (item.cardinal == DTDCardinal.ZEROMANY) {
            System.out.print("*");
        } else if (item.cardinal == DTDCardinal.ONEMANY) {
            System.out.print("+");
        }
    }

    public static void dumpAttribute(DTDAttribute attr) {
        System.out.print(attr.name + " ");
        if (attr.type instanceof String) {
            System.out.print(attr.type);
        } else if (attr.type instanceof DTDEnumeration) {
            System.out.print("(");
            String[] items = ((DTDEnumeration)attr.type).getItems();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(items[i]);
                ++i;
            }
            System.out.print(")");
        } else if (attr.type instanceof DTDNotationList) {
            System.out.print("Notation (");
            String[] items = ((DTDNotationList)attr.type).getItems();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(items[i]);
                ++i;
            }
            System.out.print(")");
        }
        if (attr.decl != null) {
            System.out.print(" " + attr.decl.name);
        }
        if (attr.defaultValue != null) {
            System.out.print(" " + attr.defaultValue);
        }
        System.out.println();
    }
}

