/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.filecache;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;

public class FileCache {
    static int MAX_FILE_SIZE = 200000;
    public static int MAX_FULL_SIZE = 3000000;
    static FileCache This;
    HashMap files;
    HashMap times;
    long allSize;

    public static FileCache This() {
        if (This == null) {
            This = new FileCache();
        }
        return This;
    }

    public FileCache() {
        This = this;
        this.files = new HashMap(500);
        this.times = new HashMap(500);
    }

    public synchronized byte[] getFileBytes(File f) throws Exception {
        while (this.allSize > (long)MAX_FULL_SIZE) {
            Iterator it = this.times.keySet().iterator();
            if (it.hasNext()) {
                String next = (String)it.next();
                this.times.remove(next);
                byte[] b = (byte[])this.files.remove(next);
                this.allSize -= (long)b.length;
                continue;
            }
            this.times.clear();
            this.files.clear();
            this.allSize = 0L;
            break;
        }
        long tim = f.lastModified();
        Long lastTim = (Long)this.times.get(f.getAbsolutePath());
        if (lastTim == null || lastTim != tim) {
            byte[] b = new byte[(int)f.length()];
            FileInputStream fin = new FileInputStream(f);
            fin.read(b);
            fin.close();
            if (b.length > MAX_FILE_SIZE) {
                return b;
            }
            this.allSize += f.length();
            this.files.put(f.getAbsolutePath(), b);
            this.times.put(f.getAbsolutePath(), new Long(tim));
            return b;
        }
        return (byte[])this.files.get(f.getAbsolutePath());
    }
}

