/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import java.lang.reflect.Array;

public class ArrayUtil {
    protected Object[] array = null;
    protected Object[] added = null;
    protected Object[] removed = null;
    protected Object[] result = null;
    public Class clazz;

    public ArrayUtil(Class clazz, Object[] array) {
        if (clazz == null) {
            throw new IllegalArgumentException("null");
        }
        this.clazz = clazz;
        this.result = array;
        this.array = array;
    }

    public ArrayUtil(Object[] array) {
        this(array.getClass().getComponentType(), array);
    }

    public final Object[] getArray() {
        return this.array;
    }

    public final Object[] getResult() {
        return this.result;
    }

    public final Object[] getAdded() {
        return this.added;
    }

    public final Object[] getRemoved() {
        return this.removed;
    }

    public final Object[] getValidResult() {
        if (this.result == null) {
            return this.newArray(0);
        }
        return this.result;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public int indexOf(Object obj) {
        if (this.result == null || obj == null) {
            return -1;
        }
        int idx = 0;
        while (idx < this.result.length) {
            if (this.result[idx] == obj) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public ArrayUtil add(Object[] objs) {
        if (objs == null) {
            return this;
        }
        int idx = 0;
        while (idx < objs.length) {
            this.add(objs[idx]);
            ++idx;
        }
        return this;
    }

    public ArrayUtil add(Object obj) {
        if (obj == null) {
            return this;
        }
        if (this.result == null || this.result.length == 0) {
            this.added = this.newArray(1);
            this.result = this.added;
            this.result[0] = obj;
        } else if (!this.contains(obj)) {
            Object[] tmp = this.append(this.result, obj);
            if (this.result == this.added) {
                this.result = tmp;
                this.added = tmp;
            } else {
                this.result = tmp;
                this.added = this.append(this.added, obj);
            }
        }
        return this;
    }

    public ArrayUtil insertAt(Object obj, int idx) {
        if (obj == null) {
            return this;
        }
        if (this.result == null || this.result.length == 0) {
            this.added = this.newArray(1);
            this.result = this.added;
            this.result[idx] = obj;
        } else {
            Object[] tmp = this.insertAt(this.result, obj, idx);
            if (this.result == this.added) {
                this.added = tmp;
                this.result = tmp;
            } else {
                this.result = tmp;
                this.added = this.append(this.added, obj);
            }
        }
        return this;
    }

    public ArrayUtil remove(Object[] objs) {
        if (objs == null) {
            return this;
        }
        int idx = 0;
        while (idx < objs.length) {
            this.remove(objs[idx]);
            ++idx;
        }
        return this;
    }

    public ArrayUtil remove(Object obj) {
        if (obj == null || this.result == null) {
            return this;
        }
        int idx = this.indexOf(obj);
        if (idx >= 0) {
            this.result = this.removeAt(this.result, idx);
            this.removed = this.append(this.removed, obj);
        }
        return this;
    }

    public ArrayUtil removeAt(int idx) {
        if (this.result == null) {
            return this;
        }
        if (idx >= 0) {
            Object obj = this.result[idx];
            this.result = this.removeAt(this.result, idx);
            this.removed = this.append(this.removed, obj);
        }
        return this;
    }

    public ArrayUtil set(Object[] objs) {
        if (objs == null || objs.length == 0) {
            this.removed = this.append(this.removed, this.result);
            this.result = null;
            return this;
        }
        if (this.result == null) {
            this.added = this.append(this.added, objs);
            this.result = objs;
            return this;
        }
        int idx = 0;
        while (idx < objs.length) {
            if (!this.contains(objs[idx])) {
                this.added = this.append(this.added, objs[idx]);
            }
            ++idx;
        }
        Object[] old = this.result;
        this.result = objs;
        int idx2 = 0;
        while (idx2 < old.length) {
            if (!this.contains(old[idx2])) {
                this.removed = this.append(this.removed, old[idx2]);
            }
            ++idx2;
        }
        return this;
    }

    public Object[] append(Object[] src, Object obj) {
        Object[] tmp = null;
        if (src == null || src.length == 0) {
            tmp = this.newArray(1);
            tmp[0] = obj;
        } else {
            tmp = this.newArray(src.length + 1);
            System.arraycopy(src, 0, tmp, 0, src.length);
            tmp[src.length] = obj;
        }
        return tmp;
    }

    public Object[] append(Object[] src, Object[] objs) {
        if (src == null || src.length == 0) {
            return objs;
        }
        if (objs == null || objs.length == 0) {
            return src;
        }
        Object[] tmp = this.newArray(src.length + objs.length);
        System.arraycopy(src, 0, tmp, 0, src.length);
        System.arraycopy(objs, 0, tmp, src.length, objs.length);
        return tmp;
    }

    public Object[] insertAt(Object[] src, Object obj, int idx) {
        Object[] tmp = this.newArray(src.length + 1);
        if (idx > 0) {
            System.arraycopy(src, 0, tmp, 0, idx);
        }
        tmp[idx] = obj;
        if (idx < src.length) {
            System.arraycopy(src, idx, tmp, idx + 1, src.length - idx);
        }
        return tmp;
    }

    public Object[] removeAt(Object[] src, int idx) {
        Object[] tmp = this.newArray(src.length - 1);
        if (idx > 0) {
            System.arraycopy(src, 0, tmp, 0, idx);
        }
        if (idx < tmp.length) {
            System.arraycopy(src, idx + 1, tmp, idx, tmp.length - idx);
        }
        return tmp;
    }

    public Object[] newArray(int length) {
        return ArrayUtil.newArray(this.clazz, length);
    }

    public static Object[] newArray(Class clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }
}

