/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.Node;

public abstract class DataNodeConverter {
    protected static boolean strictMapping = false;
    protected static boolean normalizeMapping = true;
    protected static String contentName = "content";

    public boolean normalizesMapping() {
        return normalizeMapping;
    }

    public boolean usesStrictMapping() {
        return strictMapping;
    }

    public String getContentName() {
        return contentName;
    }

    protected int getSubnodeCount(DataNode node, String tagname) {
        if (node instanceof Node) {
            return ((Node)node).getSubnodeCount(tagname);
        }
        int cnt = 0;
        int idx = node.getSubnodeCount();
        while (--idx >= 0) {
            DataNode subnode = node.getSubnode(idx);
            String name = subnode.getName();
            if (name == null || !name.equals(tagname)) continue;
            ++cnt;
        }
        return cnt;
    }

    public DataNode getSubnode(DataNode node, String tagname) {
        if (node instanceof Node) {
            return ((Node)node).getSubnode(tagname);
        }
        int cnt = node.getSubnodeCount();
        int idx = 0;
        while (idx < cnt) {
            DataNode subnode = node.getSubnode(idx);
            String name = subnode.getName();
            if (name != null && name.equals(tagname)) {
                return subnode;
            }
            ++idx;
        }
        return null;
    }

    protected String getPath(DataNode node, String name) {
        if (name == null) {
            name = node.getName();
            node = node.getParent();
        }
        while (node != null) {
            name = node.getName() + "." + name;
            node = node.getParent();
        }
        return name;
    }
}

