/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.Array;
import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.Hashtable;
import de.netcomputing.util.xml.MathUtil;
import de.netcomputing.util.xml.SortedStringSet;
import de.netcomputing.util.xml.XMLIterator;
import java.io.PrintStream;
import java.io.Serializable;

public class Node
implements DataNode,
Serializable {
    public static final char DEFAULT_SEPERATOR = '.';
    protected String name;
    protected Hashtable attributes;
    protected Array subnodes;
    protected DataNode parent;
    protected int line;
    protected int col;

    public Node() {
    }

    public Node(String name) {
        this(null, name);
    }

    public Node(DataNode parent) {
        this(parent, null);
    }

    public Node(DataNode parent, String name) {
        this.setName(name);
        this.setParent(parent);
    }

    public Node(DataNode parent, String name, String value) {
        this(parent, name);
        this.putField("", value);
    }

    public Node(DataNode parent, String name, int value) {
        this(parent, name);
        this.putField("", value);
    }

    public Node(DataNode parent, String name, double value) {
        this(parent, name);
        this.putField("", value);
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    public Node(DataNode parent, String name, boolean value) {
        this(parent, name);
        this.putField("", value);
    }

    public DataNode createSubnode(String name) {
        return new Node(this, name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getField(String name) {
        return this.getField(name, null);
    }

    public String getField(String name, String def) {
        return this.getField(name, '.', def);
    }

    /*
     * WARNING - void declaration
     */
    public String getField(String path, char seperator, String def) {
        if (path.length() > 0 && path.charAt(0) == '<' && this.parent instanceof Node) {
            return ((Node)this.parent).getField(path.substring(1), seperator, def);
        }
        int offs = path.indexOf(seperator);
        String name = offs < 0 ? path : path.substring(0, offs);
        String value = null;
        if (offs >= 0) {
            DataNode sub;
            String tail = path.substring(offs + 1);
            int idx = 0;
            while (value == null && (sub = this.getSubnode(name, idx)) != null) {
                void var7_9;
                value = ((Node)var7_9).getField(tail, seperator, null);
                ++idx;
            }
        } else {
            DataNode sub;
            if (this.attributes != null) {
                value = (String)this.attributes.get(name);
            }
            if (value == null && (sub = this.getSubnode(name)) != null) {
                value = sub.getField("");
            }
        }
        return value != null ? value : def;
    }

    public Node getNodeByPath(String path) {
        return this.getNodeByPath(path, '.');
    }

    public Node getNodeByPath(String path, char seperator) {
        if (path.length() == 0) {
            return this;
        }
        int offs = path.indexOf(seperator);
        String name = offs < 0 ? path : path.substring(0, offs);
        String tail = offs < 0 ? "" : path.substring(offs + 1);
        Node result = (Node)this.getSubnode(name);
        if (result == null) {
            return null;
        }
        return result.getNodeByPath(tail, seperator);
    }

    public int getIntField(String name) {
        return this.getIntField(name, 0);
    }

    public int getIntField(String name, int def) {
        String value = this.getField(name);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public double getDoubleField(String name) {
        return this.getDoubleField(name, 0.0);
    }

    public double getDoubleField(String name, double def) {
        String value = this.getField(name);
        if (value == null) {
            return def;
        }
        return MathUtil.doubleValueOf(value);
    }

    public boolean getBooleanField(String name) {
        return this.getBooleanField(name, false);
    }

    public boolean getBooleanField(String name, boolean def) {
        String value = this.getField(name);
        if (value == null) {
            return def;
        }
        return MathUtil.booleanValueOf(value);
    }

    protected void putFieldInternal(String name, String value) {
        if (name.equals("content")) {
            Node n = (Node)this.getSubnode("content");
            if (n == null) {
                n = (Node)this.createSubnode("content");
            }
            n.putField("", value);
        } else {
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            if (value == null) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        }
    }

    public void putField(String name, String value) {
        this.putField(name, value, '.');
    }

    public void putField(String path, String value, char seperator) {
        String name;
        if (path.length() > 0 && path.charAt(0) == '<') {
            throw new IllegalArgumentException("fieldname \"" + path + "\"");
        }
        int offs = path.indexOf(seperator);
        String string = name = offs < 0 ? path : path.substring(0, offs);
        if (offs >= 0) {
            DataNode sub = this.getSubnode(name);
            if (sub == null) {
                if (value == null) {
                    return;
                }
                sub = this.createSubnode(name);
            }
            name = path.substring(offs + 1);
            if (sub instanceof Node) {
                ((Node)sub).putField(name, value, seperator);
            } else {
                sub.putField(name, value);
            }
        } else {
            this.putFieldInternal(name, value);
        }
    }

    public void putField(String name, int value) {
        this.putField(name, MathUtil.stringValueOf(value));
    }

    public void putField(String name, double value) {
        this.putField(name, MathUtil.stringValueOf(value));
    }

    public void putField(String name, boolean value) {
        this.putField(name, String.valueOf(value));
    }

    public boolean hasAttribute(String name) {
        return this.attributes != null ? this.attributes.containsKey(name) : false;
    }

    public int getAttributeCount() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    public XMLIterator getAttributeNames() {
        if (this.attributes == null) {
            return XMLIterator.empty;
        }
        return this.attributes.keys();
    }

    public int getFieldCount() {
        return ((SortedStringSet)this.getFieldNames()).size();
    }

    public XMLIterator getFieldNames() {
        SortedStringSet set = new SortedStringSet();
        if (this.attributes != null) {
            XMLIterator iter = this.attributes.keys();
            while (iter.hasMoreElements()) {
                String str = (String)iter.nextElement();
                if (str.length() <= 0) continue;
                set.put(str);
            }
        }
        if (this.subnodes != null) {
            int idx = 0;
            while (idx < this.subnodes.size()) {
                DataNode node = (DataNode)this.subnodes.get(idx);
                if (node.getField("") != null) {
                    set.put(node.getName());
                }
                String prefix = node.getName() + ".";
                set.putAll(prefix, node.getFieldNames());
                ++idx;
            }
        }
        return set;
    }

    public XMLIterator getSubnodes() {
        if (this.subnodes == null) {
            return XMLIterator.empty;
        }
        return this.subnodes.elements();
    }

    public XMLIterator getSubnodes(String tagname) {
        if (this.subnodes == null) {
            return XMLIterator.empty;
        }
        Array result = new Array();
        int idx = 0;
        while (idx < this.subnodes.size()) {
            DataNode node = (DataNode)this.subnodes.get(idx);
            String name = node.getName();
            if (name != null && name.equals(tagname)) {
                result.add(node);
            }
            ++idx;
        }
        return result.elements();
    }

    public int getSubnodeCount(String tagname) {
        if (this.subnodes == null) {
            return 0;
        }
        int cnt = 0;
        int idx = 0;
        while (idx < this.subnodes.size()) {
            DataNode node = (DataNode)this.subnodes.get(idx);
            String name = node.getName();
            if (name != null && name.equals(tagname)) {
                ++cnt;
            }
            ++idx;
        }
        return cnt;
    }

    public int getSubnodeCount() {
        return this.subnodes != null ? this.subnodes.size() : 0;
    }

    public DataNode getSubnode(int index) {
        if (this.subnodes == null) {
            return null;
        }
        return (DataNode)this.subnodes.get(index);
    }

    public DataNode getSubnode(String tagname) {
        if (this.subnodes == null) {
            return null;
        }
        int idx = 0;
        while (idx < this.subnodes.size()) {
            DataNode node = (DataNode)this.subnodes.get(idx);
            String name = node.getName();
            if (name != null && name.equals(tagname)) {
                return node;
            }
            ++idx;
        }
        return null;
    }

    public DataNode getSubnode(String tagname, int index) {
        if (this.subnodes == null) {
            return null;
        }
        int cnt = 0;
        int idx = 0;
        while (idx < this.subnodes.size()) {
            DataNode node = (DataNode)this.subnodes.get(idx);
            String name = node.getName();
            if (name != null && name.equals(tagname) && cnt++ == index) {
                return node;
            }
            ++idx;
        }
        return null;
    }

    public DataNode getParent() {
        return this.parent;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.getName();
        }
        return this.parent.getPath() + "." + this.getName();
    }

    public void setParent(DataNode node) {
        if (node == this.parent) {
            return;
        }
        DataNode tmp = this.parent;
        this.parent = node;
        if (tmp != null) {
            tmp.removeSubnode(this);
        }
        if (this.parent != null && this.parent.indexOfSubnode(this) < 0) {
            this.parent.addSubnode(this);
        }
    }

    public void setParentPure(DataNode node) {
        this.parent = node;
    }

    public DataNode getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public void addSubnode(DataNode node) {
        if (this.subnodes == null) {
            this.subnodes = new Array();
        } else {
            this.subnodes.remove(node);
        }
        this.subnodes.add(node);
        node.setParent(this);
    }

    public void addSubnode(int index, DataNode node) {
        if (this.subnodes == null) {
            this.subnodes = new Array();
        } else {
            this.subnodes.remove(node);
        }
        if (index > this.subnodes.size()) {
            index = this.subnodes.size();
        }
        this.subnodes.insert(node, index);
        node.setParent(this);
    }

    public void addSubnode(String tagname, String value) {
        DataNode sub = this.createSubnode(tagname);
        sub.putField("", value);
        this.addSubnode(sub);
    }

    public void addSubnode(String tagname, int value) {
        DataNode sub = this.createSubnode(tagname);
        sub.putField("", MathUtil.stringValueOf(value));
        this.addSubnode(sub);
    }

    public void addSubnode(String tagname, double value) {
        DataNode sub = this.createSubnode(tagname);
        sub.putField("", MathUtil.stringValueOf(value));
        this.addSubnode(sub);
    }

    public void addSubnode(String tagname, boolean value) {
        DataNode sub = this.createSubnode(tagname);
        sub.putField("", String.valueOf(value));
        this.addSubnode(sub);
    }

    public void removeSubnode(DataNode node) {
        if (this.subnodes == null) {
            return;
        }
        if (this.subnodes.remove(node)) {
            node.setParent(null);
        }
    }

    public void finished() {
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeSubnode(this);
        }
    }

    public int indexOfSubnode(DataNode node) {
        int idx = this.getSubnodeCount() - 1;
        while (--idx >= 0) {
            if (this.subnodes.get(idx) != node) continue;
            return idx;
        }
        return -1;
    }

    public Node findElement(String name) {
        return this.findElement(name, null, null);
    }

    public Node findElement(String elname, String fname, String content) {
        int idx = 0;
        while (idx < this.getSubnodeCount()) {
            if (this.getSubnode(idx).getName().equals(this.name)) {
                return this.checkField((Node)this.getSubnode(idx), fname, content);
            }
            ++idx;
        }
        int idx2 = 0;
        while (idx2 < this.getSubnodeCount()) {
            Node node = (Node)this.getSubnode(idx2);
            if ((node = node.findElement(this.name)) != null) {
                return node;
            }
            ++idx2;
        }
        return null;
    }

    private Node checkField(Node node, String fname, String content) {
        if (fname == null) {
            return node;
        }
        if (content == null) {
            return node.getField(fname) != null ? node : null;
        }
        return node.getField(fname).equals(content) ? node : null;
    }

    public String toString() {
        return "<" + this.getName() + ">";
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        this.dump(out, 0);
    }

    protected void dumpLine(String str, PrintStream out, int indent) {
        int idx = 0;
        while (idx < indent) {
            out.print(' ');
            ++idx;
        }
        out.println(str);
    }

    public void dump(PrintStream out, int indent) {
        String str = "(" + this.getName();
        String def = this.getField("", null);
        if (def != null) {
            str = str + "=" + def;
        }
        if (this.getAttributeCount() - (def != null ? 1 : 0) + this.getSubnodeCount() == 0) {
            this.dumpLine(str + ")", out, indent);
            return;
        }
        this.dumpLine(str, out, indent);
        indent += 4;
        XMLIterator iter = this.getAttributeNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            if (name.length() <= 0) continue;
            this.dumpLine(name + "=" + this.getField(name), out, indent);
        }
        int idx = 0;
        while (idx < this.getSubnodeCount()) {
            DataNode node = this.getSubnode(idx);
            if (node instanceof Node) {
                ((Node)node).dump(out, indent);
            } else {
                this.dumpLine("(" + node + ")", out, indent);
            }
            ++idx;
        }
        this.dumpLine(")", out, indent - 4);
    }
}

