/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.DataSet;
import de.netcomputing.util.xml.Hashtable;
import de.netcomputing.util.xml.Log;
import de.netcomputing.util.xml.MathUtil;
import de.netcomputing.util.xml.XMLIterator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyManager
implements DataSet {
    protected Hashtable tab = new Hashtable();
    protected Hashtable proc = new Hashtable();
    protected Hashtable unknown = new Hashtable();
    protected Log log = null;

    public PropertyManager() {
    }

    public PropertyManager(Log log) {
        this.setLog(log);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        return this.log;
    }

    public String getField(String name) {
        return this.getProperty(name);
    }

    public void putField(String name, String value) {
        this.setProperty(name, value);
    }

    public int getFieldCount() {
        return this.tab.size();
    }

    public XMLIterator getFieldNames() {
        return this.getKeys();
    }

    public XMLIterator getKeys() {
        return this.tab.keys();
    }

    protected void info(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    public void readProperties(String propsFile) {
        try {
            if (new File(propsFile).exists()) {
                FileInputStream in = new FileInputStream(propsFile);
                int ch = 32;
                int state = 0;
                StringBuffer buf = new StringBuffer();
                String key = null;
                String val = null;
                do {
                    switch (ch) {
                        case 10: {
                            if (state == 3) {
                                val = buf.toString();
                                this.tab.put(key.toLowerCase(), val.trim());
                            }
                            buf.setLength(0);
                            state = 0;
                            ch = in.read();
                            break;
                        }
                        case 9: 
                        case 13: 
                        case 32: {
                            if (state > 2) {
                                buf.append((char)ch);
                            }
                            ch = in.read();
                            break;
                        }
                        case 33: 
                        case 35: {
                            while ((ch = in.read()) != 10) {
                            }
                            break;
                        }
                        case 61: {
                            if (state == 1) {
                                key = buf.toString();
                                buf.setLength(0);
                                state = 2;
                            }
                            ch = in.read();
                            break;
                        }
                        default: {
                            if ((state & 1) == 0) {
                                ++state;
                            }
                            buf.append((char)ch);
                            ch = in.read();
                        }
                    }
                } while (in.available() != 0);
                if (state == 2) {
                    val = buf.toString();
                    this.tab.put(key.toLowerCase(), val.trim());
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("properties file \"" + new File(propsFile).getAbsolutePath() + "\" not accessible");
    }

    public String expandPropertyValue(String value) {
        return this.expandProperty(null, value);
    }

    protected String expandProperty(String key, String val) {
        if (val == null && (val = this.tab.getField(key)) == null) {
            return val;
        }
        String oval = val;
        boolean dirty = false;
        int idx = 0;
        while ((idx = val.indexOf(36, idx)) >= 0) {
            String mkey;
            String mval;
            int end;
            if (val.length() <= idx + 1 || val.charAt(idx + 1) == '$') {
                idx += 2;
                continue;
            }
            int beg = idx + 1;
            int tail = end = idx + 2;
            if (val.charAt(beg) == '(') {
                if ((end = val.indexOf(41, ++beg)) < 0) {
                    end = val.length();
                }
                tail = end + 1;
            }
            if (end >= val.length()) {
                end = val.length();
            }
            if (tail >= val.length()) {
                tail = val.length();
            }
            if ((mval = this.getProperty(mkey = val.substring(beg, end).toLowerCase(), null)) == null) {
                dirty = true;
                mval = "$(" + mkey + ")";
            }
            val = val.substring(0, idx) + mval + val.substring(tail);
            idx += mval.length();
        }
        if (key != null && !dirty) {
            this.proc.put(key, val);
        }
        return val;
    }

    public DataSet toDataSet(Properties props) {
        Enumeration<?> enumeration = props.propertyNames();
        Hashtable htab = new Hashtable();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            htab.put(key.toLowerCase(), props.getProperty(key));
        }
        return htab;
    }

    public Properties getAsProperties() {
        return new Properties(){

            public Object get(Object key) {
                return this.getProperty((String)key);
            }

            public String getProperty(String key) {
                return PropertyManager.this.getProperty(key.toLowerCase());
            }

            public Enumeration propertyNames() {
                return PropertyManager.this.getKeys();
            }
        };
    }

    public void appendProperties(Properties props) {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            this.tab.put(key.toLowerCase(), val);
        }
    }

    public void setProperty(String key, String value) {
        this.tab.put(key.toLowerCase(), value);
    }

    public String getProperty(String key) {
        String str = (String)this.proc.get(key = key.toLowerCase());
        if (str == null) {
            str = this.expandProperty(key, null);
        }
        if (str == null && !this.unknown.containsKey(key)) {
            this.unknown.put(key, key);
            this.info("unsuccessfull property access: " + key);
        }
        return str;
    }

    public String getProperty(String key, String defaultValue) {
        String str = this.getProperty(key);
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public int getProperty(String key, int defaultValue) {
        String str = this.getProperty(key);
        if (str == null) {
            return defaultValue;
        }
        return (int)MathUtil.longValueOf(str);
    }

    public double getProperty(String key, double defaultValue) {
        String str = this.getProperty(key);
        if (str == null) {
            return defaultValue;
        }
        return MathUtil.doubleValueOf(str);
    }

    public String getSpecProperty(String key, String path) {
        int idx = key.indexOf(35);
        String start = key.substring(0, idx);
        String end = key.substring(idx + 1);
        String nkey = (start + path + end).toLowerCase();
        int pos = path.length() - 1;
        while (pos >= 0) {
            String str = this.getProperty(nkey);
            if (str != null) {
                return str;
            }
            String ckey = nkey;
            pos = path.lastIndexOf(46, pos - 1);
            nkey = (start + path.substring(0, pos + 1) + end).toLowerCase();
            this.info("unsuccessfull property access: " + ckey + ", using: " + nkey);
        }
        return this.getProperty(nkey);
    }

    public String getSpecProperty(String key, String path, String defaultValue) {
        String str = this.getSpecProperty(key, path);
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public int getSpecProperty(String key, String path, int defaultValue) {
        String str = this.getSpecProperty(key, path);
        if (str == null) {
            return defaultValue;
        }
        return (int)MathUtil.longValueOf(str);
    }

    public double getSpecProperty(String key, String path, double defaultValue) {
        String str = this.getSpecProperty(key, path);
        if (str == null) {
            return defaultValue;
        }
        return MathUtil.doubleValueOf(str);
    }
}

