/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

public class StringSearch {
    public static boolean matches(String str, String pattern) {
        if (str == null) {
            return false;
        }
        return StringSearch.matchesInternal(str.toCharArray(), 0, pattern.toCharArray(), 0);
    }

    public static boolean matches(char[] str, String pattern) {
        if (str == null) {
            return false;
        }
        return StringSearch.matchesInternal(str, 0, pattern.toCharArray(), 0);
    }

    public static boolean matches(String str, char[] pattern) {
        if (str == null) {
            return false;
        }
        return StringSearch.matchesInternal(str.toCharArray(), 0, pattern, 0);
    }

    public static boolean matches(char[] str, char[] pattern) {
        if (str == null) {
            return false;
        }
        return StringSearch.matchesInternal(str, 0, pattern, 0);
    }

    protected static boolean matchesInternal(char[] str, int soffset, char[] pattern, int poffset) {
        if (str == null) {
            return false;
        }
        int idx = StringSearch.getSubPatternIdx(pattern, poffset);
        int len = idx - poffset;
        if (StringSearch.matchRegion(str, soffset, pattern, poffset, len)) {
            if (idx < pattern.length) {
                int max;
                int min;
                switch (pattern[idx]) {
                    case '*': {
                        min = 0;
                        max = str.length - soffset - 1;
                        break;
                    }
                    case '?': {
                        min = 0;
                        max = 1;
                        break;
                    }
                    default: {
                        min = 0;
                        max = 0;
                    }
                }
                int i = min;
                while (i <= max) {
                    if (StringSearch.matchesInternal(str, soffset + len + i, pattern, poffset + len + 1)) {
                        return true;
                    }
                    ++i;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected static final int getSubPatternIdx(char[] str, int offset) {
        int i = offset;
        while (i < str.length) {
            if (str[i] == '*' || str[i] == '?') {
                return i;
            }
            ++i;
        }
        return str.length;
    }

    protected static final boolean matchRegion(char[] str1, int str1offset, char[] str2, int str2offset, int len) {
        if (str1offset < 0 || str2offset < 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            int n1 = str1offset + i;
            int n2 = str2offset + i;
            if (n1 >= str1.length) {
                return false;
            }
            if (n2 >= str2.length) {
                return false;
            }
            if (str1[n1] != str2[n2]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

