/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.DataNodeConverter;
import de.netcomputing.util.xml.DataNodeWriter;
import de.netcomputing.util.xml.Hashtable;
import de.netcomputing.util.xml.XMLIterator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class XmlWriter
extends DataNodeConverter
implements DataNodeWriter {
    protected String indentString = "    ";

    public void write(OutputStream out, DataNode root) {
        this.write(out, root, null);
    }

    public void setIndentString(String str) {
        this.indentString = str;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public String write(DataNode root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out, root, null);
        return out.toString(0);
    }

    public static String writeToString(DataNode root) {
        return new XmlWriter().write(root);
    }

    public static void writeToStream(OutputStream out, DataNode root) {
        new XmlWriter().write(out, root);
    }

    public void write(OutputStream out, DataNode root, String extdtd) {
        PrintStream pout = new PrintStream(out);
        pout.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        String type = root.getName();
        if (extdtd == null) {
            pout.println("<!DOCTYPE " + type + ">");
        } else {
            pout.println("<!DOCTYPE " + type + " SYSTEM \"" + extdtd + "\">");
        }
        this.writeNode(pout, root, 0);
    }

    public void writeNoHeader(OutputStream out, DataNode root) {
        this.writeNoHeader(out, root, null);
    }

    public String writeNoHeader(DataNode root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeNoHeader(out, root, null);
        return out.toString(0);
    }

    public static String writeNoHeaderToString(DataNode root) {
        return new XmlWriter().writeNoHeader(root);
    }

    public void writeNoHeader(OutputStream out, DataNode root, String extdtd) {
        PrintStream pout = new PrintStream(out);
        this.writeNode(pout, root, 0);
    }

    public static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = null;
        int pos = 0;
        int idx = 0;
        while (idx < str.length()) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(str.substring(pos, idx));
                    buf.append("&#" + ch + ';');
                    pos = idx + 1;
                }
            }
            ++idx;
        }
        if (buf == null) {
            return str;
        }
        buf.append(str.substring(pos));
        return buf.toString();
    }

    public static String quoteString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = null;
        int pos = 0;
        char quotChar = str.indexOf(34) >= 0 ? (char)'\'' : '\"';
        int idx = 0;
        while (idx < str.length()) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (buf == null) {
                        buf = new StringBuffer();
                        buf.append(quotChar);
                    }
                    buf.append(str.substring(pos, idx));
                    buf.append("&#" + ch + ';');
                    pos = idx + 1;
                }
            }
            ++idx;
        }
        if (buf == null) {
            return quotChar + str + quotChar;
        }
        buf.append(str.substring(pos));
        buf.append(quotChar);
        return buf.toString();
    }

    protected boolean isContentNode(DataNode node) {
        return node.getName().equals(this.getContentName()) && node.getAttributeCount() == 1 && node.getSubnodeCount() == 0;
    }

    protected void printAttribute(PrintStream pout, String name, String value) {
        pout.print(" " + name + "=" + XmlWriter.quoteString(value));
    }

    protected void writeNode(PrintStream pout, DataNode node, int indent) {
        boolean singlecontent;
        int idx = 0;
        while (idx < indent) {
            pout.print(this.indentString);
            ++idx;
        }
        pout.print("<" + node.getName());
        XMLIterator attributes = node.getAttributeNames();
        Hashtable set = new Hashtable();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String value = node.getField(attribute);
            if (attribute.length() == 0) {
                DataNode parent = node.getParent();
                if (parent != null && this.getSubnodeCount(parent, node.getName()) < 2) continue;
                if (this.usesStrictMapping()) {
                    throw new RuntimeException("multiple default values: " + this.getPath(node, null));
                }
                attribute = "default";
            }
            set.put(attribute, "");
            if (value == null) continue;
            this.printAttribute(pout, attribute, value);
        }
        int count = node.getSubnodeCount();
        int rpos = 0;
        DataNode[] realNodes = new DataNode[count];
        int idx2 = 0;
        while (idx2 < count) {
            DataNode subnode = node.getSubnode(idx2);
            if (!set.containsKey(subnode.getName()) || node.hasAttribute(subnode.getName())) {
                String value = subnode.getField("");
                if (value != null && this.getSubnodeCount(node, subnode.getName()) == 1 && !subnode.getName().equals(this.getContentName())) {
                    set.put(subnode.getName(), "");
                    this.printAttribute(pout, subnode.getName(), XmlWriter.quoteString(value));
                    if (subnode.getSubnodeCount() + subnode.getAttributeCount() > 1) {
                        realNodes[rpos++] = subnode;
                    }
                } else {
                    realNodes[rpos++] = subnode;
                }
            }
            ++idx2;
        }
        boolean bl = singlecontent = rpos == 1 && this.isContentNode(realNodes[0]);
        if (rpos == 0) {
            pout.print("/>");
            if (!singlecontent) {
                pout.println();
            }
        } else {
            pout.print(">");
            if (!singlecontent) {
                pout.println();
            }
            int idx3 = 0;
            while (idx3 < rpos) {
                DataNode subnode = realNodes[idx3];
                if (this.isContentNode(subnode)) {
                    pout.print(XmlWriter.escapeString(subnode.getField("")));
                    if (!singlecontent) {
                        pout.println();
                    }
                } else {
                    this.writeNode(pout, subnode, indent + 1);
                }
                ++idx3;
            }
            if (!singlecontent) {
                int idx4 = 0;
                while (idx4 < indent) {
                    pout.print(this.indentString);
                    ++idx4;
                }
            }
            pout.println("</" + node.getName() + ">");
        }
    }
}

