/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import de.netcomputing.util.Tracer;
import editapp.ClassDescription;
import editapp.FieldDescription;
import editapp.FileRegistry;
import editapp.MethodDescription;
import editapp.SourceBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import util.ClassFile;
import util.FieldInfo;
import util.MethodInfo;

public class ClassFileReader {
    ClassFile clF = null;

    public void scanFile(File f) {
        ByteArrayInputStream bin = null;
        SourceBase sb = SourceBase.This();
        try {
            byte[] b = new byte[(int)f.length()];
            FileInputStream fin = new FileInputStream(f);
            fin.read(b);
            fin.close();
            bin = new ByteArrayInputStream(b);
            this.scanFile(bin, f.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scanFile(InputStream fin, String filename) {
        try {
            SourceBase sb = SourceBase.This();
            this.clF = new ClassFile();
            this.clF.read(fin);
            ClassDescription cd = this.createClassDecl(this.clF, filename);
            FileRegistry.This.get(filename).setPackage(cd.packageName());
            if (cd.className.indexOf(36) > 0) {
                return;
            }
            if (cd.hasAnyModifiers(257)) {
                FieldDescription decl;
                int n;
                sb.add(cd);
                if (this.clF.fields != null) {
                    n = 0;
                    while (n < this.clF.fields.length) {
                        if (this.clF.fields[n] != null && (decl = this.createFieldDecl(this.clF.fields[n], cd.className, cd.pack, filename)).hasAnyModifiers(257)) {
                            sb.add(decl);
                        }
                        ++n;
                    }
                }
                if (this.clF.methods != null) {
                    n = 0;
                    while (n < this.clF.methods.length) {
                        if (this.clF.methods[n] != null && (decl = this.createMethodDecl(this.clF.methods[n], cd.className, cd.pack, filename)).hasAnyModifiers(257)) {
                            sb.add(decl);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    ClassDescription createClassDecl(ClassFile clF, String filename) {
        if (clF == null) {
            Tracer.This.println(" == null ");
        } else if (clF.thisClass == null) {
            Tracer.This.println("thisClass == null ");
        } else if (clF.thisClass.arg1 == null) {
            Tracer.This.println("thisClass.arg1 == null ");
        } else if (clF.thisClass.arg1.strValue == null) {
            Tracer.This.println("thisClass.arg1.strValue == null ");
        } else {
            Tracer.This.println(clF.thisClass.arg1.strValue);
        }
        ClassDescription decl = new ClassDescription();
        String[] claPack = new String[]{null, null};
        SourceBase.splitClass(clF.thisClass.arg1.strValue.replace('/', '.'), claPack);
        decl.pack = claPack[1];
        decl.className = claPack[0];
        decl.modifier = this.translateModifier(clF.accessFlags);
        decl.setDP(filename, 0, 0, 0, 0);
        if (clF.superClass == null || clF.superClass.arg1 == null) {
            decl.superClass = "java.lang.Object";
            Tracer.This.println("superClass == null ");
        } else {
            decl.superClass = clF.printClassName(clF.superClass.arg1.strValue);
        }
        boolean bl = decl.isInterface = (clF.accessFlags & 0x200) != 0;
        if (clF.interfaces != null) {
            Tracer.This.println("interfaces");
            int n = 0;
            while (n < clF.interfaces.length) {
                String interf = clF.printClassName(clF.interfaces[n].arg1.strValue);
                Tracer.This.println("   " + interf);
                interf = SourceBase.RemovePack(interf);
                decl.interf.add(interf);
                ++n;
            }
        }
        if (decl.pack == null || decl.pack.length() == 0) {
            String defPack = filename.substring(0, filename.lastIndexOf(File.separator));
            defPack = defPack.substring(defPack.lastIndexOf(File.separator), defPack.length());
        }
        return decl;
    }

    FieldDescription createFieldDecl(FieldInfo f, String definingClazz, String definingPack, String filename) {
        FieldDescription decl = new FieldDescription();
        String[] clpack = new String[]{null, null};
        SourceBase.splitClass(ClassFile.typeString(f.signature.toString(), ""), clpack);
        decl.pack = definingPack;
        decl.className = definingClazz;
        decl.modifier = this.translateModifier(f.accessFlags);
        decl.setDP(filename, 0, 0, 0, 0);
        decl.name = f.name.toString();
        decl.typeClass = clpack[0];
        decl.typePack = clpack[1];
        return decl;
    }

    MethodDescription createMethodDecl(MethodInfo f, String definingClazz, String definingPack, String filename) {
        MethodDescription decl = new MethodDescription();
        boolean isArray = false;
        boolean ndx = false;
        StringBuffer parameterList = new StringBuffer();
        char initialParameter = 'a';
        StringBuffer varName = new StringBuffer();
        if (f == null) {
            Tracer.This.println("f == null ");
        }
        if (f.signature == null) {
            Tracer.This.println("f.signature == null ");
        }
        String xyTmp = f.name.toString();
        String s = f.signature.strValue;
        String paramSig = s.substring(s.indexOf(40) + 1, s.indexOf(41));
        String returnSig = s.substring(s.indexOf(41) + 1);
        String[] clpack = new String[]{null, null};
        SourceBase.splitClass(ClassFile.typeString(returnSig, ""), clpack);
        decl.pack = definingPack;
        decl.className = definingClazz;
        decl.name = f.name.toString();
        decl.typeClass = clpack[0];
        decl.typePack = clpack[1];
        decl.modifier = this.translateModifier(f.accessFlags);
        decl.setDP(filename, 0, 0, 0, 0);
        if (decl.name.startsWith("<init>")) {
            decl.name = definingClazz;
        }
        if (paramSig.length() > 0 && paramSig.charAt(0) != 'V') {
            while (paramSig.length() > 0) {
                varName.setLength(0);
                varName.append(initialParameter);
                initialParameter = (char)(initialParameter + '\u0001');
                String cl = ClassFile.typeString(paramSig, " " + varName.toString());
                int tmp = cl.lastIndexOf(46);
                if (tmp >= 0) {
                    parameterList.append(cl.substring(tmp + 1));
                } else {
                    parameterList.append(cl);
                    parameterList.append(' ');
                }
                paramSig = ClassFile.nextSig(paramSig);
                if (paramSig.length() <= 0) continue;
                parameterList.append(", ");
            }
        }
        decl.argString = parameterList.toString();
        return decl;
    }

    String[] fieldNames() {
        if (this.clF.fields != null) {
            String[] res = new String[this.clF.fields.length];
            int n = 0;
            while (n < this.clF.fields.length) {
                res[n] = this.clF.fields[n].name.toString();
                ++n;
            }
            return res;
        }
        return new String[0];
    }

    int translateModifier(int i) {
        int result = 0;
        if ((i & 1) != 0) {
            result |= 1;
        }
        if ((i & 2) != 0) {
            result |= 2;
        }
        if ((i & 8) != 0) {
            result |= 0x80;
        }
        if ((i & 0x10) != 0) {
            result |= 4;
        }
        if ((i & 0x100) != 0) {
            result |= 8;
        }
        if ((i & 0x400) != 0) {
            result |= 0x40;
        }
        if ((i & 0x20) != 0) {
            result |= 0x20;
        }
        if ((i & 0x80) != 0) {
            result |= 0x10;
        }
        if ((i & 4) != 0) {
            result |= 0x100;
        }
        return result;
    }

    public static void main(String[] arg) {
        ClassFileReader clf = new ClassFileReader();
        clf.scanFile(new File("D:\\work\\anyj\\debugapi\\com\\sun\\jdi\\InterfaceType.class"));
        Tracer.This.println("");
    }
}

