/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.JSet;
import JCollections.JSortedArray;
import JWVFile.VFile;
import Jxe.DocumentStream;
import de.netcomputing.anyj.jwidgets.IDataItem;
import editapp.IndexEntry;
import java.io.File;
import java.util.Enumeration;
import netcomputing.collections.NCArray;

public class FileEntry
implements IDataItem {
    String fullPath;
    NCArray entries;
    long lastParsed;
    String packageName;
    static String[] emptyStringArr = new String[0];
    private String[] imports = emptyStringArr;

    public FileEntry() {
    }

    public Object dataObject() {
        return new File(this.fullPath);
    }

    FileEntry(String path) {
        this(path, 0);
    }

    FileEntry(String path, int initialSiz) {
        this.fullPath = path;
        this.entries = new NCArray(initialSiz);
        this.lastParsed = 0L;
    }

    FileEntry(String path, long _lastParsed) {
        this.fullPath = path;
        this.entries = new NCArray(3);
        this.lastParsed = _lastParsed;
    }

    void updateTime() {
        this.lastParsed = new File(this.fullPath).lastModified();
    }

    boolean isUpToDate() {
        return this.lastParsed == new File(this.fullPath).lastModified();
    }

    boolean isValid() {
        File f = new File(this.fullPath);
        return !f.isDirectory() && f.exists();
    }

    void cleanUp(JSortedArray[] remColls) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            IndexEntry ie = (IndexEntry)e.nextElement();
            int n = 0;
            while (n < remColls.length) {
                remColls[n].remByEqualness(ie);
                ++n;
            }
        }
        this.entries = new NCArray(Math.max(this.entries.size(), 10));
        this.imports = emptyStringArr;
    }

    void add(IndexEntry ie) {
        this.entries.rem(ie);
        this.entries.add(ie);
    }

    Enumeration enumerate() {
        return this.entries.enumerate();
    }

    int size() {
        return this.entries.size();
    }

    void setPackage(String s) {
        this.packageName = s;
    }

    public boolean isFixedFile() {
        return this.packageName != null && (this.packageName.startsWith("java.") || this.packageName.startsWith("sun."));
    }

    String packageName() {
        if (this.packageName == null) {
            File tmpFi = new File(this.fullPath);
            if (!tmpFi.isDirectory()) {
                this.packageName = DocumentStream.ScanPackage(tmpFi);
            }
            if (this.packageName == null) {
                this.packageName = VFile.ExtractDir(this.fullPath);
                this.packageName = this.packageName.substring(this.packageName.lastIndexOf(File.separator), this.packageName.length());
            }
        }
        return this.packageName;
    }

    public void addImport(String pack) {
        if (this.importsContain(pack)) {
            return;
        }
        String[] s = new String[this.imports.length + 1];
        System.arraycopy(this.imports, 0, s, 0, this.imports.length);
        s[this.imports.length] = pack;
        this.imports = s;
    }

    public boolean importsContain(String pack) {
        int n = 0;
        while (n < this.imports.length) {
            if (this.imports[n].equals(pack)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public JSet importsAsSet() {
        JSet set = new JSet(this.imports.length * 2);
        int n = 0;
        while (n < this.imports.length) {
            set.add(this.imports[n]);
            ++n;
        }
        return set;
    }

    public String[] imports() {
        return this.imports;
    }

    void setImports(JSet js) {
        this.imports = new String[js.size() + 2];
        Enumeration en = js.enumerate();
        int idx = 0;
        while (en.hasMoreElements()) {
            this.imports[idx] = (String)en.nextElement();
            ++idx;
        }
        this.imports[idx++] = "java.lang".intern();
        this.imports[idx++] = this.packageName.intern();
    }
}

