/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.JArray;
import JCollections.JOrderedCollection;
import JCollections.JSet;
import JCollections.JSortedArray;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JIBFrame;
import de.netcomputing.anyj.jwidgets.JIBPanel;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JWNumberPanel;
import de.netcomputing.anyj.jwidgets.JWPercentBar;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import editapp.EditApp;
import editapp.FileEntry;
import editapp.FileRegistry;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MemOptimizer
extends JIBPanel {
    static MemOptimizer This;
    JTextField classDirTxt;
    NCButton helpBtn;
    NCButton backBtn;
    NCButton remBtn;
    NCButton applyBtn;
    NCButton cancelBtn;
    NCButton showAllBtn;
    NCButton remAllBtn;
    JListPanel listPanel;
    JListPanel remPanel;
    JLabel title1Label;
    JLabel unUsedLabel;
    JWPercentBar percentBar;
    JWNumberPanel numPanel;

    static MemOptimizer This(boolean show) {
        if (This == null) {
            This = new MemOptimizer();
            JIBFrame frame = new JIBFrame(This);
            EditApp.App.addFrame(frame);
            frame.setTitle("MemOptimizer");
            frame.pack();
            This.init(EditApp.App);
            Rectangle screen = JWidgetsUtil.GetScreenBounds();
            Dimension fd = new Dimension(450, 500);
            frame.setBounds(screen.x + (screen.width - fd.width) / 2, screen.y + (screen.height - fd.height) / 2, fd.width, fd.height);
        }
        if (show) {
            This.reInit();
            This.getFrame().show();
        }
        return This;
    }

    public void init() {
        this.classDirTxt = (JTextField)this.getComponent("classDirTxt");
        this.helpBtn = (NCButton)this.getComponent("helpBtn");
        this.backBtn = (NCButton)this.getComponent("backBtn");
        this.showAllBtn = (NCButton)this.getComponent("showAllBtn");
        this.remBtn = (NCButton)this.getComponent("remBtn");
        this.applyBtn = (NCButton)this.getComponent("applyBtn");
        this.cancelBtn = (NCButton)this.getComponent("cancelBtn");
        this.remAllBtn = (NCButton)this.getComponent("remAllBtn");
        this.listPanel = (JListPanel)this.getComponent("listPanel");
        this.remPanel = (JListPanel)this.getComponent("remPanel");
        this.title1Label = (JLabel)this.getComponent("title1Label");
        this.unUsedLabel = (JLabel)this.getComponent("unUsedLabel");
        this.numPanel = (JWNumberPanel)this.getComponent("numPanel");
        this.percentBar = (JWPercentBar)this.getComponent("percentBar");
        this.percentBar.hide();
        this.numPanel.setRange(0, 100000, 2000);
        this.numPanel.setInt(EditApp.IndexWarnSize);
        this.remPanel.addTarget(this, "actionRemListSel");
        this.listPanel.addTarget(this, "actionListSel");
        this.applyBtn.addTarget(this, "actionApply");
        this.cancelBtn.addTarget(this, "actionCancel");
        this.backBtn.addTarget(this, "actionBack");
        this.remBtn.addTarget(this, "actionRem");
        this.showAllBtn.addTarget(this, "actionShowAll");
        this.remAllBtn.addTarget(this, "actionRemAll");
        this.showAllBtn.hide();
        this.remAllBtn.hide();
    }

    public void reInit() {
        this.title1Label.setText("index size " + SourceBase.This().index().size());
        Vector v = this.determineUnusedPackages();
        int n = 0;
        while (n < v.size()) {
            v.setElementAt(new ListItem(v.elementAt(n)), n);
            ++n;
        }
        this.listPanel.setList(v, 0.0, 0);
        this.unUsedLabel.setText("Unused Packages");
        this.remPanel.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector determineUnusedPackages() {
        Vector vector;
        this.cursorWait();
        try {
            JSet packs = FileRegistry.This.getKnownPackages().asSet();
            JSet imports = new JSet(20);
            Enumeration en = FileRegistry.This.enumerate();
            while (en.hasMoreElements()) {
                FileEntry fe = (FileEntry)en.nextElement();
                if (fe.packageName().startsWith("java") || fe.packageName().startsWith("com")) continue;
                imports.addAll(fe.imports());
            }
            packs.minus(imports);
            Vector v = packs.asVector();
            new JArray(v).sort();
            vector = v;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cursorDefault();
            throw throwable;
        }
        this.cursorDefault();
        return vector;
    }

    void removeAllPackageEntries(JSet packs) {
        this.percentBar.show();
        JSortedArray index = SourceBase.This().index();
        JOrderedCollection base = index.getBase();
        JArray newBase = new JArray(base.size());
        this.percentBar.setMaxVal(base.size());
        if (packs.size() > 0) {
            int n = 0;
            while (n < base.size()) {
                IndexEntry ie = (IndexEntry)base.at(n);
                if (n % 200 == 0) {
                    this.percentBar.setVal(n);
                }
                if (!packs.contains(ie.realPackage())) {
                    newBase.add(ie);
                } else {
                    FileRegistry.This.remove(ie.fileString());
                }
                ++n;
            }
            index.setBase(newBase);
            SourceBase.This().filteredIndex = null;
            SourceBase.This().rebuildIndex();
        }
        this.actionCancel(null, null);
    }

    public Object actionRemListSel(Object arg, Object sen) {
        IListItem o = this.remPanel.getSelectedItem();
        if (o == null) {
            this.backBtn.setEnabled(false);
        } else {
            this.backBtn.setEnabled(true);
        }
        return null;
    }

    public Object actionShowAll(Object arg, Object sen) {
        this.unUsedLabel.setText("Known Packages");
        Vector packs = FileRegistry.This.getKnownPackages().asVector();
        new JArray(packs).sort();
        int n = 0;
        while (n < packs.size()) {
            packs.setElementAt(new ListItem(packs.elementAt(n)), n);
            ++n;
        }
        this.listPanel.setList(packs, 0.0, 0);
        return null;
    }

    public Object actionListSel(Object arg, Object sen) {
        IListItem o = this.listPanel.getSelectedItem();
        if (o == null) {
            this.remBtn.setEnabled(false);
            this.remAllBtn.setEnabled(false);
        } else {
            this.remBtn.setEnabled(true);
            this.remAllBtn.setEnabled(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object actionApply(Object arg, Object sen) {
        this.cursorWait();
        EditApp.IndexWarnSize = this.numPanel.getInt();
        try {
            Vector v = (Vector)this.remPanel.getList().clone();
            int n = 0;
            while (n < v.size()) {
                v.setElementAt(((ListItem)v.elementAt(n)).wrappedObject(), n);
                ++n;
            }
            this.removeAllPackageEntries(JSet.FromVector(v));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cursorDefault();
            throw throwable;
        }
        this.cursorDefault();
        return null;
    }

    public Object actionCancel(Object arg, Object sen) {
        this.getFrame().hide();
        return null;
    }

    public Object actionBack(Object arg, Object sen) {
        IListItem o = this.remPanel.getSelectedItem();
        if (o == null) {
            this.backBtn.setEnabled(false);
        } else {
            this.listPanel.addItemRepainting(o);
            this.remPanel.removeItemRepainting(o);
        }
        return null;
    }

    public Object actionRem(Object arg, Object sen) {
        IListItem o = this.listPanel.getSelectedItem();
        if (o == null) {
            this.remBtn.setEnabled(false);
        } else {
            this.remPanel.addItemRepainting(o);
            this.listPanel.removeItemRepainting(o);
        }
        return null;
    }

    public Object actionRemAll(Object arg, Object sen) {
        return null;
    }

    public String getJIBName() {
        return "MemOpt.jib";
    }
}

