/*
 * Decompiled with CFR 0.152.
 */
package editapp.stringstore;

import de.netcomputing.util.Tracer;
import editapp.stringstore.IStringStore;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class JavaStringStore
implements IStringStore {
    int[] keyVal = new int[100000];
    public byte[] allchars = new byte[2000000];
    int actCount = 1;
    int size = 0;
    boolean writeAll = false;

    public void reset() {
        Tracer.This.println("STRINGSTORE RESET");
        this.keyVal = new int[100000];
        this.allchars = new byte[2000000];
        this.actCount = 1;
        this.size = 0;
        this.writeAll = true;
    }

    public synchronized int addString(String key) {
        int pos = this.locateIndex(key, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            int value = this.privateAddString(key);
            this.setKeyValue(pos, this.computeHash(value), value);
            return value;
        }
        return this.valueAt(pos);
    }

    public synchronized int addString(int charIdx) {
        int pos = this.locateIndex(charIdx, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            int value = charIdx;
            this.setKeyValue(pos, this.computeHash(value), value);
            return value;
        }
        return this.valueAt(pos);
    }

    int privateAddString(String s) {
        if (s.length() + this.actCount >= this.allchars.length - 5) {
            Tracer.This.println("*** PRE resize byte[] *****");
            int newLength = this.allchars.length;
            newLength = this.allchars.length < 1000000 ? (newLength *= 2) : (newLength += 1000000);
            byte[] newChars = new byte[newLength];
            System.arraycopy(this.allchars, 0, newChars, 0, this.allchars.length);
            this.allchars = newChars;
            Tracer.This.println("*** resize byte[] *****:" + newChars.length);
        }
        int n = 0;
        while (n < s.length()) {
            this.allchars[this.actCount + n] = (byte)s.charAt(n);
            ++n;
        }
        int resultingID = this.actCount;
        this.actCount += s.length() + 1;
        this.allchars[this.actCount - 1] = 0;
        return resultingID;
    }

    public synchronized String getString(int id) {
        int i = 0;
        while (this.allchars[id + i] != 0) {
            ++i;
        }
        return new String(this.allchars, 0, id, i);
    }

    public synchronized void put(int key, int value) {
        int pos = this.locateIndex(value, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            this.setKeyValue(pos, key, value);
        }
    }

    int computeHash(String s) {
        int h = 0;
        int i = 0;
        while (i < s.length()) {
            h = h * 37 + s.charAt(i);
            ++i;
        }
        if (h == 0) {
            h = 13;
        }
        return h;
    }

    int computeHash(int charIdx) {
        int h = 0;
        byte[] val = this.allchars;
        int i = charIdx;
        while (this.allchars[i] > 0) {
            h = h * 37 + this.allchars[i];
            ++i;
        }
        if (h == 0) {
            h = 13;
        }
        return h;
    }

    boolean compare(String s, int idx2) {
        int sidx = 0;
        while (sidx < s.length() && idx2 < this.allchars.length && s.charAt(sidx) == this.allchars[idx2]) {
            ++sidx;
            ++idx2;
        }
        return sidx >= s.length() && idx2 < this.allchars.length && 0 == this.allchars[idx2];
    }

    boolean compareIds(int idx1, int idx2) {
        if (idx1 == idx2) {
            return true;
        }
        while (this.allchars[idx1] > 0 && this.allchars[idx2] > 0 && this.allchars[idx1++] == this.allchars[idx2++]) {
        }
        return this.allchars[idx1] == this.allchars[idx2];
    }

    protected void ensureCapacity(int newCap) {
        if (this.keyVal.length <= newCap * 2) {
            int[] old = this.keyVal;
            this.keyVal = new int[newCap * 2];
            int oldSize = this.size;
            this.size = 0;
            Tracer.This.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ expanding index:" + this.keyVal.length + " size:" + oldSize);
            try {
                int n = old.length - 2;
                while (n >= 0) {
                    if (old[n] != 0) {
                        this.put(old[n], old[n + 1]);
                    }
                    n -= 2;
                }
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            Tracer.This.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ size nach put:" + this.size);
        }
    }

    protected int locateIndex(int charId, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 >= this.keyVal.length) {
                try {
                    this.ensureCapacity(this.size * 3 / 2);
                }
                catch (Exception e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int hashCode = this.computeHash(charId);
        int cnt = 0;
        int pos = hpos = 2 * ((hashCode * 7621 & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != 0) {
            if (this.compareIds(charId, this.keyVal[pos + 1])) break;
            ++cnt;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    protected int locateIndex(String key, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 >= this.keyVal.length) {
                try {
                    this.ensureCapacity(this.size * 3);
                }
                catch (Exception e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int hashCode = this.computeHash(key);
        int cnt = 0;
        int pos = hpos = 2 * ((hashCode * 7621 & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != 0) {
            if (this.compare(key, this.keyVal[pos + 1])) break;
            ++cnt;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    public int getCapacity() {
        return this.keyVal.length >> 1;
    }

    int keyAt(int i) {
        return this.keyVal[i << 1];
    }

    int valueAt(int i) {
        return this.keyVal[(i << 1) + 1];
    }

    public synchronized void saveTo(String file2) {
        long time = System.currentTimeMillis();
        try {
            int oldLen = 0;
            File oldFile = null;
            try {
                oldFile = new File(file2);
                oldLen = (int)oldFile.length();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (oldLen <= 0 || !this.writeAll) {
                // empty if block
            }
            FileOutputStream fi = null;
            DataOutputStream out = null;
            fi = new FileOutputStream(file2);
            out = new DataOutputStream(new BufferedOutputStream(fi, 500000));
            out.writeInt(this.actCount);
            out.writeInt(this.size);
            out.writeInt(this.keyVal.length);
            out.write(this.allchars, 0, this.actCount);
            int cnt = 0;
            int n = 0;
            while (n < this.keyVal.length) {
                if (this.keyVal[n] != 0) {
                    ++cnt;
                }
                if (this.keyVal[n] != 0) {
                    out.writeInt(this.keyVal[n + 1]);
                }
                n += 2;
            }
            out.flush();
            fi.flush();
            fi.close();
            Tracer.This.println("wrote JavaStringStore:" + (System.currentTimeMillis() - time));
            Tracer.This.println("\tcharall:" + this.allchars.length);
            Tracer.This.println("\tactcount:" + this.actCount);
            Tracer.This.println("\tsize:" + this.size);
            Tracer.This.println("\tkeyval:" + this.keyVal.length);
            Tracer.This.println("\tTIME:" + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void readFrom(String file2) throws Exception {
        long time = System.currentTimeMillis();
        FileInputStream fi = null;
        int len = (int)new File(file2).length();
        Tracer.This.println("** len " + len);
        fi = new FileInputStream(file2);
        Tracer.This.println("** avail " + fi.available());
        DataInputStream in = new DataInputStream(fi);
        this.actCount = in.readInt();
        int prefSize = in.readInt();
        this.size = 0;
        this.keyVal = new int[in.readInt()];
        this.allchars = new byte[this.actCount + 300000];
        fi.read(this.allchars, 0, this.actCount);
        int n = 0;
        while (n < prefSize) {
            this.addString(in.readInt());
            ++n;
        }
        fi.close();
        Tracer.This.println("loading JavaStringStore:" + (System.currentTimeMillis() - time));
        Tracer.This.println("\tcharall:" + this.allchars.length);
        Tracer.This.println("\tactcount:" + this.actCount);
        Tracer.This.println("\tsize:" + this.size);
        Tracer.This.println("\tkeyval:" + this.keyVal.length);
    }

    void setKeyValue(int i, int key, int value) {
        this.keyVal[i << 1] = key;
        this.keyVal[(i << 1) + 1] = value;
    }

    public static void main(String[] arg) {
        JavaStringStore store = new JavaStringStore();
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane123"));
        Tracer.This.println(store.addString("Hallokabane456"));
        int i = store.addString("Hallokabane");
        Tracer.This.println(i);
        Tracer.This.println(store.getString(i));
    }
}

