/*
 * Decompiled with CFR 0.152.
 */
package editapp.stringstore;

import de.netcomputing.util.Tracer;
import editapp.stringstore.IStringStore;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class NIOStore
implements IStringStore {
    int[] keyVal = new int[150000];
    ByteBuffer allchars = null;
    int allcharsLen;
    int actCount = 1;
    int size = 0;
    boolean writeAll = false;

    public NIOStore() {
        this.reset();
    }

    public void reset() {
        Tracer.This.println("NIOStore RESET");
        this.keyVal = new int[150000];
        this.allcharsLen = 3000000;
        this.allchars = ByteBuffer.allocateDirect(this.allcharsLen);
        this.actCount = 1;
        this.size = 0;
        this.writeAll = true;
    }

    public synchronized int addString(String key) {
        int pos = this.locateIndex(key, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            int value = this.privateAddString(key);
            this.setKeyValue(pos, this.computeHash(value), value);
            if (this.computeHash(value) != this.computeHash(key)) {
                Tracer.This.println("FATAL ERROR: HASHKEYS DIFFER");
            }
            return value;
        }
        return this.valueAt(pos);
    }

    public synchronized int addString(int charIdx) {
        int pos = this.locateIndex(charIdx, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            int value = charIdx;
            this.setKeyValue(pos, this.computeHash(value), value);
            return value;
        }
        return this.valueAt(pos);
    }

    int privateAddString(String s) {
        if (s.length() + this.actCount >= this.allcharsLen - 5) {
            Tracer.This.println("*** PRE resize byte[] *****");
            int newLength = this.allcharsLen;
            newLength = this.allcharsLen < 1000000 ? (newLength *= 2) : (newLength += 1000000);
            ByteBuffer newChars = ByteBuffer.allocateDirect(newLength);
            int n = 0;
            while (n < this.allcharsLen) {
                newChars.put(n, this.allchars.get(n));
                ++n;
            }
            this.allcharsLen = newLength;
            this.allchars = newChars;
            Tracer.This.println("*** resize byte[] *****:" + newLength);
        }
        int n = 0;
        while (n < s.length()) {
            this.allchars.put(this.actCount + n, (byte)s.charAt(n));
            ++n;
        }
        int resultingID = this.actCount;
        this.actCount += s.length() + 1;
        this.allchars.put(this.actCount - 1, (byte)0);
        return resultingID;
    }

    public synchronized String getString(int id) {
        int i = 0;
        while (this.allchars.get(id + i) != 0) {
            ++i;
        }
        byte[] b = new byte[i];
        this.allchars.position(id);
        this.allchars.get(b, 0, i);
        return new String(b);
    }

    public synchronized void put(int key, int value) {
        int pos = this.locateIndex(value, true);
        if (this.keyAt(pos) == 0) {
            ++this.size;
            this.setKeyValue(pos, key, value);
        }
    }

    int computeHash(String s) {
        int h = 0;
        int i = 0;
        while (i < s.length()) {
            h = h * 37 + s.charAt(i);
            ++i;
        }
        if (h == 0) {
            h = 13;
        }
        return h;
    }

    int computeHash(int charIdx) {
        int h = 0;
        int i = charIdx;
        while (this.allchars.get(i) > 0) {
            h = h * 37 + this.allchars.get(i);
            ++i;
        }
        if (h == 0) {
            h = 13;
        }
        return h;
    }

    boolean compare(String s, int idx2) {
        int sidx = 0;
        while (sidx < s.length() && idx2 < this.allcharsLen && s.charAt(sidx) == this.allchars.get(idx2)) {
            ++sidx;
            ++idx2;
        }
        return sidx >= s.length() && idx2 < this.allcharsLen && 0 == this.allchars.get(idx2);
    }

    boolean compareIds(int idx1, int idx2) {
        if (idx1 == idx2) {
            return true;
        }
        while (this.allchars.get(idx1) > 0 && this.allchars.get(idx2) > 0 && this.allchars.get(idx1++) == this.allchars.get(idx2++)) {
        }
        return this.allchars.get(idx1) == this.allchars.get(idx2);
    }

    protected void ensureCapacity(int newCap) {
        if (this.keyVal.length <= newCap << 1) {
            int[] old = this.keyVal;
            this.keyVal = new int[newCap << 1];
            int oldSize = this.size;
            this.size = 0;
            Tracer.This.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ expanding index:" + this.keyVal.length + " size:" + oldSize);
            try {
                int n = old.length - 2;
                while (n >= 0) {
                    if (old[n] != 0) {
                        this.put(old[n], old[n + 1]);
                    }
                    n -= 2;
                }
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            Tracer.This.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ size nach put:" + this.size);
        }
    }

    protected int locateIndex(int charId, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 >= this.keyVal.length) {
                try {
                    this.ensureCapacity(this.size * 3);
                }
                catch (Exception e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int hashCode = this.computeHash(charId);
        int cnt = 0;
        int pos = hpos = 2 * ((hashCode * 7621 & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != 0) {
            if (this.compareIds(charId, this.keyVal[pos + 1])) break;
            ++cnt;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    protected int locateIndex(String key, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 >= this.keyVal.length) {
                try {
                    this.ensureCapacity(this.size * 3);
                }
                catch (Exception e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int hashCode = this.computeHash(key);
        int cnt = 0;
        int pos = hpos = 2 * ((hashCode * 7621 & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != 0) {
            if (this.compare(key, this.keyVal[pos + 1])) break;
            ++cnt;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    public int getCapacity() {
        return this.keyVal.length >> 1;
    }

    int keyAt(int i) {
        return this.keyVal[i << 1];
    }

    int valueAt(int i) {
        return this.keyVal[(i << 1) + 1];
    }

    public synchronized void saveTo(String file2) {
        long time = System.currentTimeMillis();
        try {
            int oldLen = 0;
            File oldFile = null;
            try {
                oldFile = new File(file2);
                oldLen = (int)oldFile.length();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (oldLen <= 0 || !this.writeAll) {
                // empty if block
            }
            FileOutputStream fi = null;
            DataOutputStream out = null;
            fi = new FileOutputStream(file2);
            out = new DataOutputStream(new BufferedOutputStream(fi, 500000));
            out.writeInt(this.actCount);
            out.writeInt(this.size);
            out.writeInt(this.keyVal.length);
            int cnt = 0;
            int n = 0;
            while (n < this.keyVal.length) {
                if (this.keyVal[n] != 0) {
                    ++cnt;
                }
                if (this.keyVal[n] != 0) {
                    out.writeInt(this.keyVal[n + 1]);
                }
                n += 2;
            }
            out.flush();
            fi.flush();
            fi.close();
            Tracer.This.println("wrote JavaStringStore:" + (System.currentTimeMillis() - time));
            Tracer.This.println("\tcharall:" + this.allcharsLen);
            Tracer.This.println("\tactcount:" + this.actCount);
            Tracer.This.println("\tsize:" + this.size);
            Tracer.This.println("\tkeyval:" + this.keyVal.length);
            Tracer.This.println("\tTIME:" + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void readFrom(String file2) throws Exception {
    }

    void setKeyValue(int i, int key, int value) {
        this.keyVal[i << 1] = key;
        this.keyVal[(i << 1) + 1] = value;
    }

    public static void main(String[] arg) {
        NIOStore store = new NIOStore();
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane"));
        Tracer.This.println(store.addString("Hallokabane123"));
        Tracer.This.println(store.addString("Hallokabane456"));
        int i = store.addString("Hallokabane");
        Tracer.This.println(i);
        Tracer.This.println(store.getString(i));
    }
}

