/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;

public class ComponentView
extends View {
    protected Component m_comp;
    String m_alt;

    public ComponentView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected void drawFocusBox(Graphics g) {
        g.setColor(Color.orange);
        int i = 0;
        while (i <= 3) {
            g.drawRect(this.m_bounds.x + i, this.m_bounds.y + i, this.m_bounds.width - 2 * i, this.m_bounds.height - 2 * i);
            ++i;
        }
    }

    protected void flushResources() {
        if (this.m_comp != null) {
            this.m_comp.removeMouseMotionListener(this.m_container);
            this.m_comp = null;
        }
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        if (this.m_comp != null) {
            Dimension size = this.m_comp.getPreferredSize();
            switch (axis) {
                case 1: {
                    return size.width + this.m_insets.left + this.m_insets.right;
                }
                case 0: {
                    return size.height + this.m_insets.top + this.m_insets.bottom;
                }
            }
        }
        return 0;
    }

    protected String getToolTipText() {
        return this.m_alt == null ? "" : this.m_alt;
    }

    protected void init() {
        Hashtable atts = this.m_elem.getAttributes();
        this.m_alt = (String)this.m_elem.getAttribute("alt");
        this.m_comp = (Component)this.m_elem.getAttribute("component");
        if (this.m_comp != null) {
            this.m_comp.addMouseMotionListener(this.m_container);
            this.m_comp.setVisible(true);
            this.m_container.add(this.m_comp);
        }
    }

    protected boolean isContainerView() {
        return false;
    }

    protected boolean isDisplayableView() {
        return this.m_comp != null;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        this.m_bounds = new Rectangle(x, y, 0, 0);
        if (this.m_comp != null) {
            Dimension sz;
            int compWidth = 0;
            int compHeight = 0;
            int pspan = this.getPreferredSpan(1);
            if (pspan <= width) {
                sz = this.m_comp.getPreferredSize();
                compWidth = sz.width;
                compHeight = sz.height;
                width = pspan;
            } else {
                sz = this.m_comp.getPreferredSize();
                compWidth = Math.max(0, width - this.m_insets.left - this.m_insets.right);
                compHeight = sz.height;
            }
            Dimension size = this.m_comp.getSize();
            this.m_comp.setBounds(this.m_bounds.x + this.m_insets.left, this.m_bounds.y + this.m_insets.top, compWidth, compHeight);
            this.m_bounds = new Rectangle(x, y, width, compHeight + this.m_insets.top + this.m_insets.bottom);
        }
        return this.m_bounds;
    }

    protected void move(int x, int y, boolean bMoveFloaters) {
        this.m_bounds.x += x;
        this.m_bounds.y += y;
        if (this.m_comp != null) {
            Dimension size = this.m_comp.getSize();
            this.m_comp.setBounds(this.m_bounds.x + this.m_insets.left, this.m_bounds.y + this.m_insets.top, size.width, size.height);
        }
    }

    public void paint(Graphics g, Shape alloc) {
        if (this.m_comp != null) {
            this.m_comp.setVisible(this.m_bounds.intersects(alloc.getBounds()));
        }
    }
}

