/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BlockView;
import horst.Element;
import horst.FrameConstraint;
import horst.FrameSetLayout;
import horst.FrameSetPanel;
import horst.FrameSplitterBar;
import horst.HTMLPane;
import horst.HTMLWindow;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;

public class FrameSetView
extends BlockView {
    FrameSetPanel m_panel;
    Component[] m_framesetChildren;
    URL[] m_frameURLs;
    FrameConstraint[] m_constraints;
    int m_orientation = 0;
    boolean m_bLoadedFrames;

    public FrameSetView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected Dimension getBrowserDimension() {
        Container parent = this.m_container.getParent();
        if (parent != null && parent instanceof JViewport) {
            return ((JViewport)parent).getExtentSize();
        }
        return new Dimension(700, 700);
    }

    Object getFrame(int idx) {
        HTMLWindow wnd;
        if (this.m_framesetChildren != null && this.m_framesetChildren.length > idx && this.m_framesetChildren[idx] instanceof HTMLWindow && (wnd = (HTMLWindow)this.m_framesetChildren[idx]) != null) {
            return wnd.getViewport().getView();
        }
        return null;
    }

    HTMLPane getFrame(String frameName) {
        if (frameName != null) {
            int i = 0;
            while (i < this.m_framesetChildren.length) {
                if (this.m_framesetChildren[i] instanceof HTMLWindow) {
                    HTMLWindow p = (HTMLWindow)this.m_framesetChildren[i];
                    HTMLPane html = p.getHTMLPane();
                    String name = html.m_props.frameName;
                    if (name != null && name.equals(frameName)) {
                        return html;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        Dimension dim = this.getBrowserDimension();
        if (axis == 1) {
            return dim.width;
        }
        return dim.height;
    }

    protected void init() {
        this.m_bLoadedFrames = false;
        this.m_panel = new FrameSetPanel();
        this.m_container.add(this.m_panel);
        this.m_panel.setBackground(Color.white);
        int nCount = this.m_elem.getElementCount();
        FrameSetLayout layoutManager = new FrameSetLayout();
        boolean bAddSplitterBars = true;
        String atts = (String)this.m_elem.getAttribute("frameborder");
        if (!this.m_container.m_preferences.bAlwaysSizableFrames && atts != null && (atts.equalsIgnoreCase("0") || atts.equalsIgnoreCase("no"))) {
            layoutManager.setAlwaysConstraintLayout(true);
            bAddSplitterBars = false;
        }
        Vector<JComponent> temp = new Vector<JComponent>();
        Vector<URL> urlVec = new Vector<URL>();
        this.m_framesetChildren = new JComponent[nCount];
        URL refURL = this.m_elem.getDocument().getBaseURL();
        int i = 0;
        while (i < nCount) {
            Element elem = this.m_elem.getElementAt(i);
            if (elem.getType() == 36) {
                HTMLWindow htmlWnd = new HTMLWindow();
                HTMLPane html = htmlWnd.getHTMLPane();
                html.m_preferences.bShowToolTip = false;
                html.m_props.bIsFrame = true;
                html.m_props.framesetView = this;
                html.m_props.frameBaseDocument = this.m_container.getDocument();
                String name = (String)elem.getAttribute("name");
                if (name != null) {
                    html.m_props.frameName = name;
                }
                String src = (String)elem.getAttribute("src");
                URL url = null;
                url = refURL != null ? Utilities.getURL(refURL, src) : Utilities.getURL(src);
                if (url != null) {
                    html.openPage(url);
                }
                urlVec.addElement(url);
                if (!bAddSplitterBars) {
                    htmlWnd.setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                temp.addElement(htmlWnd);
            } else if (elem.getType() == 35) {
                FrameSetView fv = (FrameSetView)this.m_container.m_viewFactory.createView(null, elem, this.m_container);
                temp.addElement(fv.m_panel);
            }
            ++i;
        }
        this.m_framesetChildren = new Component[temp.size()];
        temp.copyInto(this.m_framesetChildren);
        this.m_frameURLs = new URL[urlVec.size()];
        urlVec.copyInto(this.m_frameURLs);
        atts = (String)this.m_elem.getAttribute("cols");
        if (atts != null) {
            layoutManager.setOrientation(0);
            this.parseAttributes(atts);
        } else {
            atts = (String)this.m_elem.getAttribute("rows");
            if (atts != null) {
                layoutManager.setOrientation(1);
                this.parseAttributes(atts);
            } else {
                layoutManager.setOrientation(0);
                this.m_constraints = new FrameConstraint[this.m_framesetChildren.length];
                int i2 = 0;
                while (i2 < this.m_framesetChildren.length) {
                    this.m_constraints[i2] = new FrameConstraint();
                    this.m_constraints[i2].percent = i2 == 0 ? 1.0f : 0.0f;
                    ++i2;
                }
            }
        }
        this.m_panel.setLayout(layoutManager);
        int i3 = 0;
        while (i3 < this.m_framesetChildren.length) {
            layoutManager.setConstraints(this.m_framesetChildren[i3], this.m_constraints[i3]);
            this.m_panel.add(this.m_framesetChildren[i3]);
            if (bAddSplitterBars && i3 != this.m_framesetChildren.length - 1 && this.m_framesetChildren.length > 1) {
                FrameSplitterBar splitbar = new FrameSplitterBar(this.m_orientation);
                if (this.m_framesetChildren[i3] instanceof HTMLWindow) {
                    HTMLWindow htmlwindow = (HTMLWindow)this.m_framesetChildren[i3];
                }
                splitbar.setResizable(true);
                this.m_panel.add(splitbar);
            }
            ++i3;
        }
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        if (!this.m_container.getFramesEnabled()) {
            this.m_bounds.setBounds(0, 0, 0, 0);
            return this.m_bounds;
        }
        Dimension d = this.getBrowserDimension();
        this.m_bounds.setBounds(x, y, width, d.height);
        this.m_panel.setBounds(this.m_bounds);
        return this.m_bounds;
    }

    protected void makeChildren(ViewFactory viewfactory) {
    }

    public void paint(Graphics g, Shape alloc) {
        this.m_panel.invalidate();
    }

    void parseAttributes(String attStr) {
        if (attStr != null) {
            StringTokenizer st = new StringTokenizer(attStr, ",");
            int nCols = st.countTokens();
            this.m_constraints = new FrameConstraint[nCols];
            if (nCols > 0) {
                int i = 0;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    this.m_constraints[i] = new FrameConstraint();
                    Integer val = null;
                    val = Utilities.parseInteger(token, '%');
                    if (val != null) {
                        this.m_constraints[i].type = 1;
                        this.m_constraints[i].percent = (float)val.intValue() / 100.0f;
                    } else {
                        val = this.parseWildCard(token);
                        if (val != null) {
                            this.m_constraints[i].type = 2;
                            this.m_constraints[i].wildcard = val;
                        } else {
                            val = Utilities.getInteger(token);
                            this.m_constraints[i].type = 0;
                            this.m_constraints[i].pixels = val;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    Integer parseWildCard(String token) {
        Integer val = null;
        int idx = token.indexOf(42);
        if (idx != -1) {
            try {
                token = token.substring(0, idx).trim();
                val = new Integer(token);
            }
            catch (NumberFormatException ex) {
                return new Integer(1);
            }
        }
        return val;
    }

    protected void reset() {
        this.m_bLoadedFrames = false;
        super.reset();
    }
}

