/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import java.awt.Rectangle;

public class SpacerView
extends View {
    int m_height;
    int m_width;

    public SpacerView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return this.m_height;
            }
            case 1: {
                return this.m_width;
            }
        }
        return 0;
    }

    protected void init() {
        Integer iVal;
        this.m_height = 0;
        this.m_width = 0;
        int sz = 0;
        String val = (String)this.m_elem.getAttribute("size");
        if (val != null && (iVal = Utilities.getInteger(val)) != null) {
            sz = iVal;
        }
        if ((val = (String)this.m_elem.getAttribute("type")) != null) {
            if (val.equalsIgnoreCase("vertical")) {
                this.m_height = sz;
            } else if (val.equalsIgnoreCase("horizontal")) {
                this.m_width = sz;
            } else if (val.equalsIgnoreCase("block")) {
                this.m_width = sz;
                this.m_height = sz;
            }
        }
        this.m_height = Utilities.setIntegerProperty(this.m_height, "height", this.m_elem.getAttributes());
        this.m_width = Utilities.setIntegerProperty(this.m_width, "height", this.m_elem.getAttributes());
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        int viewWidth = Math.max(0, width - info.leftMargin - info.rightMargin);
        if (viewWidth < this.m_width) {
            this.m_bounds.setBounds(x, y, viewWidth, this.m_height);
        } else {
            this.m_bounds.setBounds(x, y, this.m_width, this.m_height);
        }
        return this.m_bounds;
    }
}

