/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.ElementViewInfo;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.TableCell;
import horst.TableView;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;

public class TableRow
extends View {
    int[] m_colWidths;
    CellBorder[] m_cellBorders;
    Color m_bgColor;
    int m_valign;
    int m_prefWidth = -1;
    int m_prefHeight = -1;
    int m_minWidth = -1;
    int m_minHeight = -1;
    TableView m_tableView;

    public TableRow(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected void computeCellBorders() {
        this.m_cellBorders = new CellBorder[this.m_children.length];
        int cellSpacing = this.m_tableView.m_cellSpacing;
        int i = 0;
        while (i < this.m_children.length) {
            CellBorder r = new CellBorder();
            TableCell cell = (TableCell)this.m_children[i];
            Rectangle bounds = cell.getBounds();
            r.setBounds(bounds);
            this.m_cellBorders[i] = r;
            this.m_cellBorders[i].bPaint = false;
            View[] children = cell.m_children;
            int h = 0;
            while (h < children.length) {
                if (children[h].isDisplayableView()) {
                    this.m_cellBorders[i].bPaint = true;
                    break;
                }
                ++h;
            }
            ++i;
        }
    }

    protected int getBiggestRowSpan() {
        int result = 1;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            result = Math.max(result, cell.m_rowSpan);
            ++i;
        }
        return result;
    }

    protected TableCell getCell(int i) {
        if (this.m_children != null && i < this.m_children.length) {
            return (TableCell)this.m_children[i];
        }
        return null;
    }

    protected int getHeightSpec() {
        int heightSpec = -1;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell.m_height >= 0) {
                heightSpec = Math.max(heightSpec, cell.m_height);
            }
            ++i;
        }
        return heightSpec;
    }

    protected int getMinimumSpan(int axis) {
        if (axis == 1) {
            if (this.m_minWidth != -1) {
                return this.m_minWidth;
            }
            int span = 0;
            int i = 0;
            while (i < this.m_children.length) {
                span += this.m_children[i].getMinimumSpan(1);
                ++i;
            }
            this.m_minWidth = span += (this.m_children.length - 1) * this.m_tableView.m_cellSpacing;
            return this.m_minWidth;
        }
        return 0;
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 1) {
            if (this.m_prefWidth != -1) {
                return this.m_prefWidth;
            }
            int m_prefWidth = 0;
            int i = 0;
            while (i < this.m_children.length) {
                m_prefWidth += this.m_children[i].getPreferredSpan(1);
                ++i;
            }
            return m_prefWidth += (this.m_children.length - 1) * this.m_tableView.m_cellSpacing;
        }
        return 0;
    }

    protected TableCell getTableColumn(int col) {
        TableCell tableCell = null;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell != null) {
                if (cell.m_startColumn == col) {
                    if (cell.m_endColumn != cell.m_startColumn) break;
                    tableCell = cell;
                    break;
                }
                if (cell.m_endColumn >= col) break;
            }
            ++i;
        }
        return tableCell;
    }

    protected Rectangle increaseHeight(int increaseY) {
        int rowHeight = 0;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell.m_rowSpan == 1) {
                cell.increaseHeight(increaseY);
                rowHeight = Math.max(rowHeight, cell.getBounds().height);
            }
            ++i;
        }
        this.m_bounds.height = rowHeight;
        return this.m_bounds;
    }

    protected void init() {
        this.m_tableView = (TableView)this.m_parent;
        this.m_bgColor = Utilities.setColorProperty(this.m_tableView.m_bgColor, "bgcolor", this.m_elem.getAttributes());
        this.m_alignment = Utilities.setAlignmentProperty(false, 0, "align", this.m_elem.getAttributes());
        this.m_valign = Utilities.setAlignmentProperty(true, 1, "valign", this.m_elem.getAttributes());
    }

    protected int[] layoutMultiRowCells(int x, int y, int width, int[] rowHeights, LayoutInfo info) {
        int cellSpacing = this.m_tableView.m_cellSpacing;
        int xPos = x;
        boolean rowHeight = false;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell.m_rowSpan >= 2) {
                int colspan = cell.m_colSpan;
                int startCol = cell.m_startColumn;
                int endCol = cell.m_endColumn;
                xPos = x;
                int j = 0;
                while (j < startCol) {
                    xPos += this.m_colWidths[j] + cellSpacing;
                    ++j;
                }
                int layoutWidth = 0;
                int j2 = startCol;
                while (j2 <= endCol) {
                    layoutWidth += this.m_colWidths[j2];
                    ++j2;
                }
                if (colspan > 1) {
                    layoutWidth += (colspan - 1) * cellSpacing;
                }
                LayoutInfo subInfo = new LayoutInfo();
                subInfo.bPaginate = info.bPaginate;
                subInfo.pageBreak = info.pageBreak;
                Rectangle bounds = cell.layout(xPos, y, layoutWidth, subInfo);
                int startRow = cell.m_startRow;
                int endRow = cell.m_endRow;
                int span = 0;
                int j3 = startRow;
                while (j3 <= endRow) {
                    span += rowHeights[j3];
                    ++j3;
                }
                if (cell.m_rowSpan > 1) {
                    int nDefinedRows = this.m_tableView.m_nDefinedRows;
                    if (startRow < nDefinedRows - 1 && endRow >= nDefinedRows - 1) {
                        int nValidRowsSpanned = nDefinedRows - startRow;
                        if (nValidRowsSpanned > 0 && cellSpacing > 0) {
                            span += (nValidRowsSpanned - 1) * cellSpacing;
                        }
                    } else if (cellSpacing > 0) {
                        span += (cell.m_rowSpan - 1) * cellSpacing;
                    }
                }
                if (span < bounds.height) {
                    int diff = bounds.height - span;
                    boolean bCheckSpecs = true;
                    int[] heightSpecs = this.m_tableView.m_rowHeightSpecs;
                    block4: while (diff > 0) {
                        int row = startRow;
                        while (row <= endRow && diff > 0) {
                            if (!bCheckSpecs || heightSpecs[row] < 0 || heightSpecs[row] > 0 && heightSpecs[row] > rowHeights[row]) {
                                this.m_tableView.increaseRowHeight(row, 1);
                                int n = row;
                                rowHeights[n] = rowHeights[n] + 1;
                                --diff;
                            }
                            ++row;
                        }
                        bCheckSpecs = false;
                        int row2 = startRow;
                        while (row2 <= endRow && diff > 0) {
                            if (heightSpecs[row2] < 0 || heightSpecs[row2] > 0 && heightSpecs[row2] > rowHeights[row2]) {
                                bCheckSpecs = true;
                                continue block4;
                            }
                            ++row2;
                        }
                    }
                }
            }
            ++i;
        }
        int h = 0;
        View[] vws = this.m_tableView.m_children;
        int i2 = 0;
        while (i2 < vws.length) {
            TableRow r = (TableRow)vws[i2];
            if (r == this) {
                h = rowHeights[i2];
                break;
            }
            ++i2;
        }
        this.m_bounds.height = h;
        int w = 0;
        int i3 = 0;
        while (i3 < this.m_colWidths.length) {
            w += this.m_colWidths[i3];
            if (i3 != this.m_colWidths.length - 1) {
                w += cellSpacing;
            }
            ++i3;
        }
        this.m_bounds.width = w;
        return rowHeights;
    }

    protected Rectangle layoutSingleRowCells(int x, int y, int width, LayoutInfo info) {
        this.m_bounds = new Rectangle(x, y, 0, 0);
        int cellSpacing = this.m_tableView.m_cellSpacing;
        int xPos = x;
        int rowWidth = 0;
        int rowHeight = 0;
        int nColumns = this.m_tableView.m_nColumns;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell.m_rowSpan <= 1) {
                int colspan = cell.m_colSpan;
                int startCol = cell.m_startColumn;
                int endCol = cell.m_endColumn;
                xPos = x;
                int j = 0;
                while (j < startCol) {
                    xPos += this.m_colWidths[j] + cellSpacing;
                    ++j;
                }
                int layoutWidth = 0;
                int j2 = startCol;
                while (j2 <= endCol) {
                    layoutWidth += this.m_colWidths[j2];
                    ++j2;
                }
                if (colspan > 1) {
                    layoutWidth += (colspan - 1) * cellSpacing;
                }
                LayoutInfo subInfo = new LayoutInfo();
                subInfo.bPaginate = false;
                Rectangle bounds = cell.layout(xPos, y, layoutWidth, subInfo);
                rowWidth += bounds.width;
                if (endCol != nColumns - 1) {
                    rowWidth += cellSpacing;
                }
                int cellWidth = Math.max(layoutWidth, bounds.width);
                if (cell.m_rowSpan == 1) {
                    rowHeight = Math.max(rowHeight, bounds.height);
                }
            }
            ++i;
        }
        this.m_bounds = new Rectangle(x, y, rowWidth, rowHeight);
        return this.m_bounds;
    }

    protected void makeChildren(ViewFactory factory) {
        Element elem = this.m_elem;
        int nCount = elem.getElementCount();
        Vector<TableCell> temp = new Vector<TableCell>();
        int tableColumn = 0;
        int i = 0;
        while (i < nCount) {
            Element childElement = elem.getElementAt(i);
            int type = childElement.getType();
            if (type == 5 || type == 4) {
                TableCell cell = new TableCell(this, this.m_tableView, childElement, this.m_container);
                cell.setTableColumns(tableColumn);
                tableColumn += cell.m_colSpan;
                temp.addElement(cell);
            }
            ++i;
        }
        this.m_children = new View[temp.size()];
        temp.copyInto(this.m_children);
        int i2 = 0;
        while (i2 < this.m_children.length) {
            this.m_children[i2].makeChildren(factory);
            ++i2;
        }
    }

    protected View modelToView(int pos) {
        if (pos >= this.m_elem.m_p0 && pos <= this.m_elem.m_p1) {
            return this;
        }
        int i = 0;
        while (i < this.m_children.length) {
            View v = this.m_children[i].modelToView(pos);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    protected void move(int x, int y, boolean bMoveFloaters) {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].move(x, y, bMoveFloaters);
            ++i;
        }
        if (this.m_cellBorders != null) {
            int i2 = 0;
            while (i2 < this.m_cellBorders.length) {
                this.m_cellBorders[i2].x += x;
                this.m_cellBorders[i2].y += y;
                ++i2;
            }
        }
        this.m_bounds.x += x;
        this.m_bounds.y += y;
    }

    protected boolean occupies(int row, int col) {
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            if (cell.occupies(row, col)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int pageBreakAdjust(LayoutInfo info) {
        Rectangle origBounds = new Rectangle(this.m_bounds);
        int maxCellHeight = 0;
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            cell.pageBreakAdjust(info);
            maxCellHeight = Math.max(maxCellHeight, cell.m_cellBounds.height);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i2];
            if (maxCellHeight > cell.m_cellBounds.height) {
                cell.increaseHeight(maxCellHeight - cell.m_cellBounds.height);
            }
            ++i2;
        }
        this.m_bounds.height = maxCellHeight;
        this.computeCellBorders();
        return this.m_bounds.height - origBounds.height;
    }

    public void paint(Graphics g, Shape alloc) {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].paint(g, alloc);
            ++i;
        }
        this.paintCellBorders(g);
    }

    protected void paintCellBorders(Graphics g) {
        if (this.m_cellBorders != null && this.m_tableView.m_borderSize > 0) {
            Color oldColor = g.getColor();
            int i = 0;
            while (i < this.m_cellBorders.length) {
                CellBorder r = this.m_cellBorders[i];
                if (r != null && r.bPaint) {
                    g.setColor(Utilities.getDarkBorderColor());
                    g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
                    g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                    g.setColor(Utilities.getBrightBorderColor());
                    g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
                    g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
                }
                ++i;
            }
            g.setColor(oldColor);
        }
    }

    protected void paintFocusBox(Graphics g, Shape alloc) {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].paintFocusBox(g, alloc);
            ++i;
        }
    }

    protected int[] setCellHeights(int[] rowHeights, LayoutInfo info) {
        int i = 0;
        while (i < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i];
            int cellHeight = cell.getBounds().height;
            int rowspan = cell.m_rowSpan;
            if (rowspan > 1) {
                int targetHeight = 0;
                int j = cell.m_startRow;
                while (j <= cell.m_endRow) {
                    targetHeight += rowHeights[j];
                    ++j;
                }
                int cellSpacing = this.m_tableView.m_cellSpacing;
                int startRow = cell.m_startRow;
                int endRow = cell.m_endRow;
                int nDefinedRows = this.m_tableView.m_nDefinedRows;
                if (startRow < nDefinedRows - 1 && endRow >= nDefinedRows - 1) {
                    int nValidRowsSpanned = nDefinedRows - startRow;
                    if (nValidRowsSpanned > 0 && cellSpacing > 0) {
                        targetHeight += (nValidRowsSpanned - 1) * cellSpacing;
                    }
                } else if (cellSpacing > 0) {
                    targetHeight += (cell.m_rowSpan - 1) * cellSpacing;
                }
                if (targetHeight > cellHeight) {
                    cell.increaseHeight(targetHeight - cellHeight);
                }
            } else {
                int rowHeight = rowHeights[cell.m_startRow];
                if (rowHeight > cellHeight) {
                    cell.increaseHeight(rowHeight - cellHeight);
                }
            }
            ++i;
        }
        int[] rowHeightAdjustments = new int[rowHeights.length];
        int maxCellHeight = 0;
        int i2 = 0;
        while (i2 < this.m_children.length) {
            TableCell cell = (TableCell)this.m_children[i2];
            int pagingAdjustment = cell.doCellVerticalAlignment(info);
            maxCellHeight = Math.max(maxCellHeight, cell.getBounds().height);
            if (pagingAdjustment > 0) {
                int j;
                this.m_tableView.increasePreviousCellHeights(this, pagingAdjustment);
                int[] rowHeightValues = new int[rowHeights.length];
                int space = pagingAdjustment;
                while (space > 0) {
                    j = cell.m_startRow;
                    while (j <= cell.m_endRow && space > 0) {
                        int n = j++;
                        rowHeightValues[n] = rowHeightValues[n] + 1;
                        --space;
                    }
                }
                j = cell.m_startRow;
                while (j <= cell.m_endRow) {
                    rowHeightAdjustments[j] = Math.max(rowHeightAdjustments[j], rowHeightValues[j]);
                    ++j;
                }
            }
            ++i2;
        }
        int row = 0;
        while (row < rowHeightAdjustments.length) {
            if (rowHeightAdjustments[row] > 0) {
                int n = row;
                rowHeights[n] = rowHeights[n] + rowHeightAdjustments[row];
                TableRow rv = this.m_tableView.getRow(row + 1);
                if (rv != null) {
                    this.m_tableView.moveRows(rowHeightAdjustments[row], rv);
                }
            }
            ++row;
        }
        return rowHeights;
    }

    protected ElementViewInfo viewToModel(int x, int y) {
        ElementViewInfo info = null;
        int i = 0;
        while (i < this.m_children.length) {
            if (this.m_children[i].contains(x, y) && (info = this.m_children[i].viewToModel(x, y)) != null) break;
            ++i;
        }
        return info;
    }

    class CellBorder
    extends Rectangle {
        boolean bPaint;

        CellBorder() {
        }
    }
}

