/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.Utilities;
import horst.parser.Tag;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;

public class TextAttributes {
    static Color defaultColor;
    Color color;
    Color focusColor = Color.red;
    String href;
    String target;
    boolean bUnderline = false;
    Font font;
    Tag lastTag;
    private Hashtable atts = new Hashtable();
    private static Hashtable fontMapping;
    private static int downSizeIncrement;
    private static int upSizeIncrement;

    TextAttributes(TextAttributes copy) {
        Font copyFont = copy.font;
        this.font = new Font(copyFont.getName(), copyFont.getStyle(), copyFont.getSize());
        Hashtable ht = copy.atts;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.atts.get(key);
            if (value != null) {
                this.atts.put(key, value);
                continue;
            }
            this.atts.put(key, new String(""));
        }
        this.bUnderline = copy.bUnderline;
        this.color = copy.color;
        this.focusColor = copy.focusColor;
        this.href = copy.href;
    }

    public TextAttributes(Font defFont) {
        this.font = defFont;
        int defaultSize = this.font.getSize();
        this.color = defaultColor;
        fontMapping.put("1", new Integer(defaultSize - 2 * downSizeIncrement));
        fontMapping.put("2", new Integer(defaultSize - downSizeIncrement));
        fontMapping.put("3", new Integer(defaultSize));
        fontMapping.put("4", new Integer(defaultSize + upSizeIncrement));
        fontMapping.put("5", new Integer(defaultSize + 2 * upSizeIncrement));
        fontMapping.put("6", new Integer(defaultSize + 3 * upSizeIncrement));
        fontMapping.put("7", new Integer(defaultSize + 4 * upSizeIncrement));
    }

    static Font createFont(Font f, String sz) {
        int size = TextAttributes.getFontSize(f.getSize(), sz);
        return new Font(f.getName(), f.getStyle(), size);
    }

    static int getFontSize(int origSize, String size) {
        int idx = (size = size.trim()).indexOf(43);
        if (idx != -1) {
            String val = size.substring(idx + 1);
            Integer i = Utilities.getInteger(val);
            if (i != null) {
                return origSize + i * upSizeIncrement;
            }
        } else {
            idx = size.indexOf(45);
            if (idx != -1) {
                Integer smallestSize = (Integer)fontMapping.get("1");
                String val = size.substring(idx + 1);
                Integer i = Utilities.getInteger(val);
                if (i != null) {
                    int sz = origSize - i * downSizeIncrement;
                    if (sz < smallestSize) {
                        return smallestSize;
                    }
                    return sz;
                }
            } else {
                Integer val = (Integer)fontMapping.get(size);
                if (val != null) {
                    return val;
                }
            }
        }
        return origSize;
    }

    void multiplexAttributes(Element elem) {
        elem.setAttribute("color", this.color);
        elem.m_focusColor = this.focusColor;
        String value = (String)elem.getAttribute("underline");
        if (value == null || value.equals("false")) {
            value = this.bUnderline ? "true" : "false";
            elem.setAttribute("underline", value);
        }
        Enumeration e = this.atts.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            value = (String)this.atts.get(key);
            if (value == null || elem.getAttribute(key) != null) continue;
            elem.setAttribute(key, value);
        }
        if (this.href != null && this.href.length() > 0 && elem.getAttribute("href") == null) {
            elem.setAttribute("href", this.href);
        }
        if (this.target != null) {
            elem.setAttribute("target", this.target);
        }
    }

    void setAttribute(String key, Object value) {
        this.atts.put(key, value);
    }

    static {
        fontMapping = new Hashtable();
        defaultColor = Color.black;
        downSizeIncrement = 2;
        upSizeIncrement = 4;
    }
}

