/*
 * Decompiled with CFR 0.152.
 */
package jxeplugins;

import JWVFile.VFile;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;

public class DocumentPosition
implements Serializable {
    public int line;
    public int col;
    public int lineEnd;
    public int colEnd;
    public String path;

    public DocumentPosition(String _path, int _line, int _col, int _len) {
        this.path = _path;
        this.line = _line;
        this.col = _col;
        this.lineEnd = _line;
        this.colEnd = _col + _len;
    }

    public DocumentPosition(String _path, int _line, int _col, int _lineEnd, int _colEnd) {
        this.path = _path;
        this.line = _line;
        this.col = _col;
        this.lineEnd = _lineEnd;
        this.colEnd = _colEnd;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public DocumentPosition() {
    }

    public void loadProperty(DataInputStream dos) throws Exception {
        this.col = dos.readInt();
        this.colEnd = dos.readInt();
        this.line = dos.readInt();
        this.lineEnd = dos.readInt();
        this.path = dos.readUTF();
    }

    public void setLen(int le) {
        this.lineEnd = this.line;
        this.colEnd = this.col + le;
    }

    public static DocumentPosition ExtractFromStackTrace(EditApp app, String toParse0, int len, String workingDir) {
        String toParse = toParse0;
        try {
            int i = toParse.indexOf("(");
            if (i < 0) {
                return null;
            }
            toParse = toParse.substring(i + 1);
            String file2 = toParse.substring(0, toParse.indexOf(58));
            toParse = toParse.substring(file2.length() + 1, toParse.lastIndexOf(41));
            String fqClazz = toParse0.substring(toParse0.lastIndexOf(32) + 1, toParse0.lastIndexOf(46)).trim();
            fqClazz = fqClazz.substring(0, fqClazz.lastIndexOf(46));
            fqClazz = fqClazz.substring(0, fqClazz.lastIndexOf(46));
            fqClazz = fqClazz + "." + file2.subSequence(0, file2.length() - ".java".length());
            File f = NCFileUtilities.SourcepathLookUp(AJCompileAndBuild.This.getDebugSourcePath(), fqClazz);
            if (f != null) {
                DocumentPosition dp = new DocumentPosition(f.getAbsolutePath(), Integer.parseInt(toParse), 0, Integer.parseInt(toParse) + 1, 0);
                return dp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static String DeRelativePath(EditApp app, String workingDir, String file2) {
        Tracer.This.println("DeRelativePath INIT:" + workingDir + ", " + file2);
        if (new File(file2).exists()) {
            return file2;
        }
        String itPath = VFile.RemoveLast(workingDir + File.separator + file2);
        String tmpFile = VFile.NameWithExtension(file2);
        while (true) {
            Tracer.This.println("DeRelativePath:" + itPath + "\\" + file2);
            try {
                String s = itPath + File.separator + tmpFile;
                while (s.startsWith("\\\\")) {
                    s = s.substring(1);
                }
                File candidate = new File(s);
                if (candidate.exists()) {
                    return candidate.getAbsolutePath();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (itPath.indexOf(File.separator) < 0) break;
            itPath = VFile.RemoveLast(itPath);
        }
        return file2;
    }

    public static DocumentPosition ExtractFromJvcOutput(EditApp app, String toParse, int len, String workingDir) {
        try {
            int i = toParse.indexOf("(");
            if (i < 0) {
                return null;
            }
            String file2 = toParse.substring(0, i);
            if ((i = (toParse = toParse.substring(i + 1)).indexOf(",")) < 0) {
                return null;
            }
            toParse = toParse.substring(0, i);
            if ((file2 = DocumentPosition.DeRelativePath(app, workingDir, file2)) == null) {
                return null;
            }
            DocumentPosition dp = new DocumentPosition(file2, Integer.parseInt(toParse), 0, Integer.parseInt(toParse) + 1, 0);
            return dp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DocumentPosition ExtractFromJavacOutput(EditApp app, String toParse, int len, String workingDir) {
        block11: {
            if ((toParse = toParse.trim()).startsWith("[javac]")) {
                toParse = toParse.substring(toParse.indexOf("[javac]") + 7);
                toParse = toParse.trim();
            }
            try {
                int fromIndex = 0;
                DocumentPosition result = null;
                while (fromIndex >= 0 && fromIndex < toParse.length()) {
                    if ((fromIndex = toParse.indexOf(58, fromIndex + 1)) == -1) break;
                    File file2 = new File(toParse.substring(0, fromIndex).replace('/', File.separatorChar));
                    if (!file2.canRead() || !file2.isFile()) continue;
                    try {
                        result = new DocumentPosition();
                        result.path = file2.getAbsolutePath();
                        result.line = Integer.parseInt(toParse.substring(result.path.length() + 1, toParse.indexOf(58, fromIndex + 1)));
                        fromIndex = toParse.indexOf(58, fromIndex + 1);
                        result.col = 0;
                    }
                    catch (Exception e) {
                        NCApplication.Pln(toParse.substring(result.path.length() + 1, toParse.indexOf(58, fromIndex + 1)));
                        break;
                    }
                    result.setLen(len);
                    return result;
                }
                if (toParse.length() <= 2) break block11;
                try {
                    int i = toParse.indexOf(58, 2);
                    if (i >= 0) {
                        String path = toParse.substring(0, i);
                        if ((path = DocumentPosition.DeRelativePath(app, workingDir, path)) != null) {
                            result = new DocumentPosition();
                            result.path = path;
                            result.col = 0;
                            int secDP = toParse.indexOf(58, i + 1);
                            result.line = Integer.parseInt(toParse.substring(i + 1, secDP));
                            result.setLen(1024);
                            return result;
                        }
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        if (toParse.indexOf(" - ") >= 0) {
            return DocumentPosition.ExtractFromJavacOutput(app, toParse.substring(toParse.indexOf(" - ") + 3), len, workingDir);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentPosition) {
            DocumentPosition dp = (DocumentPosition)o;
            return dp.col == this.col && dp.line == this.line && dp.path.equals(this.path);
        }
        return false;
    }
}

