/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ConstantValueAttribute;
import koala.dynamicjava.classfile.JVMUtilities;

public class FieldInfo
extends AttributeOwnerComponent {
    private short descriptorIndex;

    public FieldInfo(ConstantPool constantPool, String string, String string2) {
        this.constantPool = constantPool;
        this.nameIndex = this.constantPool.putUTF8(string2);
        this.descriptorIndex = this.constantPool.putUTF8(JVMUtilities.getReturnTypeName(string));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.descriptorIndex);
        dataOutputStream.writeShort(this.attributes.size());
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            ((AttributeInfo)iterator.next()).write(dataOutputStream);
        }
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setPrivate() {
        this.accessFlags = (short)(this.accessFlags | 2);
    }

    public void setProtected() {
        this.accessFlags = (short)(this.accessFlags | 4);
    }

    public void setStatic() {
        this.accessFlags = (short)(this.accessFlags | 8);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setVolatile() {
        this.accessFlags = (short)(this.accessFlags | 0x40);
    }

    public void setTransient() {
        this.accessFlags = (short)(this.accessFlags | 0x80);
    }

    public void setConstantValueAttribute(Integer n) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, n));
    }

    public void setConstantValueAttribute(Long l) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, l));
    }

    public void setConstantValueAttribute(Float f) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, f));
    }

    public void setConstantValueAttribute(Double d) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, d));
    }

    public void setConstantValueAttribute(String string) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, string));
    }
}

