/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.InnerClassesEntry;

public class InnerClassesAttribute
extends AttributeInfo {
    private List classes;

    public InnerClassesAttribute(ConstantPool constantPool) {
        super(constantPool, "InnerClasses");
        this.length = 2;
        this.classes = new LinkedList();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeInt(this.length);
        dataOutputStream.writeShort(this.classes.size());
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ((InnerClassesEntry)iterator.next()).write(dataOutputStream);
        }
    }

    public InnerClassesEntry addInnerClassesEntry() {
        InnerClassesEntry innerClassesEntry = new InnerClassesEntry(this.constantPool);
        this.classes.add(innerClassesEntry);
        this.length += 8;
        return innerClassesEntry;
    }
}

