/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TreeConstructorInfo;
import koala.dynamicjava.classinfo.TreeFieldInfo;
import koala.dynamicjava.classinfo.TreeMethodInfo;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class TreeClassInfo
implements ClassInfo {
    private static final String DECLARING_CLASS = "declaringClass";
    public static final String ANONYMOUS_DECLARING_CLASS = "anonymousDeclaringClass";
    private static final String TREE_VISITED = "treeVisited";
    private TypeDeclaration classTree;
    private ClassFinder classFinder;
    private int dimension;
    private String name;
    private ClassInfo superclass;
    private boolean interfaceInfo;
    private ClassInfo[] interfaces;
    private Map fields = new HashMap();
    private Map methods = new HashMap();
    private List constructors = new LinkedList();
    private List classes = new LinkedList();
    private boolean compilable = true;
    private int methodCount;

    public TreeClassInfo(TypeDeclaration typeDeclaration, ClassFinder classFinder) {
        this.classFinder = classFinder;
        this.classTree = typeDeclaration;
        this.name = this.fullName();
        this.interfaceInfo = typeDeclaration instanceof InterfaceDeclaration;
        new MembersVisitor();
        this.classTree.setProperty(TREE_VISITED, null);
    }

    public TreeClassInfo(TreeClassInfo treeClassInfo) {
        this.classFinder = treeClassInfo.classFinder;
        this.classTree = treeClassInfo.classTree;
        this.dimension = treeClassInfo.dimension + 1;
        this.name = "[" + (treeClassInfo.isArray() ? treeClassInfo.getName() : "L" + treeClassInfo.getName() + ";");
        new MembersVisitor();
    }

    public Class getJavaClass() {
        throw new IllegalStateException();
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.classTree;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public boolean isCompilable() {
        return this.compilable;
    }

    public void setCompilable(boolean bl) {
        this.compilable = bl;
    }

    public ClassInfo getDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(DECLARING_CLASS) : null;
    }

    public ClassInfo getAnonymousDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(ANONYMOUS_DECLARING_CLASS) : null;
    }

    public int getModifiers() {
        return this.dimension == 0 ? this.classTree.getAccessFlags() : 1;
    }

    public String getName() {
        return this.name;
    }

    public ClassInfo getSuperclass() {
        if (this.superclass == null) {
            if (this.interfaceInfo) {
                this.superclass = this.lookupClass("java.lang.Object");
            } else {
                ClassDeclaration classDeclaration = (ClassDeclaration)this.classTree;
                this.superclass = this.lookupClass(classDeclaration.getSuperclass(), this.getDeclaringClass());
            }
        }
        return this.superclass;
    }

    public ClassInfo[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.dimension > 0) {
                this.interfaces = new ClassInfo[]{this.lookupClass("java.lang.Cloneable"), this.lookupClass("java.io.Serializable")};
            } else {
                List list = this.classTree.getInterfaces();
                if (list != null) {
                    this.interfaces = new ClassInfo[list.size()];
                    Iterator iterator = list.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        this.interfaces[n++] = this.lookupClass(string, this.getDeclaringClass());
                    }
                } else {
                    this.interfaces = new ClassInfo[0];
                }
            }
        }
        return (ClassInfo[])this.interfaces.clone();
    }

    public FieldInfo getField(FieldDeclaration fieldDeclaration) {
        return (TreeFieldInfo)this.fields.get(fieldDeclaration.getName());
    }

    public FieldInfo[] getFields() {
        if (this.dimension == 0) {
            Set set = this.fields.keySet();
            Iterator iterator = set.iterator();
            FieldInfo[] fieldInfoArray = new FieldInfo[set.size()];
            int n = 0;
            while (iterator.hasNext()) {
                fieldInfoArray[n++] = (FieldInfo)this.fields.get(iterator.next());
            }
            return fieldInfoArray;
        }
        return new FieldInfo[0];
    }

    public ConstructorInfo[] getConstructors() {
        if (this.dimension == 0) {
            Iterator iterator = this.constructors.iterator();
            ConstructorInfo[] constructorInfoArray = new ConstructorInfo[this.constructors.size()];
            int n = 0;
            while (iterator.hasNext()) {
                constructorInfoArray[n++] = (ConstructorInfo)iterator.next();
            }
            return constructorInfoArray;
        }
        return new ConstructorInfo[0];
    }

    public MethodInfo getMethod(MethodDeclaration methodDeclaration) {
        Set set = this.methods.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            List list = (List)this.methods.get(iterator.next());
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TreeMethodInfo treeMethodInfo = (TreeMethodInfo)iterator2.next();
                if (treeMethodInfo.getMethodDeclaration() != methodDeclaration) continue;
                return treeMethodInfo;
            }
        }
        throw new IllegalArgumentException();
    }

    public MethodInfo[] getMethods() {
        if (this.dimension == 0) {
            MethodInfo[] methodInfoArray = new MethodInfo[this.methodCount];
            Iterator iterator = this.methods.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    methodInfoArray[n++] = (MethodInfo)iterator2.next();
                }
            }
            return methodInfoArray;
        }
        return new MethodInfo[0];
    }

    public ClassInfo[] getDeclaredClasses() {
        if (this.dimension == 0) {
            Iterator iterator = this.classes.iterator();
            ClassInfo[] classInfoArray = new ClassInfo[this.classes.size()];
            int n = 0;
            while (iterator.hasNext()) {
                classInfoArray[n++] = (ClassInfo)iterator.next();
            }
            return classInfoArray;
        }
        return new ClassInfo[0];
    }

    public ClassInfo getArrayType() {
        return new TreeClassInfo(this);
    }

    public boolean isInterface() {
        return this.classTree instanceof InterfaceDeclaration;
    }

    public boolean isArray() {
        return this.dimension > 0;
    }

    public boolean isPrimitive() {
        return false;
    }

    public ClassInfo getComponentType() {
        if (!this.isArray()) {
            throw new IllegalStateException();
        }
        TreeClassInfo treeClassInfo = new TreeClassInfo(this.classTree, this.classFinder);
        int n = 0;
        while (n < this.dimension - 1) {
            treeClassInfo = new TreeClassInfo(treeClassInfo);
            ++n;
        }
        return treeClassInfo;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClassInfo)) {
            return false;
        }
        return this.getName().equals(((ClassInfo)object).getName());
    }

    private String fullName() {
        String string;
        ClassInfo classInfo = (ClassInfo)this.classTree.getProperty(DECLARING_CLASS);
        if (classInfo != null) {
            string = classInfo.getName() + "$";
        } else {
            string = this.classFinder.getCurrentPackage();
            if (!string.equals("")) {
                string = string + ".";
            }
        }
        return string + this.classTree.getName();
    }

    private ClassInfo lookupClass(String string) {
        try {
            return this.classFinder.lookupClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ClassInfo lookupClass(String string, ClassInfo classInfo) {
        try {
            if (classInfo != null) {
                return this.classFinder.lookupClass(string, classInfo);
            }
            return this.classFinder.lookupClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int getNestingLevel() {
        int n = -1;
        ClassInfo classInfo = this;
        while (!Modifier.isStatic(classInfo.getModifiers()) && (classInfo = classInfo.getDeclaringClass()) != null) {
            ++n;
        }
        return n;
    }

    private class MembersVisitor
    extends VisitorObject {
        MembersVisitor() {
            if (!TreeClassInfo.this.isArray()) {
                Iterator iterator = TreeClassInfo.this.classTree.getMembers().iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).acceptVisitor(this);
                }
                if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED)) {
                    Node node;
                    ClassInfo classInfo = TreeClassInfo.this.getDeclaringClass();
                    if (classInfo != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                        node = new FieldDeclaration(1, new ReferenceType(classInfo.getName()), "this$" + TreeClassInfo.this.getNestingLevel(), null);
                        ((FieldDeclaration)node).acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(node);
                    }
                    if (TreeClassInfo.this.constructors.size() == 0 && !TreeClassInfo.this.isInterface() && !TreeClassInfo.this.isPrimitive()) {
                        node = new ConstructorInvocation(null, null, true);
                        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(1, TreeClassInfo.this.classTree.getName(), new LinkedList(), new LinkedList(), (ConstructorInvocation)node, new LinkedList());
                        constructorDeclaration.acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(constructorDeclaration);
                    }
                }
            }
        }

        public Object visit(ClassDeclaration classDeclaration) {
            classDeclaration.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(TreeClassInfo.this.getName() + "$" + classDeclaration.getName(), classDeclaration));
            return null;
        }

        public Object visit(InterfaceDeclaration interfaceDeclaration) {
            interfaceDeclaration.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(TreeClassInfo.this.getName() + "$" + interfaceDeclaration.getName(), interfaceDeclaration));
            return null;
        }

        public Object visit(FieldDeclaration fieldDeclaration) {
            TreeClassInfo.this.fields.put(fieldDeclaration.getName(), new TreeFieldInfo(fieldDeclaration, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        public Object visit(ConstructorDeclaration constructorDeclaration) {
            Node node;
            Object object;
            if (constructorDeclaration.getConstructorInvocation() == null) {
                object = new ConstructorInvocation(null, null, true);
                constructorDeclaration.setConstructorInvocation((ConstructorInvocation)object);
            }
            object = TreeClassInfo.this.getDeclaringClass();
            if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED) && object != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                node = new ReferenceType(object.getName());
                constructorDeclaration.getParameters().add(0, new FormalParameter(false, (Type)node, "param$0"));
            }
            if (object != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                LinkedList<Identifier> linkedList = new LinkedList<Identifier>();
                linkedList.add(new Identifier("this$" + TreeClassInfo.this.getNestingLevel()));
                LinkedList<Identifier> linkedList2 = new LinkedList<Identifier>();
                linkedList2.add(new Identifier("param$0"));
                node = new SimpleAssignExpression(new QualifiedName(linkedList), new QualifiedName(linkedList2));
                constructorDeclaration.getStatements().add(0, node);
            }
            TreeClassInfo.this.constructors.add(new TreeConstructorInfo(constructorDeclaration, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        public Object visit(MethodDeclaration methodDeclaration) {
            LinkedList<TreeMethodInfo> linkedList = (LinkedList<TreeMethodInfo>)TreeClassInfo.this.methods.get(methodDeclaration.getName());
            if (linkedList == null) {
                linkedList = new LinkedList<TreeMethodInfo>();
            }
            linkedList.add(new TreeMethodInfo(methodDeclaration, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            TreeClassInfo.this.methods.put(methodDeclaration.getName(), linkedList);
            TreeClassInfo.this.methodCount++;
            return null;
        }
    }
}

