/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import koala.dynamicjava.gui.Editor;
import koala.dynamicjava.gui.JTextComponentOutputStream;
import koala.dynamicjava.gui.OptionsDialog;
import koala.dynamicjava.gui.StatusBar;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MenuFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;
import koala.dynamicjava.gui.resource.ToolBarFactory;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;

public class Main
extends JFrame
implements ActionMap {
    public static final String OPEN_ACTION = "OpenAction";
    public static final String SAVE_ACTION = "SaveAction";
    public static final String SAVE_AS_ACTION = "SaveAsAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String UNDO_ACTION = "UndoAction";
    public static final String REDO_ACTION = "RedoAction";
    public static final String CUT_ACTION = "CutAction";
    public static final String COPY_ACTION = "CopyAction";
    public static final String PASTE_ACTION = "PasteAction";
    public static final String CLEAR_ACTION = "ClearAction";
    public static final String OPTIONS_ACTION = "OptionsAction";
    public static final String EVAL_ACTION = "EvalAction";
    public static final String EVAL_S_ACTION = "EvalSAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String REINIT_ACTION = "ReinitAction";
    public static final String ABOUT_ACTION = "AboutAction";
    protected static int instances;
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.main";
    protected static ResourceBundle bundle;
    protected static ResourceManager rManager;
    protected Editor editor;
    protected JTextArea output;
    protected BoundedRangeModel scrollBarModel;
    protected StatusBar status;
    protected OptionsDialog options;
    protected Interpreter interpreter;
    protected int selectionStart;
    protected int selectionEnd;
    protected EvalAction evalAction;
    protected EvalSelectionAction evalSelection;
    protected StopAction stopAction;
    protected Thread thread;
    protected boolean isRunning;
    protected OptionsDialog.OptionSet optionSet;
    protected PrintStream textComponentStream;
    protected PrintStream out;
    protected PrintStream err;
    protected Map listeners;

    public static void main(String[] stringArray) {
        new Main().show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Main() {
        block11: {
            Object object;
            this.selectionStart = -1;
            this.selectionEnd = -1;
            this.evalAction = new EvalAction();
            this.evalSelection = new EvalSelectionAction();
            this.stopAction = new StopAction();
            this.out = System.out;
            this.err = System.err;
            this.listeners = new HashMap();
            ++instances;
            this.setTitle(rManager.getString("Frame.title"));
            ((Component)this).setSize(rManager.getInteger("Frame.width"), rManager.getInteger("Frame.height"));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Main.this.exit();
                }
            });
            this.status = new StatusBar(rManager);
            this.getContentPane().add("South", this.status);
            JScrollPane jScrollPane = new JScrollPane();
            this.editor = new Editor(this.status);
            jScrollPane.getViewport().add(this.editor);
            jScrollPane.setVerticalScrollBarPolicy(22);
            this.editor.addCaretListener(new EditorCaretListener());
            JScrollPane jScrollPane2 = new JScrollPane();
            this.output = new JTextArea();
            jScrollPane2.getViewport().add(this.output);
            jScrollPane2.setVerticalScrollBarPolicy(22);
            this.scrollBarModel = jScrollPane2.getVerticalScrollBar().getModel();
            this.scrollBarModel.addChangeListener(new ScrollBarModelChangeListener());
            this.output.setEditable(false);
            this.output.setLineWrap(true);
            this.output.setBackground(Color.lightGray);
            JSplitPane jSplitPane = new JSplitPane(0, true, jScrollPane, jScrollPane2);
            jSplitPane.setDividerLocation(rManager.getInteger("Frame.divider"));
            this.getContentPane().add(jSplitPane);
            this.listeners.put(OPEN_ACTION, this.editor.getAction(OPEN_ACTION));
            this.listeners.put(SAVE_ACTION, this.editor.getAction(SAVE_ACTION));
            this.listeners.put(SAVE_AS_ACTION, this.editor.getAction(SAVE_AS_ACTION));
            this.listeners.put(EXIT_ACTION, new ExitAction());
            this.listeners.put(UNDO_ACTION, this.editor.getAction(UNDO_ACTION));
            this.listeners.put(REDO_ACTION, this.editor.getAction(REDO_ACTION));
            this.listeners.put(CUT_ACTION, this.editor.getAction("cut-to-clipboard"));
            this.listeners.put(COPY_ACTION, this.editor.getAction("copy-to-clipboard"));
            this.listeners.put(PASTE_ACTION, this.editor.getAction("paste-from-clipboard"));
            this.listeners.put(CLEAR_ACTION, new ClearAction());
            this.listeners.put(OPTIONS_ACTION, new OptionsAction());
            this.listeners.put(EVAL_ACTION, this.evalAction);
            this.listeners.put(EVAL_S_ACTION, this.evalSelection);
            this.listeners.put(STOP_ACTION, this.stopAction);
            this.listeners.put(REINIT_ACTION, new ReinitAction());
            this.listeners.put(ABOUT_ACTION, new AboutAction());
            MenuFactory menuFactory = new MenuFactory(bundle, this);
            try {
                this.setJMenuBar(menuFactory.createJMenuBar("MenuBar"));
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException.getMessage());
                System.exit(0);
            }
            ToolBarFactory toolBarFactory = new ToolBarFactory(bundle, this);
            try {
                object = toolBarFactory.createJToolBar("ToolBar");
                ((JToolBar)object).setFloatable(false);
                this.getContentPane().add("North", (Component)object);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException.getMessage());
                System.exit(0);
            }
            this.textComponentStream = new PrintStream(new JTextComponentOutputStream(this.output));
            this.options = new OptionsDialog(this);
            this.loadOptions();
            if (this.options.isStartupInitializationSelected()) {
                this.interpreter = this.createInterpreter();
                this.applyOptions();
                object = this.options.getStartupInitializationFilename();
                InputStreamReader inputStreamReader = null;
                PrintStream printStream = System.out;
                PrintStream printStream2 = System.err;
                System.setOut(this.out);
                System.setErr(this.err);
                try {
                    try {
                        try {
                            inputStreamReader = new InputStreamReader(new URL((String)object).openStream());
                        }
                        catch (Exception exception) {
                            inputStreamReader = new FileReader((String)object);
                        }
                        this.interpreter.interpret(inputStreamReader, (String)object);
                    }
                    catch (Throwable throwable) {
                        JOptionPane.showMessageDialog(this, rManager.getString("InterpreterInitializationError.text") + "\n" + throwable.getMessage(), rManager.getString("InterpreterInitializationError.title"), 0);
                        Object var12_15 = null;
                        System.setOut(printStream);
                        System.setErr(printStream2);
                        break block11;
                    }
                    Object var12_14 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    throw throwable;
                }
                System.setOut(printStream);
                System.setErr(printStream2);
            }
        }
        this.interpreter = this.createInterpreter();
        this.applyOptions();
    }

    public void setOptions(OptionsDialog.OptionSet optionSet) {
        this.options.setOptions(optionSet);
    }

    public OptionsDialog.OptionSet getOptions() {
        return this.options.getOptions();
    }

    public void saveOptions() throws IOException {
        OptionsDialog.OptionSet optionSet = this.options.getOptions();
        String string = System.getProperty("user.home") + "/.djava";
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdir();
        }
        String string2 = System.getProperty("line.separator");
        FileWriter fileWriter = new FileWriter(string + "/options");
        fileWriter.write("// Generated by DynamicJava" + string2);
        fileWriter.write("import koala.dynamicjava.gui.*;" + string2 + string2);
        fileWriter.write("OptionsDialog.OptionSet optionSet = new OptionsDialog.OptionSet();" + string2 + string2);
        fileWriter.write("optionSet.classPath = new String[] { " + string2);
        if (optionSet.classPath.length > 0) {
            fileWriter.write("    " + this.stringToJavaString(optionSet.classPath[0]));
        }
        int n = 1;
        while (n < optionSet.classPath.length) {
            fileWriter.write("," + string2 + "    " + this.stringToJavaString(optionSet.classPath[n]));
            ++n;
        }
        fileWriter.write(" };" + string2 + string2);
        fileWriter.write("optionSet.libraryPath = new String[] { " + string2);
        if (optionSet.libraryPath.length > 0) {
            fileWriter.write("    " + this.stringToJavaString(optionSet.libraryPath[0]));
        }
        int n2 = 1;
        while (n2 < optionSet.libraryPath.length) {
            fileWriter.write("," + string2 + "    " + this.stringToJavaString(optionSet.libraryPath[n2]));
            ++n2;
        }
        fileWriter.write(" };" + string2 + string2);
        fileWriter.write("optionSet.isInterpreterSelected = " + optionSet.isInterpreterSelected + ";" + string2);
        fileWriter.write("optionSet.interpreterName = \"" + optionSet.interpreterName + "\";" + string2 + string2);
        fileWriter.write("optionSet.interpreterFileSelected = " + optionSet.interpreterFileSelected + ";" + string2);
        fileWriter.write("optionSet.interpreterFilename = " + this.stringToJavaString(optionSet.interpreterFilename) + ";" + string2 + string2);
        fileWriter.write("optionSet.isGUISelected = " + optionSet.isGUISelected + ";" + string2);
        fileWriter.write("optionSet.guiName = \"" + optionSet.guiName + "\";" + string2 + string2);
        fileWriter.write("optionSet.isOutputSelected = " + optionSet.isOutputSelected + ";" + string2 + string2);
        fileWriter.write("optionSet.isErrorSelected = " + optionSet.isErrorSelected + ";" + string2 + string2);
        fileWriter.write("optionSet.guiFileSelected = " + optionSet.guiFileSelected + ";" + string2);
        fileWriter.write("optionSet.guiFilename = " + this.stringToJavaString(optionSet.guiFilename) + ";" + string2 + string2);
        fileWriter.write("gui.setOptions(optionSet);" + string2);
        ((Writer)fileWriter).flush();
    }

    protected String stringToJavaString(String string) {
        String string2 = "\"";
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\"': 
                case '\\': {
                    string2 = string2 + "\\" + string.charAt(n);
                    break;
                }
                default: {
                    string2 = string2 + string.charAt(n);
                }
            }
            ++n;
        }
        return string2 + "\"";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadOptions() {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        Interpreter interpreter = this.createInterpreter();
        try {
            block4: {
                try {
                    File file2 = new File(System.getProperty("user.home") + "/.djava/options");
                    if (!file2.exists()) break block4;
                    interpreter.defineVariable("gui", this);
                    interpreter.interpret(new FileReader(file2), "options");
                }
                catch (Throwable throwable) {
                    System.out.println(throwable);
                    Object var6_7 = null;
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    return;
                }
            }
            Object var6_6 = null;
            System.setOut(printStream);
            System.setErr(printStream2);
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            System.setOut(printStream);
            System.setErr(printStream2);
            throw throwable;
        }
    }

    public OptionsDialog getOptionsDialog() {
        return this.options;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public JTextArea getOutputArea() {
        return this.output;
    }

    protected void exit() {
        this.editor.closeProcedure();
        if (--instances == 0) {
            System.exit(0);
        }
    }

    protected void reinitializeInterpreter() {
        this.interpreter = this.createInterpreter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void applyOptions() {
        Object object;
        String[] stringArray = this.options.getClassPath();
        int n = 0;
        while (true) {
            if (n >= stringArray.length) break;
            object = stringArray[n];
            try {
                this.interpreter.addClassURL(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                this.interpreter.addClassPath((String)object);
            }
            ++n;
        }
        object = this.options.getLibraryPath();
        int n2 = 0;
        while (true) {
            if (n2 >= ((String[])object).length) {
                if (this.options.isInterpreterDefined()) {
                    this.interpreter.defineVariable(this.options.getInterpreterName(), this.interpreter);
                }
                if (!this.options.isGUIDefined()) break;
                this.interpreter.defineVariable(this.options.getGUIName(), this);
            }
            this.interpreter.addLibraryPath(object[n2]);
            ++n2;
        }
        this.out = this.options.isOutputSelected() ? this.textComponentStream : System.out;
        this.err = this.options.isErrorSelected() ? this.textComponentStream : System.err;
        if (!this.options.isInitializationSelected()) return;
        String string = this.options.getInitializationFilename();
        InputStreamReader inputStreamReader = null;
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        try {
            try {
                try {
                    inputStreamReader = new InputStreamReader(new URL(string).openStream());
                }
                catch (Exception exception) {
                    inputStreamReader = new FileReader(string);
                }
                this.interpreter.interpret(inputStreamReader, string);
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, rManager.getString("InterpreterInitializationError.text") + "\n" + throwable.getMessage(), rManager.getString("InterpreterInitializationError.title"), 0);
                Object var11_13 = null;
                System.setOut(printStream2);
                System.setErr(printStream3);
                return;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            System.setOut(printStream2);
            System.setErr(printStream3);
            throw throwable;
        }
        System.setOut(printStream2);
        System.setErr(printStream3);
    }

    protected int getCurrentLine(int n) {
        String string = this.editor.getText();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '\n') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected void restoreOptions() {
        this.options.setOptions(this.optionSet);
    }

    protected Interpreter createInterpreter() {
        TreeInterpreter treeInterpreter = new TreeInterpreter(new JavaCCParserFactory());
        treeInterpreter.addLibrarySuffix(".java");
        return treeInterpreter;
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    static {
        bundle = ResourceBundle.getBundle(RESOURCE, Locale.getDefault());
        rManager = new ResourceManager(bundle);
    }

    protected class ScrollBarModelChangeListener
    implements ChangeListener {
        int oldMax;

        protected ScrollBarModelChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.oldMax != Main.this.scrollBarModel.getMaximum()) {
                this.oldMax = Main.this.scrollBarModel.getMaximum();
                Main.this.scrollBarModel.setValue(this.oldMax);
            }
        }
    }

    protected class EditorCaretListener
    implements CaretListener {
        protected EditorCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            Main.this.status.setLine(Main.this.getCurrentLine(n));
            if (n != n2) {
                if (n > n2) {
                    int n3 = n2;
                    n2 = n;
                    n = n3;
                }
                Main.this.selectionStart = n;
                Main.this.selectionEnd = n2;
            } else {
                Main.this.selectionStart = -1;
                Main.this.selectionEnd = -1;
            }
            Main.this.evalSelection.update();
        }
    }

    protected class AboutAction
    extends AbstractAction {
        protected AboutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(Main.this, bundle.getString("AboutMessage"));
        }
    }

    protected class ReinitAction
    extends AbstractAction {
        protected ReinitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.reinitializeInterpreter();
            Main.this.applyOptions();
            Main.this.status.setMessage("Status.interpreter.reinitialized");
        }
    }

    protected class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        protected StopAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.thread.stop();
            Main.this.isRunning = false;
            this.update();
            Main.this.evalAction.update();
            Main.this.evalSelection.update();
            Main.this.status.setMessage("Status.evaluation.stopped");
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(Main.this.isRunning);
            }
        }
    }

    protected class EvalSelectionAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        protected EvalSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Main.this.editor.getSelectedText();
            if (string != null) {
                StringReader stringReader = new StringReader(string);
                Main.this.thread = new InterpreterThread(stringReader);
                Main.this.thread.start();
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(Main.this.selectionStart != -1 && !Main.this.isRunning);
            }
        }
    }

    protected class InterpreterThread
    extends Thread {
        Reader reader;

        InterpreterThread(Reader reader) {
            this.reader = reader;
            this.setPriority(1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ThreadDeath threadDeath;
            block7: {
                threadDeath = null;
                PrintStream printStream = System.out;
                PrintStream printStream2 = System.err;
                System.setOut(Main.this.out);
                System.setErr(Main.this.err);
                try {
                    try {
                        Main.this.isRunning = true;
                        Main.this.stopAction.update();
                        Main.this.evalAction.update();
                        Main.this.evalSelection.update();
                        Main.this.output.append("==> " + Main.this.interpreter.interpret(this.reader, "buffer") + "\n");
                    }
                    catch (InterpreterException interpreterException) {
                        Main.this.output.append(" *** " + interpreterException.getMessage() + "\n");
                        Object var8_5 = null;
                        System.setOut(printStream);
                        System.setErr(printStream2);
                        break block7;
                    }
                    catch (ThreadDeath threadDeath2) {
                        threadDeath = threadDeath2;
                        Object var8_6 = null;
                        System.setOut(printStream);
                        System.setErr(printStream2);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Main.this.output.append(throwable + "\n");
                        Object var8_7 = null;
                        System.setOut(printStream);
                        System.setErr(printStream2);
                        break block7;
                    }
                    Object var8_4 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    throw throwable;
                }
                System.setOut(printStream);
                System.setErr(printStream2);
            }
            Main.this.isRunning = false;
            Main.this.stopAction.update();
            Main.this.evalAction.update();
            Main.this.evalSelection.update();
            if (threadDeath != null) {
                throw threadDeath;
            }
        }
    }

    protected class EvalAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        protected EvalAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringReader stringReader = new StringReader(Main.this.editor.getText());
            Main.this.thread = new InterpreterThread(stringReader);
            Main.this.thread.start();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(true);
        }

        protected void update() {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(!Main.this.isRunning);
            }
        }
    }

    protected class OptionsAction
    extends AbstractAction {
        protected OptionsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.optionSet = Main.this.options.getOptions();
            Rectangle rectangle = Main.this.getBounds();
            Dimension dimension = Main.this.options.getSize();
            ((Component)Main.this.options).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            Main.this.options.show();
        }
    }

    protected class ClearAction
    extends AbstractAction {
        protected ClearAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.output.setText("");
        }
    }

    protected class ExitAction
    extends AbstractAction {
        protected ExitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.this.exit();
        }
    }
}

