/*
 * Decompiled with CFR 0.152.
 */
package layedit.swing;

import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.ObjectValue;
import de.netcomputing.util.Tracer;
import editapp.JServiceMenuItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import layedit.LayoutController;
import layedit.LayoutableComponent;
import layedit.LayoutableContainer;
import layedit.swing.BopComponent;
import layedit.swing.BopContainer;

public class BopSwingRoot
extends JPanel {
    JRootPane rootPane = new JRootPane();
    protected BopContainer bopRoot;
    protected JPopupMenu pop;
    public Dimension buffered;
    public static boolean IsPrinting = false;
    PageFormat pageFormat;
    static BopComponent lastDown = null;
    AffineTransform trans;
    float scale;
    float printRatio = 0.7f;

    public Binder binder() {
        return this.bopRoot.getControllerBop().binder();
    }

    public void setRootPane(JRootPane rootPane) {
        this.rootPane = rootPane;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public void setBopRoot(BopContainer bopRoot) {
        this.bopRoot = bopRoot;
    }

    public BopContainer getBopRoot() {
        return this.bopRoot;
    }

    public LayoutableComponent locateComponent(LayoutableContainer cont, MouseEvent e) {
        return null;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public LayoutableContainer locateContainer(LayoutableContainer cont, MouseEvent e) {
        Point p = new Point();
        int n = 0;
        while (n < cont.componentCountBop()) {
            BopComponent comp = (BopComponent)cont.at(n);
            if (comp instanceof LayoutableContainer) {
                p.x = e.getX();
                p.y = e.getY();
                BopContainer.translatePoint((Component)((Object)cont), comp, p);
                if (comp.contains(p.x, p.y)) {
                    e.translatePoint(-e.getX(), -e.getY());
                    e.translatePoint(p.x, p.y);
                    return this.locateContainer((LayoutableContainer)cont.at(n), e);
                }
            }
            ++n;
        }
        return cont;
    }

    public BopSwingRoot() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.rootPane);
        this.bopRoot = new BopContainer();
        this.bopRoot.isTop = true;
        this.rootPane.getContentPane().setLayout(new BorderLayout());
        this.rootPane.getContentPane().add("Center", this.bopRoot);
        LayoutController lc = new LayoutController();
        this.bopRoot.setControllerBop(lc);
        lc.setLibraryRoot(this);
        lc.view = this.bopRoot;
        this.bopRoot.getControllerBop().binder().addTarget(this, "actionMenu");
        this.initMenu();
        this.rootPane.setGlassPane(new Glass());
        this.rootPane.getGlassPane().setVisible(true);
        MMA ml = new MMA();
        this.rootPane.getGlassPane().addMouseListener(ml);
        this.rootPane.getGlassPane().addMouseMotionListener(ml);
    }

    public BopSwingRoot(JPanel p) {
        this.rootPane.setDoubleBuffered(true);
        this.bopRoot = (BopContainer)BopComponent.New(p);
        this.bopRoot.isTop = true;
        this.rootPane.getContentPane().setLayout(new BorderLayout());
        this.rootPane.getContentPane().add("Center", this.bopRoot);
        this.bopRoot.getControllerBop().binder().addTarget(this, "actionMenu");
        p.setLayout(new BorderLayout());
        p.add("Center", this.rootPane);
        this.rootPane.setGlassPane(new Glass());
        this.rootPane.getGlassPane().setVisible(true);
        this.initMenu();
    }

    protected void initMenu() {
        JServiceMenuItem.ResetShortCutTab();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JPopupMenu main = new JPopupMenu("dummy");
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.addMenu(main, "Cut", "cut");
        this.addMenu(main, "Copy", "copy");
        this.addMenu(main, "Paste", "paste");
        this.addMenu(main, "Align To Grid", "align");
        this.addMenu(main, "To Front", "tofront");
        this.addMenu(main, "To Back", "toback");
        this.addMenu(main, "Customizer..", "customizer");
        this.pop = main;
    }

    protected void addMenu(JPopupMenu menu, String text, final String action) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BopSwingRoot.this.binder().notifyTargets(action);
            }
        });
        menu.add(item);
    }

    public Object actionMenu(Object arg, Object s) {
        if (arg instanceof ObjectValue) {
            Object a = ((IValue)arg).value();
            Tracer.This.println("actionMenu " + a + " " + s);
            if (a instanceof Object[] && ((Object[])a)[1] instanceof Point) {
                Point p = (Point)((Object[])a)[1];
                Tracer.This.println(p);
                if (this.trans != null) {
                    p.x = (int)((float)p.x * this.scale);
                    p.y = (int)((float)p.y * this.scale);
                }
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                this.pop.show((Component)((Object[])a)[0], p.x, p.y);
                JPopupMenu.setDefaultLightWeightPopupEnabled(true);
                Tracer.This.println("**** Damned buggy SwingPopup opened in nonlightweigt mode *****");
            }
        }
        return null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public float getScale() {
        return this.getScaleImpl();
    }

    private float getScaleImpl() {
        if (this.trans == null) {
            return 1.0f;
        }
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.trans = scale == 1.0f ? null : new AffineTransform(new float[]{scale, 0.0f, 0.0f, scale});
    }

    public Graphics transFormG(Graphics g) {
        if (this.trans == null) {
            return g;
        }
        ((Graphics2D)g).transform(this.trans);
        return g;
    }

    public int transFormInt(int p) {
        if (this.trans == null) {
            return p;
        }
        return (int)((float)p / this.scale);
    }

    public Dimension transFormDimension(Dimension p) {
        if (this.trans == null) {
            return p;
        }
        p.width = (int)((float)p.width / this.scale);
        p.height = (int)((float)p.height / this.scale);
        return p;
    }

    public Point transFormPoint(Point p) {
        if (this.trans == null) {
            return p;
        }
        p.x = (int)((float)p.x / this.scale);
        p.y = (int)((float)p.y / this.scale);
        return p;
    }

    public Rectangle transFormRectangle(Rectangle r) {
        if (this.trans == null) {
            return r;
        }
        r.x = (int)((float)r.x / this.scale);
        r.y = (int)((float)r.y / this.scale);
        r.width = (int)((float)r.width / this.scale);
        r.height = (int)((float)r.height / this.scale);
        return r;
    }

    public MouseEvent transFormEvent(MouseEvent ev) {
        if (this.trans == null) {
            return ev;
        }
        int x = ev.getX();
        int y = ev.getY();
        ev.translatePoint(-x, -y);
        ev.translatePoint((int)((float)x / this.scale), (int)((float)y / this.scale));
        return ev;
    }

    public void paint(Graphics g) {
        Graphics orig = g.create();
        g.setColor(this.getBackground());
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.trans != null) {
            ((Graphics2D)g).transform(this.trans);
        }
        super.paint(g);
        if (this.pageFormat != null && !IsPrinting) {
            int pageW = (int)(this.pageFormat.getImageableWidth() * (double)(1.0f / this.printRatio));
            int pageH = (int)(this.pageFormat.getImageableHeight() * (double)(1.0f / this.printRatio));
            orig.setColor(new Color(0, 0, 0, 64));
            int i = 0;
            while (i < 2) {
                orig.drawLine(pageW * (i + 1), 0, pageW * (i + 1), 3 * pageH);
                ++i;
            }
            int i2 = 0;
            while (i2 < 2) {
                orig.drawLine(0, pageH * (i2 + 1), pageW * 3, pageH * (i2 + 1));
                ++i2;
            }
        }
    }

    public void setPrintRatio(float printRatio) {
        this.printRatio = printRatio;
    }

    public float getPrintRatio() {
        return this.printRatio;
    }

    public Color getBackground() {
        return IsPrinting ? Color.white : super.getBackground();
    }

    public Dimension getSize() {
        if (this.trans == null) {
            return super.getSize();
        }
        Dimension d = super.getSize();
        d.width = (int)((float)d.width * this.scale);
        d.height = (int)((float)d.height * this.scale);
        return d;
    }

    public static void main(String[] arg) {
    }

    class Glass
    extends JComponent {
        Point off = new Point();

        Glass() {
        }

        public void calcOffset() {
            Point rpLoc = BopSwingRoot.this.rootPane.getLocationOnScreen();
            Point pLoc = BopSwingRoot.this.bopRoot.getLocationOnScreen();
            this.off.x = pLoc.x - rpLoc.x;
            this.off.y = pLoc.y - rpLoc.y;
        }

        public void paint(Graphics g) {
            this.calcOffset();
            g.translate(this.off.x, this.off.y);
            this.drawSelection(g);
        }

        public void drawSelection(Graphics g) {
            this.calcOffset();
            g.translate(this.off.x, this.off.y);
            g.setColor(Color.black);
            BopSwingRoot.this.bopRoot.drawSelections(BopSwingRoot.this.rootPane.getGlassPane(), g);
            BopSwingRoot.this.bopRoot.drawConnections(BopSwingRoot.this.rootPane.getGlassPane(), g);
        }
    }

    class MMA
    extends MouseAdapter
    implements MouseMotionListener {
        MMA() {
        }

        public void mouseDragged(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            if (lastDown != null) {
                BopContainer.translateEvent(BopSwingRoot.this.bopRoot, lastDown, e);
                lastDown.mouseDragged(e);
                e.consume();
                return;
            }
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mouseDragged(e);
            e.consume();
        }

        public void mouseMoved(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mouseMoved(e);
            e.consume();
        }

        public void mouseClicked(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent bopComponent = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
        }

        public void mouseReleased(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            if (lastDown != null) {
                BopContainer.translateEvent(BopSwingRoot.this.bopRoot, lastDown, e);
                lastDown.mouseReleased(e);
                e.consume();
                return;
            }
            lastDown = null;
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mouseReleased(e);
            e.consume();
        }

        public void mouseEntered(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mouseEntered(e);
            e.consume();
        }

        public void mouseExited(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mouseExited(e);
            e.consume();
        }

        public void mousePressed(MouseEvent e) {
            e = BopSwingRoot.this.transFormEvent(e);
            BopComponent cont = (BopComponent)BopSwingRoot.this.locateComponent(BopSwingRoot.this.bopRoot, e);
            cont = (BopComponent)((Object)BopSwingRoot.this.locateContainer(BopSwingRoot.this.bopRoot, e));
            cont.mousePressed(e);
            e.consume();
            lastDown = cont;
        }
    }
}

