/*
 * Decompiled with CFR 0.152.
 */
package layedit.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layedit.LayoutController;
import layedit.LayoutableComponent;
import layedit.LayoutableContainer;
import layedit.swing.BopComponent;
import layedit.swing.BopContainer;

public class BopTab
extends BopComponent
implements LayoutableContainer,
MouseListener,
MouseMotionListener,
ChangeListener {
    static BopContainer Dummy = (BopContainer)BopComponent.New((JComponent)new JPanel(), false);
    transient int actTabIndex = 0;

    public JTabbedPane tab() {
        return (JTabbedPane)this.getInner();
    }

    public BopContainer getActTab() {
        if (this.tab().getSelectedComponent() == null) {
            return Dummy;
        }
        return (BopContainer)this.tab().getSelectedComponent();
    }

    public LayoutableComponent getBopComponentFor(Object inner) {
        return this.getActTab().getBopComponentFor(inner);
    }

    public void stateChanged(ChangeEvent e) {
        try {
            BopContainer prev = (BopContainer)this.tab().getComponentAt(this.actTabIndex);
            if (prev == null) {
                return;
            }
            boolean isActive = prev.getControllerBop().isActiveController();
            boolean isSelected = prev.isSelectedBop();
            prev.getControllerBop().deselect();
            if (this.getActTab() == null) {
                return;
            }
            if (this.getActTab().getControllerBop() == null) {
                return;
            }
            this.getActTab().getControllerBop().setActiveController(isActive);
            if (!isActive) {
                this.getActTab().selectBop(isSelected);
            }
            this.actTabIndex = this.tab().getSelectedIndex();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void setInnerComponent(JComponent comp) {
        JTabbedPane tabs = (JTabbedPane)comp;
        int N = tabs.getTabCount();
        JComponent[] content = new JComponent[N];
        String[] names = new String[N];
        int n = 0;
        while (n < N) {
            tabs.getComponentAt(n).doLayout();
            names[n] = tabs.getTitleAt(n);
            content[n] = BopComponent.New((JComponent)tabs.getComponentAt(n), true);
            ++n;
        }
        tabs.removeAll();
        int n2 = 0;
        while (n2 < N) {
            tabs.addTab(names[n2], content[n2]);
            ++n2;
        }
        tabs.addChangeListener(this);
        super.setInnerComponent(comp);
    }

    public void selectBop(boolean b) {
        if (!b) {
            int max = this.serialCountBop();
            int n = 0;
            while (n < max) {
                this.serialAt(n).selectBop(false);
                ++n;
            }
            super.selectBop(false);
        } else {
            this.getActTab().selectBop(b);
        }
    }

    public boolean isSelectedBop() {
        return this.getActTab().isSelectedBop();
    }

    public void updateSelectionBop(LayoutableComponent lc) {
        this.getActTab().updateSelectionBop(lc);
    }

    public void setControllerBop(LayoutController control) {
        this.getActTab().setControllerBop(control);
    }

    public void remLayComponentBop(LayoutableComponent lc) {
        this.getActTab().remLayComponentBop(lc);
    }

    public void moveDragRectBop(int x, int y, int x1, int y1) {
        this.getActTab().moveDragRectBop(x, y, x1, y1);
    }

    public boolean isTopBop() {
        return this.getActTab().isTopBop();
    }

    public void hideDragRectBop() {
        this.getActTab().hideDragRectBop();
    }

    public LayoutController getControllerBop() {
        return this.getActTab().getControllerBop();
    }

    public int componentCountBop() {
        return this.getActTab().componentCountBop();
    }

    public boolean canDropBop(LayoutableComponent lc) {
        return this.getActTab().canDropBop(lc);
    }

    public LayoutableComponent serialAt(int n) {
        return (LayoutableComponent)((Object)this.tab().getComponentAt(n));
    }

    public int serialCountBop() {
        return this.tab().countComponents();
    }

    public LayoutableComponent at(int n) {
        return this.getActTab().at(n);
    }

    public void addLayComponentBop(int x, int y, LayoutableComponent lc) {
        this.getActTab().addLayComponentBop(x, y, lc);
    }

    public void addLayComponentBopZBack(int x, int y, LayoutableComponent lc) {
        this.getActTab().addLayComponentBopZBack(x, y, lc);
    }

    public void mouseReleased(MouseEvent e0) {
        MouseEvent e1 = new MouseEvent(this.tab(), e0.getID(), System.currentTimeMillis(), e0.getModifiers(), e0.getX(), e0.getY(), e0.getClickCount(), e0.isPopupTrigger());
        BopContainer.translateEvent(this, this.getActTab(), e0);
        if (this.getControllerBop().isActiveController()) {
            this.getActTab().mouseReleased(e0);
        } else {
            super.mouseReleased(e1);
        }
    }

    public void mousePressed(MouseEvent e0) {
        MouseEvent e1 = new MouseEvent(this.tab(), e0.getID(), System.currentTimeMillis(), e0.getModifiers(), e0.getX(), e0.getY(), e0.getClickCount(), e0.isPopupTrigger());
        BopContainer.translateEvent(this, this.getActTab(), e0);
        if (e0.getY() < 0 || e0.getX() < 0 || e0.getX() > this.getActTab().getSize().width || e0.getY() > this.getActTab().getSize().height) {
            this.tab().dispatchEvent(e1);
        } else if (this.getControllerBop().isActiveController()) {
            this.getActTab().mousePressed(e0);
        } else {
            super.mousePressed(e1);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.getControllerBop().isActiveController()) {
            BopContainer.translateEvent(this, this.getActTab(), e);
            this.getActTab().mouseExited(e);
        } else {
            super.mouseExited(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.getControllerBop().isActiveController()) {
            BopContainer.translateEvent(this, this.getActTab(), e);
            this.getActTab().mouseEntered(e);
        } else {
            super.mouseEntered(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.getControllerBop().isActiveController()) {
            BopContainer.translateEvent(this, this.getActTab(), e);
            this.getActTab().mouseClicked(e);
        } else {
            super.mouseClicked(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getControllerBop().isActiveController()) {
            BopContainer.translateEvent(this, this.getActTab(), e);
            this.getActTab().mouseMoved(e);
        } else {
            super.mouseMoved(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getControllerBop().isActiveController()) {
            BopContainer.translateEvent(this, this.getActTab(), e);
            this.getActTab().mouseDragged(e);
        } else {
            super.mouseDragged(e);
        }
    }

    public void drawSelections(Component glassPane, Graphics g) {
        Point p = new Point(0, 0);
        BopContainer.translatePoint(this, this.getActTab(), p);
        g.translate(-p.x, -p.y);
        this.getActTab().drawSelections(glassPane, g);
        g.translate(p.x, p.y);
    }
}

