/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import java.util.Enumeration;
import java.util.Vector;
import netcomputing.collections.ArrayEnumerator;
import netcomputing.collections.INCCollection;
import netcomputing.collections.INCDynArray;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.NCArrayEnumerator;
import netcomputing.collections.NCIndexedCollection;

public class NCArray
extends NCIndexedCollection
implements INCEnumerateable,
INCDynArray {
    public Object[] array;
    public int size;

    public NCArray(int initialCapacity) {
        this.array = new Object[initialCapacity];
        this.size = 0;
    }

    public NCArray(Object[] arr) {
        this(arr.length);
        this.addAll(arr);
    }

    public void setCapacity(int newSize) {
        Object[] newArray = new Object[newSize];
        this.size = this.size > newSize ? newSize : this.size;
        System.arraycopy(this.array, 0, newArray, 0, this.size);
        this.array = newArray;
    }

    public void ensureCapacity(int minCap) {
        if (this.array.length < minCap) {
            this.setCapacity(minCap);
        }
    }

    public void setSize(int newSize) {
        if (newSize > this.size) {
            this.ensureCapacity(newSize);
        } else {
            int n = newSize;
            while (n < this.size) {
                this.array[n] = null;
                ++n;
            }
        }
        this.size = newSize;
    }

    public Enumeration enumerate() {
        return new ArrayEnumerator(this);
    }

    public INCCollection add(Object o) {
        this.ensureCapacity((this.size + 1) * 3 / 2);
        this.array[this.size++] = o;
        return this;
    }

    public Object rem(Object o) {
        int i = this.indexOf(o);
        if (i >= 0) {
            Object tmp = this.at(i);
            this.remAt(i);
            return tmp;
        }
        return null;
    }

    public void remAll() {
        this.setSize(0);
    }

    public int size() {
        return this.size;
    }

    public int length() {
        return this.size;
    }

    public void remAt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " size " + this.size);
        }
        int l = this.size - index - 1;
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
        this.array[this.size] = null;
    }

    public void setAt(int index, Object o) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " size " + this.size);
        }
        this.array[index] = o;
    }

    public void insAfter(int index, Object o) {
        this.insAt(++index, o);
    }

    public INCDynArray insAt(int index, Object o) {
        if (index == this.size) {
            this.add(o);
        } else {
            if (index >= this.size) {
                throw new ArrayIndexOutOfBoundsException("index " + index + " size " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
            this.array[index] = o;
            ++this.size;
        }
        return this;
    }

    public void push(Object o) {
        this.add(o);
    }

    public Object pop() {
        Object res = this.last();
        if (res != null) {
            this.remAt(this.size() - 1);
        }
        return res;
    }

    public Object at(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " size " + this.size);
        }
        return this.array[index];
    }

    public void addAll(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    public void addAll(Vector v) {
        this.addAll(v.elements());
    }

    public void addAll(Object[] arr) {
        this.addAll(new NCArrayEnumerator(arr));
    }

    public INCEnumerateable copyDeep() {
        NCArray result = (NCArray)this.copyShallow();
        result.array = (Object[])this.array.clone();
        return result;
    }
}

