/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import java.util.Enumeration;
import netcomputing.collections.INCMappingCollection;
import netcomputing.collections.NCBasicCollection;
import netcomputing.collections.NotSupportedException;

public abstract class NCBasicHash
extends NCBasicCollection
implements INCMappingCollection {
    protected int size;

    public Object get(Object key) {
        int pos = this.locateIndex(key, false);
        return this.keyAt(pos) != null ? this.valueAt(pos) : null;
    }

    public INCMappingCollection put(Object key, Object value) {
        int pos = this.locateIndex(key, true);
        if (this.keyAt(pos) == null) {
            ++this.size;
        }
        this.setKeyValue(pos, key, value);
        return this;
    }

    public Object rem(Object keyOrg) {
        int pos = this.locateIndex(keyOrg, false);
        if (this.keyAt(pos) == null) {
            return null;
        }
        Object key = keyOrg;
        Object prev = this.valueAt(pos);
        Object item = null;
        this.setKeyValue(pos, null, null);
        --this.size;
        pos = (pos + 1) % this.getCapacity();
        while ((key = this.keyAt(pos)) != null) {
            item = this.valueAt(pos);
            if ((key.hashCode() * 7621 & Integer.MAX_VALUE) % this.getCapacity() != pos) {
                --this.size;
                this.setKeyValue(pos, null, null);
                this.put(key, item);
            }
            pos = (pos + 1) % this.getCapacity();
        }
        return prev;
    }

    public void remAll() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        int n = this.getCapacity() - 1;
        while (n >= 0) {
            this.setKeyValue(n, null, null);
            --n;
        }
    }

    public int size() {
        return this.size;
    }

    protected int locateIndex(Object key, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 / 2 >= this.getCapacity()) {
                try {
                    this.ensureCapacity(this.size * 2);
                }
                catch (NotSupportedException e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int cnt = 0;
        int pos = hpos = (key.hashCode() * 7621 & Integer.MAX_VALUE) % this.getCapacity();
        while (this.keyAt(pos) != null) {
            if (this.comparator.isEqual(key, this.keyAt(pos))) break;
            ++cnt;
            pos = (pos + 1) % this.getCapacity();
        }
        return pos;
    }

    abstract void ensureCapacity(int var1);

    abstract void setKeyValue(int var1, Object var2, Object var3);

    abstract Object keyAt(int var1);

    abstract Object valueAt(int var1);

    public abstract int getCapacity();

    public abstract Enumeration enumerate();

    public abstract Enumeration enumerateKeys();
}

