/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import de.netcomputing.util.Tracer;
import java.util.Enumeration;
import java.util.Hashtable;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.INCMappingCollection;
import netcomputing.collections.NCBasicHash;
import netcomputing.collections.NCComparator;
import netcomputing.collections.NCHashtableEnumerator;
import netcomputing.collections.NotSupportedException;
import netcomputing.collections.TestInt;
import netcomputing.collections.adaptors.NCHashtableAdaptor;

public class NCHashtable
extends NCBasicHash {
    Object[] keyVal;
    static int coll = 0;

    NCHashtable() {
    }

    public NCHashtable(int initialSize) {
        initialSize = Math.max(3, initialSize);
        this.keyVal = new Object[initialSize * 2];
    }

    public NCHashtable(int initialSize, NCComparator comp) {
        initialSize = Math.max(3, initialSize);
        this.keyVal = new Object[initialSize * 2];
        this.setComparator(comp);
    }

    public int locateIndex(Object key, boolean doGrow) {
        int hpos;
        block4: {
            if (doGrow && this.size * 3 >= this.keyVal.length) {
                try {
                    this.ensureCapacity(this.keyVal.length * 3 / 2);
                }
                catch (NotSupportedException e) {
                    if (this.size + 1 != this.getCapacity()) break block4;
                    throw new RuntimeException("unable to enlarge underlying collection " + this.size);
                }
            }
        }
        int cnt = 0;
        int pos = hpos = 2 * ((key.hashCode() * 7621 & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != null) {
            if (this.comparator.isEqual(key, this.keyVal[pos])) break;
            ++cnt;
            ++coll;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    void setKeyValue(int i, Object key, Object value) {
        this.keyVal[i << 1] = key;
        this.keyVal[(i << 1) + 1] = value;
    }

    Object keyAt(int i) {
        return this.keyVal[i << 1];
    }

    Object valueAt(int i) {
        return this.keyVal[(i << 1) + 1];
    }

    public int getCapacity() {
        return this.keyVal.length >> 1;
    }

    void ensureCapacity(int newCap) {
        if (this.keyVal.length <= newCap << 1) {
            Object[] old = this.keyVal;
            this.keyVal = new Object[newCap << 1];
            this.size = 0;
            int n = old.length - 2;
            while (n >= 0) {
                if (old[n] != null) {
                    this.put(old[n], old[n + 1]);
                }
                n -= 2;
            }
        }
    }

    public Enumeration enumerate() {
        return new NCHashtableEnumerator(this, false);
    }

    public Enumeration enumerateKeys() {
        return new NCHashtableEnumerator(this, true);
    }

    public NCHashtable inverseMap() {
        NCHashtable result = new NCHashtable(this.size() * 2);
        Enumeration en = this.enumerateKeys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = this.get(key);
            result.put(value, key);
        }
        return result;
    }

    public INCEnumerateable copyDeep() {
        NCHashtable res = new NCHashtable();
        res.keyVal = new Object[this.keyVal.length];
        System.arraycopy(this.keyVal, 0, res.keyVal, 0, this.keyVal.length);
        res.size = this.size;
        return res;
    }

    public INCEnumerateable copyShallow() {
        try {
            return (INCEnumerateable)this.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] aeg) {
        int si = 15000;
        int xx = 0;
        while (xx < 5) {
            INCMappingCollection ht = new NCHashtableAdaptor(si / 2);
            long tim = System.currentTimeMillis();
            int n = 0;
            while (n < si) {
                ht.put(new TestInt(n), new TestInt(n));
                ++n;
            }
            int n2 = 0;
            while (n2 < si) {
                if (((TestInt)ht.get(new TestInt(n2))).intValue() != n2) {
                    Tracer.This.println("error at index " + n2);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < si) {
                ht.rem(new TestInt(n3));
                ++n3;
            }
            Tracer.This.println("util.Hashtable mit Wrapper tim=" + (System.currentTimeMillis() - tim));
            ht = new NCHashtable(si / 2);
            tim = System.currentTimeMillis();
            int n4 = 0;
            while (n4 < si) {
                ht.put(new TestInt(n4), new TestInt(n4));
                ++n4;
            }
            int n5 = 0;
            while (n5 < si) {
                if (((TestInt)ht.get(new TestInt(n5))).intValue() != n5) {
                    Tracer.This.println("error at index " + n5);
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < si) {
                ht.rem(new TestInt(n6));
                ++n6;
            }
            Tracer.This.println("NCHashtable tim=" + (System.currentTimeMillis() - tim) + " " + coll);
            Hashtable<TestInt, TestInt> uht = new Hashtable<TestInt, TestInt>(si / 2);
            tim = System.currentTimeMillis();
            int n7 = 0;
            while (n7 < si) {
                uht.put(new TestInt(n7), new TestInt(n7));
                ++n7;
            }
            int n8 = 0;
            while (n8 < si) {
                if (((TestInt)uht.get(new TestInt(n8))).intValue() != n8) {
                    Tracer.This.println("error at index " + n8);
                }
                ++n8;
            }
            int n9 = 0;
            while (n9 < si) {
                uht.remove(new TestInt(n9));
                ++n9;
            }
            Tracer.This.println("util.Hashtable tim=" + (System.currentTimeMillis() - tim));
            ++xx;
        }
    }
}

