/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

public class NCIntStack {
    public int[] stack;
    public int stackCnt = 0;

    NCIntStack() {
    }

    public NCIntStack(int size) {
        this.stack = new int[size];
    }

    public NCIntStack copyDeep() {
        NCIntStack res = new NCIntStack();
        res.stack = (int[])this.stack.clone();
        res.stackCnt = this.stackCnt;
        return res;
    }

    public int top() {
        return this.stack[this.stackCnt - 1];
    }

    public int top(int i) {
        return this.stack[this.stackCnt - 1 - i];
    }

    public int topIndex() {
        return this.stackCnt - 1;
    }

    public int at(int i) {
        if (i >= this.stackCnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.stack[i];
    }

    public void decAt(int i) {
        if (i >= this.stackCnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = i;
        this.stack[n] = this.stack[n] - 1;
    }

    public void incAt(int i) {
        if (i >= this.stackCnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = i;
        this.stack[n] = this.stack[n] + 1;
    }

    public void setAt(int i, int value) {
        if (i >= this.stackCnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.stack[i] = value;
    }

    public int pop() {
        --this.stackCnt;
        if (this.stackCnt < 0) {
            return -1;
        }
        return this.stack[this.stackCnt];
    }

    public void push(int i) {
        if (this.stack.length <= this.stackCnt) {
            int[] old = this.stack;
            this.stack = new int[old.length * 2];
            System.arraycopy(old, 0, this.stack, 0, old.length);
        }
        this.stack[this.stackCnt++] = i;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.stackCnt;
    }

    public void setSize(int siz) {
        this.stackCnt = siz;
    }
}

