/*
 * Decompiled with CFR 0.152.
 */
package plugins.javac;

import JCollections.DirIterator;
import JCollections.JArray;
import JCollections.JUnsafeTable;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.util.Tracer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import util.ClassFile;

public class DependencyFinder {
    String classesDir;
    JUnsafeTable clMap;
    JUnsafeTable packMap;

    public DependencyFinder(String clDir) {
        this.classesDir = clDir;
    }

    void initFromSource() {
    }

    public void dumpDependMap(JUnsafeTable map) {
        Enumeration en = map.keys();
        while (en.hasMoreElements()) {
            String p = (String)en.nextElement();
            Tracer.This.println(p + "====================");
            Enumeration e1 = ((JUnsafeTable)map.get(p)).keys();
            while (e1.hasMoreElements()) {
                Tracer.This.println("      " + e1.nextElement());
            }
        }
    }

    void initFromCache() {
        boolean read = false;
        if (new File(this.classesDir + File.separator + "depcache").exists()) {
            Tracer.This.println("READING DEPCACHE");
            try {
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.classesDir + File.separator + "depcache")));
                this.clMap = (JUnsafeTable)in.readObject();
                in.close();
                read = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!read) {
            Tracer.This.println("WRITING DEPCACHE");
            this.clMap = new JUnsafeTable(2000);
            this.calcReverseDependence(this.classesDir, this.clMap);
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.classesDir + File.separator + "depcache"));
                out.writeObject(this.clMap);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    String pathToClazz(String clFile) {
        return clFile.replace(File.separatorChar, '.').substring(0, clFile.length() - 6);
    }

    public JUnsafeTable calcPackCardinality(String pack, JUnsafeTable packMap) {
        JUnsafeTable cont = (JUnsafeTable)packMap.get(pack);
        return cont;
    }

    public Hashtable calcCardinality(String fqClazz, JUnsafeTable clMap, Hashtable visited) {
        if (visited == null) {
            visited = new Hashtable<String, Boolean>(1000);
        }
        if (visited.containsKey(fqClazz)) {
            return visited;
        }
        visited.put(fqClazz, Boolean.TRUE);
        JUnsafeTable cont = (JUnsafeTable)clMap.get(fqClazz);
        if (cont != null && cont.size() > 0) {
            Enumeration en = cont.keys();
            while (en.hasMoreElements()) {
                String cl = this.pathToClazz((String)en.nextElement());
                int i = cl.indexOf("$");
                if (i >= 0) {
                    cl = cl.substring(0, i);
                }
                this.calcCardinality(cl, clMap, visited);
            }
        }
        return visited;
    }

    public void removePack(String pack, JUnsafeTable packMap) {
        Tracer.This.println("REMOVEPACK:" + pack);
        packMap.remove(pack);
        Enumeration en = packMap.elements();
        while (en.hasMoreElements()) {
            JUnsafeTable tab = (JUnsafeTable)en.nextElement();
            if (tab == null) continue;
            tab.remove(pack);
        }
    }

    public String findIslandPackage(JUnsafeTable packMap) {
        int min = 99999;
        String minPk = null;
        Enumeration en = packMap.keys();
        while (en.hasMoreElements()) {
            int card;
            String pk = (String)en.nextElement();
            if (minPk == null) {
                minPk = pk;
            }
            if ((card = this.calcPackCardinality(pk, packMap).size()) >= min) continue;
            min = card;
            minPk = pk;
        }
        Tracer.This.println("MINPK:" + minPk);
        return minPk;
    }

    public void updateCache() {
        new File(this.classesDir + File.separator + "depcache").delete();
        this.initFromCache();
    }

    public void calcPackDependenceFromSource(String sourceDir, JUnsafeTable result) {
        this.calcPackDependenceFromSource(sourceDir, result, true);
    }

    public void expandPackDependendMap(JUnsafeTable packMap) {
        boolean change = false;
        do {
            change = false;
            Enumeration en = packMap.keys();
            while (en.hasMoreElements()) {
                String actP = (String)en.nextElement();
                JUnsafeTable actCont = (JUnsafeTable)packMap.get(actP);
                Tracer.This.println("EXPANDING ======================" + actP);
                JUnsafeTable cont = (JUnsafeTable)actCont.clone();
                if (cont != null) {
                    Enumeration contEn = cont.keys();
                    while (contEn.hasMoreElements()) {
                        String actContPack = (String)contEn.nextElement();
                        JUnsafeTable toAdd = (JUnsafeTable)packMap.get(actContPack);
                        if (toAdd != null) {
                            Enumeration enToAdd = toAdd.keys();
                            while (enToAdd.hasMoreElements()) {
                                Object o = enToAdd.nextElement();
                                if (!actCont.containsKey(o)) {
                                    change = true;
                                }
                                actCont.put(o, Boolean.TRUE);
                            }
                            continue;
                        }
                        Tracer.This.println("NO MAPENTRY:" + actContPack);
                    }
                    continue;
                }
                Tracer.This.println("NO MAPENTRY _1:" + actP);
            }
        } while (change);
    }

    public void calcPackDependenceFromSource(String sourceDir, JUnsafeTable result, boolean rec) {
        int baselen = new File(sourceDir).getAbsolutePath().length();
        Vector files = DirIterator.DirContent(new File(sourceDir), ".java", rec);
        int n = 0;
        while (n < files.size()) {
            JArray v = new JArray(15);
            TextDocument doc = new TextDocument((File)files.elementAt(n));
            DocumentStream.ScanImports(doc, v);
            String pack = DocumentStream.ScanPackage(doc);
            JUnsafeTable toAdd = (JUnsafeTable)result.get(pack);
            if (toAdd == null) {
                toAdd = new JUnsafeTable(20);
                result.put(pack, toAdd);
            }
            int nn = 0;
            while (nn < v.size()) {
                String s = (String)v.at(nn);
                toAdd.put(s, Boolean.TRUE);
                ++nn;
            }
            ++n;
        }
    }

    void calcReverseDependence(String classesDir, JUnsafeTable result) {
        int baselen = new File(classesDir).getAbsolutePath().length();
        Vector files = DirIterator.DirContent(new File(classesDir), ".class");
        int n = 0;
        while (n < files.size()) {
            ClassFile cf = new ClassFile();
            try {
                FileInputStream in = new FileInputStream((File)files.elementAt(n));
                cf.read(new BufferedInputStream(in, 10000));
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Vector v = cf.getImports();
            int nn = 0;
            while (nn < v.size()) {
                JUnsafeTable toAdd;
                String s = (String)v.elementAt(nn);
                int i = s.indexOf("$");
                if (i >= 0) {
                    s = s.substring(0, i);
                }
                if ((toAdd = (JUnsafeTable)result.get(s)) == null) {
                    toAdd = new JUnsafeTable(20);
                    result.put(s, toAdd);
                }
                String finam = ((File)files.elementAt(n)).getAbsolutePath().substring(baselen + 1);
                toAdd.put(finam, Boolean.TRUE);
                ++nn;
            }
            ++n;
        }
    }

    public static void main(String[] args) {
        String pk;
        long tim = System.currentTimeMillis();
        Tracer.This.println("CALC:");
        DependencyFinder dpf = new DependencyFinder("d:\\work\\anyj\\winproject\\classes_fr");
        Tracer.This.println("TIME:" + (System.currentTimeMillis() - tim));
        tim = System.currentTimeMillis();
        Tracer.This.println(dpf.calcCardinality("editapp.EditApp", dpf.clMap, null).size());
        Tracer.This.println("TIME:" + (System.currentTimeMillis() - tim));
        JUnsafeTable eapp = (JUnsafeTable)dpf.clMap.get("editapp.EditApp");
        JArray arr = new JArray(100);
        arr.addAll(eapp.keys());
        arr.sort();
        int n = 0;
        while (n < arr.size()) {
            Tracer.This.println(arr.at(n));
            ++n;
        }
        tim = System.currentTimeMillis();
        JUnsafeTable packMap = new JUnsafeTable(1000);
        dpf.calcPackDependenceFromSource("D:\\jdks\\ibm1.1.8\\src", packMap);
        Tracer.This.println("TIME:" + (System.currentTimeMillis() - tim));
        Tracer.This.println("NUM OF PACK ===============" + packMap.size());
        Enumeration en = packMap.keys();
        while (en.hasMoreElements()) {
            pk = (String)en.nextElement();
            Tracer.This.println("card " + pk + ":" + dpf.calcPackCardinality(pk, packMap).size());
        }
        packMap = new JUnsafeTable(1000);
        dpf.calcPackDependenceFromSource("D:\\work\\anyj\\source", packMap);
        Tracer.This.println("TIME:" + (System.currentTimeMillis() - tim));
        Tracer.This.println("NUM OF PACK ===============" + packMap.size());
        en = packMap.keys();
        while (en.hasMoreElements()) {
            pk = (String)en.nextElement();
            Tracer.This.println("card " + pk + ":" + dpf.calcPackCardinality(pk, packMap).size());
        }
        eapp = (JUnsafeTable)packMap.get("editapp");
        arr = new JArray(100);
        arr.addAll(eapp.keys());
        arr.sort();
        int n2 = 0;
        while (n2 < arr.size()) {
            Tracer.This.println(arr.at(n2));
            ++n2;
        }
    }
}

