/*
 * Decompiled with CFR 0.152.
 */
package plugins.vcontrolui;

import JCollections.ISortFunc;
import JCollections.JUnsafeArray;
import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.JWArrayTableModel;
import de.netcomputing.anyj.jwidgets.JWValueEditor;
import de.netcomputing.anyj.jwidgets.NCTableView;
import java.text.DateFormat;
import java.util.Date;
import versioncontrol.FileDiffEntry;

class DiffTableModel
extends JWArrayTableModel {
    DiffTableModel() {
    }

    public void init(JUnsafeArray fileEntries, long minDate, long maxDate, String subComment, int minChange) {
        String[] tit = new String[]{"File     ", "Date       ", "Comment       ", "Diffs", "Dir            "};
        this.titles = tit;
        this.lines = new JUnsafeArray(fileEntries.size());
        DateFormat format = DateFormat.getDateTimeInstance();
        int n = 0;
        while (n < fileEntries.size()) {
            FileDiffEntry fd = (FileDiffEntry)fileEntries.at(n);
            if (fd.date > minDate && fd.date < maxDate && fd.directions.length > minChange && (subComment == null || subComment.length() == 0 || fd.comment.lastIndexOf(subComment) >= 0)) {
                Object[] line = new Object[6];
                line[0] = VFile.NameWithExtension(fd.fileName);
                line[1] = format.format(new Date(fd.date));
                line[2] = fd.comment;
                line[4] = VFile.ExtractDir(fd.fileName);
                line[3] = fd.directions.length + "";
                line[5] = fd;
                this.lines.add(line);
            }
            ++n;
        }
    }

    protected ISortFunc getSortFuncRow(final int col) {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return ((Object[])a)[col].toString().compareTo(((Object[])b)[col].toString()) >= 0;
            }
        };
    }

    public JWValueEditor requestEditAt(int x, int y, NCTableView tv) {
        return null;
    }
}

