/******************************************************
 * File: Main.java
 * created 04.06.2001 11:14:48 by Ruediger Moeller
 */
package de.netcomputing.sample.zipextractor;
import java.util.*;
import java.io.*;
import java.util.zip.*;
import de.netcomputing.sample.filechooser.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;                                                            
import java.awt.*;
import de.netcomputing.runtime.*;

public class Main extends JPanel
{
	//$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
	JProgressBar progressBar;
	JButton exctractBtn;
	FileChooserBean destDir;
	FileChooserBean srcFile;
	//$$$endVars    -----------------------------------------------------------
	
	public Main()
	{
		initGui();
	}

	public void initGui()
	{
		new MainGUI().createGui( this );
		validateState();
		
		// Note: Due to a bug in the JDK 1.3 (DocumentEvent is not a subclass of EventObject)
		// the DocumentListener's methods are not recognized as valid event handlers
		// as specified by the Java Beans Documentation. Therefore these eventhandlers can't be
		// added from withing our beans-based GUIBuilder.
		// We register eventhandlers manually... 
		destDir.addDocumentListener( new DocumentListener() {
				public void insertUpdate(DocumentEvent e) { destinationChanged(); }
				public void removeUpdate(DocumentEvent e) { destinationChanged(); }
				public void changedUpdate(DocumentEvent e){ destinationChanged(); }
			});
		srcFile.addDocumentListener( new DocumentListener() {
				public void insertUpdate(DocumentEvent e) { srcChanged(); }
				public void removeUpdate(DocumentEvent e) { srcChanged(); }
				public void changedUpdate(DocumentEvent e){ srcChanged(); }
			});
	}
	
	void destinationChanged()
	{
		 validateState();
	}
	
	void validateState()
	{
		File src = new File( srcFile.getText() );
		File dest = new File( destDir.getText() );
		exctractBtn.setEnabled( 
			 src.exists() && 
			 ! src.isDirectory() &&
			 destDir.getText().trim().length() > 0 &&
			 !( dest.exists() && ! dest.isDirectory() ) 
		);
	}		
	
	void srcChanged()
	{
		File src = new File( srcFile.getText() );
		destDir.setText( src.getParent()+File.separator+src.getName()+".unpacked" );
		validateState();
	}
	
	/**
	* locate and load the image, replace code below to avoid the need of
	* a runtime library (ApplicationHelper)
	*/
	public Image getImageForBuilder( String imageName, String packageAsPath )
	{
		// load via classpath from de.netcomputing.sample.zipextractor/images/imageName.gif
		// resp. /images/imageName.gif (2cnd lookup)
		return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
	}
	
	public static void main( String[] args )
	{
		JFrame fr = ApplicationHelper.Singleton().createFrameOn( new Main() );
		fr.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		fr.setVisible( true );
	}
	
	int fullCount = 0;
	void extractFile( ZipFile zf, File target ) throws IOException
	{
		fullCount = 0;
		progressBar.setString( "counting entries.." );
		Enumeration en = zf.entries();
		while( en.hasMoreElements() )
		{
			fullCount++; en.nextElement();
			if ( fullCount%100 == 0 )
				progressBar.setString( "counting entries.."+fullCount );
		}
		progressBar.setMaximum( fullCount );
		progressBar.setMinimum( 0 );
		progressBar.setValue( 0 );
		progressBar.setString( "unpacking" );
		fullCount = 0 ;
		en = zf.entries();
		while( en.hasMoreElements() )
		{
			ZipEntry ze = (ZipEntry)en.nextElement();
			copyInputStream( zf, ze, target );
		}
		progressBar.setString( "finished" );
		progressBar.setValue(0);
	}
	
	void copyInputStream( ZipFile zf, ZipEntry ze, File base ) throws IOException
	{
		progressBar.setValue( fullCount++ );
		String s = ze.getName();
		int i = s.lastIndexOf('/');
		if ( i >= 0 )
			s = s.substring(i);
		progressBar.setString( s );
		OutputStream out = null;
		try {
			if ( ! ze.getName().endsWith( "/" ) )
			{
				String target = base.getAbsolutePath()+File.separator+ze.getName().replace( '/', File.separatorChar );
				InputStream in = zf.getInputStream( ze );
				File tr = new File( target ).getParentFile();
				boolean res = tr.mkdirs();
				
				out = new BufferedOutputStream( new FileOutputStream( target ), 20000 );
				{
					int c = 0;
					int count = 0;
					while( (c = in.read()) >= 0 )
					{
						out.write( c );
					}
				}
			}
		} finally {
			if ( out != null )
				out.close();
		}
	}
	
	
	//$$$actions

	public void exctractBtn_actionPerformed( ActionEvent var0 )
	{
		(new Thread() { public void run() {
					try {
						exctractBtn.setEnabled( false );
						destDir.setEnabled(false);
						srcFile.setEnabled(false);
						File out = new File( destDir.getText().trim() );
						out.mkdirs();
						ZipFile zf = new ZipFile( srcFile.getText().trim() );
						if ( ! out.exists() )
							throw new RuntimeException( "failed to create directory:"+destDir.getText() );
						extractFile( zf, out );
						zf.close();
					} catch ( Throwable ex ) {
						JOptionPane.showMessageDialog( Main.this, ex.getMessage() );
						ex.printStackTrace();
					} finally {
						exctractBtn.setEnabled( true );
						destDir.setEnabled(true);
						srcFile.setEnabled(true);
					}
				}}).start();
	}

}
