/******************************************************
 * File: RunBoth.java
 * created 22.04.2002 13:57:52 by ruedi
 */
package sample;
import sample.client.*;
import sample.server.*;

/**
 * A helper class to run both: the client and the server in one VM instance
 * to ease debugging.<br> 
 * <br>
 * 1. compile everything <br>
 * 2. run rmic (ensure the server side class is added to the set of RMI classes <br>
 * 3. run rmiregistry from the 'Tools|External Tools|rmiregistry menu <br>
 * 4. start this class using -Djava.rmi.server.codebase=file:/($outputdir)/ as aditional parameter <br>
 * <br>
 * the rmiregistry has to be started once, rmic must be run again only if the interface class implemented by
 * the server side class has been changed.
 */
public class RunBoth
{
	
	public static void main( String[] args ) {
		($objectname)Server.main( new String[] { "localhost" } );
		($objectname)Client.main( new String[] { "localhost" } );
	}

}
