/******************************************************
 * File: CCCRemove.java
 * created 04.03.2002 11:56:36 by moelrue
 */
package harvestgui.scripts;
import de.netcomputing.anyj.scripting.*;
import harvestgui.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class CCCRemove extends AJExternalService
{ 
    public CCCRemove() {
    }
    
    static boolean IsRunning;
    
    public boolean canProcessSelection( Object selection )
    {
        if( selection != null )
        {
            if ( selection instanceof File && ! IsRunning && ! ((File)selection).isDirectory() )
            {
                File cur = (File)selection;
                String curS = cur.getAbsolutePath();
                if ( curS.toLowerCase().startsWith( (""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).toLowerCase() ) )
                {
                    return true;  
                }
            }
        }
        return false;
    }
    
    Object lastSel;
    public void doProcess( Object selection )
    {
        IsRunning = true;
        lastSel = selection;
        (new Thread() { public void run() {
                    String pack = CCCGet.pack;
                    String outName = "";
                    // check the environment is set up
                    Hashtable ht = AnyJAPI.This().getEnvironment();
                    if ( ht.get( "ccch_user" ) == null ||
                        ht.get( "ccch_pwd" ) == null ||
                        ht.get( "ccch_repository" ) == null ||
                        ht.get( "ccch_project" ) == null ||
                        ht.get( "ccch_localroot" ) == null )
                    {
                        JOptionPane.showMessageDialog( AnyJAPI.This().getMainWindow(), new String[] {
                                "Please specify:",
                                "ccch_user (e.g. moelrue)",
                                "ccch_pwd (e.g. tryst)",
                                "ccch_repository (e.g. xeomoon/XE)",
                                "ccch_project (e.g. XAPI)",
                                "ccch_localroot  (e.g. d:\\work\\dev\\cccharvest)",
                                "in AnyJ's user environment"
                            });
                    } else {
                        File dir = (File)lastSel;
                        String fiName;
                        if ( dir.isDirectory() )
                        {
                            fiName = "*";
                        }
                        else
                        {
                            fiName = dir.getName();
                            dir = dir.getParentFile();
                        }
                        String reposRoot = dir.getAbsolutePath().substring((""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).length());
                        String cline = "";
                        outName = "CCC REMOVE";
                        String proj = CCCGet.proj;
                        if ( proj == null )
                            proj = (String)AnyJAPI.This().getEnvironment().get("ccch_project");
                        String[] projPack = CCCGet.FindAJHarvestSigFile( dir );
                        if ( projPack != null )
                        {
                            proj = projPack[0];
                            pack = projPack[1];
                        }
                        CheckIn res = CheckIn.ShowCheckInPanel( 
                            AnyJAPI.This().getMainWindow(), 
                            proj,
                            pack,
                            fiName,
                            false
                        );
                        if ( res == null )
                        {
                            IsRunning = false;
                            return;
                        }
                        else
                            pack = res.getPackage();
                        String comment = res.getComment().trim();
                        proj = res.getProject().trim();
                        CCCGet.pack = pack;
                        CCCGet.proj = proj;
                        {
                            cline = 
                            "hri -vp "+reposRoot/*"\\XAPI\\src\\java\\XgenPi\\de\\exchange\\xgen\\"*/+
                            /*" -cp "+dir.getAbsolutePath()+*/
                            " -b "+AnyJAPI.This().getEnvironment().get("ccch_repository") +
                            " -usr "+AnyJAPI.This().getEnvironment().get("ccch_user")+
                            " -pw " +AnyJAPI.This().getEnvironment().get("ccch_pwd")+
                            " -en "+proj+" -st \"Implementation Phase\" "
                            +" -p "+pack+" "+fiName;
                            AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( "" );
                            AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( cline );
                            AnyJAPI.This().executeExternalProcess( outName, File.separator, cline );
                            int result = JOptionPane.showConfirmDialog( AnyJAPI.This().getMainWindow(), "Delete local Copy ?" );
                            if ( result == JOptionPane.OK_OPTION )
                                new File( dir, fiName ).delete();
                        } 
                        try {
                            DataInputStream in = new DataInputStream( new FileInputStream( File.separator+"hri.log" ) );
                            String s = null;
                            while( (s=in.readLine()) != null )
                                AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( s );
                            in.close();
                        } catch ( Exception ex ) {
                            ex.printStackTrace();
                        }
                        AnyJAPI.This().updateFileTree();
                    }
                    
                    AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( "--DONE--" );
                    AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( "" );
                    IsRunning = false;
                }
            
            }).start();
    }

}
